/*
 * Copyright (c) 2022, 2025 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

module org.glassfish.jersey.media.moxy {
    requires java.logging;

    requires jakarta.ws.rs;
    requires jakarta.annotation;
    requires jakarta.inject;

    requires static jakarta.xml.bind;

    requires org.glassfish.jersey.core.common;
    requires org.glassfish.jersey.ext.entity.filtering;

    requires org.eclipse.persistence.core;
    requires org.eclipse.persistence.moxy;

    exports org.glassfish.jersey.moxy.internal;
    exports org.glassfish.jersey.moxy.json;
    exports org.glassfish.jersey.moxy.json.internal to
            org.glassfish.hk2.locator,
            org.glassfish.hk2.utilities,
            org.glassfish.jersey.core.client,
            org.glassfish.jersey.core.common,
            org.glassfish.jersey.incubator.cdi.inject.weld,
            org.glassfish.jersey.inject.cdi2.se,
            weld.core.impl;

    exports org.glassfish.jersey.moxy.xml;

    opens org.glassfish.jersey.moxy.internal;
    opens org.glassfish.jersey.moxy.json;
    opens org.glassfish.jersey.moxy.json.internal to
            org.glassfish.hk2.locator,
            org.glassfish.hk2.utilities,
            org.glassfish.jersey.core.client,
            org.glassfish.jersey.core.common,
            org.glassfish.jersey.incubator.cdi.inject.weld,
            org.glassfish.jersey.inject.cdi2.se,
            weld.core.impl;
    opens org.glassfish.jersey.moxy.xml;

    provides org.glassfish.jersey.internal.spi.AutoDiscoverable with
            org.glassfish.jersey.moxy.json.internal.MoxyJsonAutoDiscoverable;
}