
package org.glassfish.jersey.media.sse;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.media.sse.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableOUT_EVENT_NOT_BUILDABLE() {
        return messageFactory.getMessage("out.event.not.buildable");
    }

    /**
     * Cannot build outbound event. Either a comment or non-null event data must be set.
     * 
     */
    public static String OUT_EVENT_NOT_BUILDABLE() {
        return localizer.localize(localizableOUT_EVENT_NOT_BUILDABLE());
    }

    public static Localizable localizableEVENT_SOURCE_DEFAULT_ONERROR() {
        return messageFactory.getMessage("event.source.default.onerror");
    }

    /**
     * Subscriber.onError() called on subscriber with no registered error handler.
     * 
     */
    public static String EVENT_SOURCE_DEFAULT_ONERROR() {
        return localizer.localize(localizableEVENT_SOURCE_DEFAULT_ONERROR());
    }

    public static Localizable localizablePARAM_NULL(Object arg0) {
        return messageFactory.getMessage("param.null", arg0);
    }

    /**
     * "{0}" parameter is null.
     * 
     */
    public static String PARAM_NULL(Object arg0) {
        return localizer.localize(localizablePARAM_NULL(arg0));
    }

    public static Localizable localizableOUT_EVENT_MEDIA_TYPE_NULL() {
        return messageFactory.getMessage("out.event.media.type.null");
    }

    /**
     * Outbound event data media type must not be explicitly set to 'null'.
     * 
     */
    public static String OUT_EVENT_MEDIA_TYPE_NULL() {
        return localizer.localize(localizableOUT_EVENT_MEDIA_TYPE_NULL());
    }

    public static Localizable localizablePARAMS_NULL() {
        return messageFactory.getMessage("params.null");
    }

    /**
     * One or more of parameters is null.
     * 
     */
    public static String PARAMS_NULL() {
        return localizer.localize(localizablePARAMS_NULL());
    }

    public static Localizable localizableEVENT_DATA_READER_NOT_FOUND() {
        return messageFactory.getMessage("event.data.reader.not.found");
    }

    /**
     * Message body reader not found for the SSE event data.
     * 
     */
    public static String EVENT_DATA_READER_NOT_FOUND() {
        return localizer.localize(localizableEVENT_DATA_READER_NOT_FOUND());
    }

    public static Localizable localizableIN_EVENT_FIELD_NOT_RECOGNIZED(Object arg0, Object arg1) {
        return messageFactory.getMessage("in.event.field.not.recognized", arg0, arg1);
    }

    /**
     * Inbound event field [{0}: {1}] is not a recognized SSE field name and will be ignored.
     * 
     */
    public static String IN_EVENT_FIELD_NOT_RECOGNIZED(Object arg0, Object arg1) {
        return localizer.localize(localizableIN_EVENT_FIELD_NOT_RECOGNIZED(arg0, arg1));
    }

    public static Localizable localizableUNSUPPORTED_WEBTARGET_TYPE(Object arg0) {
        return messageFactory.getMessage("unsupported.webtarget.type", arg0);
    }

    /**
     * Argument {0} is not a valid JerseyWebTarget instance. SseEventSource does not support other WebTarget implementations.
     * 
     */
    public static String UNSUPPORTED_WEBTARGET_TYPE(Object arg0) {
        return localizer.localize(localizableUNSUPPORTED_WEBTARGET_TYPE(arg0));
    }

    public static Localizable localizableEVENT_SOURCE_ALREADY_CONNECTED() {
        return messageFactory.getMessage("event.source.already.connected");
    }

    /**
     * This event source is already open.
     * 
     */
    public static String EVENT_SOURCE_ALREADY_CONNECTED() {
        return localizer.localize(localizableEVENT_SOURCE_ALREADY_CONNECTED());
    }

    public static Localizable localizableEVENT_SINK_CLOSE_FAILED() {
        return messageFactory.getMessage("event.sink.close.failed");
    }

    /**
     * Closing EventSink failed. Could not close chunked output.
     * 
     */
    public static String EVENT_SINK_CLOSE_FAILED() {
        return localizer.localize(localizableEVENT_SINK_CLOSE_FAILED());
    }

    public static Localizable localizableIN_EVENT_RETRY_PARSE_ERROR(Object arg0) {
        return messageFactory.getMessage("in.event.retry.parse.error", arg0);
    }

    /**
     * Unable to parse inbound event retry value [{0}] as decimal number.
     * 
     */
    public static String IN_EVENT_RETRY_PARSE_ERROR(Object arg0) {
        return localizer.localize(localizableIN_EVENT_RETRY_PARSE_ERROR(arg0));
    }

    public static Localizable localizableEVENT_SOURCE_SHUTDOWN_INTERRUPTED(Object arg0) {
        return messageFactory.getMessage("event.source.shutdown.interrupted", arg0);
    }

    /**
     * Waiting for the event source executor for [{0}] to shutdown has been interrupted.
     * 
     */
    public static String EVENT_SOURCE_SHUTDOWN_INTERRUPTED(Object arg0) {
        return localizer.localize(localizableEVENT_SOURCE_SHUTDOWN_INTERRUPTED(arg0));
    }

    public static Localizable localizableOUT_EVENT_DATA_NULL() {
        return messageFactory.getMessage("out.event.data.null");
    }

    /**
     * Outbound event data must not be explicitly set to 'null'.
     * 
     */
    public static String OUT_EVENT_DATA_NULL() {
        return localizer.localize(localizableOUT_EVENT_DATA_NULL());
    }

    public static Localizable localizableEVENT_SOURCE_SHUTDOWN_TIMEOUT(Object arg0) {
        return messageFactory.getMessage("event.source.shutdown.timeout", arg0);
    }

    /**
     * Attempt to shutdown the event source executor for [{0}] has timed out.
     * 
     */
    public static String EVENT_SOURCE_SHUTDOWN_TIMEOUT(Object arg0) {
        return localizer.localize(localizableEVENT_SOURCE_SHUTDOWN_TIMEOUT(arg0));
    }

    public static Localizable localizableEVENT_SOURCE_OPEN_CONNECTION_INTERRUPTED() {
        return messageFactory.getMessage("event.source.open.connection.interrupted");
    }

    /**
     * Waiting for opening the event source connection has been interrupted.
     * 
     */
    public static String EVENT_SOURCE_OPEN_CONNECTION_INTERRUPTED() {
        return localizer.localize(localizableEVENT_SOURCE_OPEN_CONNECTION_INTERRUPTED());
    }

    public static Localizable localizableOUT_EVENT_DATA_TYPE_NULL() {
        return messageFactory.getMessage("out.event.data.type.null");
    }

    /**
     * Outbound event data type must not be explicitly set to 'null'.
     * 
     */
    public static String OUT_EVENT_DATA_TYPE_NULL() {
        return localizer.localize(localizableOUT_EVENT_DATA_TYPE_NULL());
    }

    public static Localizable localizableEVENT_SOURCE_ALREADY_CLOSED() {
        return messageFactory.getMessage("event.source.already.closed");
    }

    /**
     * This event source has already been closed.
     * 
     */
    public static String EVENT_SOURCE_ALREADY_CLOSED() {
        return localizer.localize(localizableEVENT_SOURCE_ALREADY_CLOSED());
    }

}
