/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.oauth2;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.ReaderInterceptor;
import org.glassfish.jersey.client.oauth2.ClientIdentifier;
import org.glassfish.jersey.client.oauth2.OAuth2ClientFeature;
import org.glassfish.jersey.client.oauth2.OAuth2CodeGrantFlow;
import org.glassfish.jersey.client.oauth2.OAuth2Parameters;
import org.glassfish.jersey.client.oauth2.TokenResult;
import org.glassfish.jersey.client.oauth2.internal.LocalizationMessages;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.message.MessageBodyWorkers;

class AuthCodeGrantImpl
implements OAuth2CodeGrantFlow {
    private final String accessTokenUri;
    private final String authorizationUri;
    private final String refreshTokenUri;
    private final ClientIdentifier clientIdentifier;
    private final Client client;
    private final Map<String, String> authorizationProperties;
    private final Map<String, String> accessTokenProperties;
    private final Map<String, String> refreshTokenProperties;
    private volatile TokenResult tokenResult;

    private AuthCodeGrantImpl(String authorizationUri, String accessTokenUri, String redirectUri, String refreshTokenUri, ClientIdentifier clientIdentifier, String scope, Client client, Map<String, String> authorizationProperties, Map<String, String> accessTokenProperties, Map<String, String> refreshTokenProperties) {
        this.accessTokenUri = accessTokenUri;
        this.authorizationUri = authorizationUri;
        this.authorizationProperties = authorizationProperties;
        this.accessTokenProperties = accessTokenProperties;
        this.refreshTokenProperties = refreshTokenProperties;
        this.refreshTokenUri = refreshTokenUri != null ? refreshTokenUri : accessTokenUri;
        this.clientIdentifier = clientIdentifier;
        this.client = this.configureClient(client);
        this.initDefaultProperties(redirectUri, scope);
    }

    private Client configureClient(Client client) {
        Configuration config;
        if (client == null) {
            client = ClientBuilder.newClient();
        }
        if (!(config = client.getConfiguration()).isRegistered(DefaultTokenMessageBodyReader.class)) {
            client.register(DefaultTokenMessageBodyReader.class);
        }
        if (!config.isRegistered(JacksonFeature.class)) {
            client.register(JacksonFeature.class);
        }
        return client;
    }

    private void setDefaultProperty(String key, String value, Map<String, String> ... properties) {
        if (value == null) {
            return;
        }
        for (Map<String, String> props : properties) {
            if (props.get(key) != null) continue;
            props.put(key, value);
        }
    }

    private void initDefaultProperties(String redirectUri, String scope) {
        this.setDefaultProperty("response_type", "code", this.authorizationProperties);
        this.setDefaultProperty("client_id", this.clientIdentifier.getClientId(), this.authorizationProperties, this.accessTokenProperties, this.refreshTokenProperties);
        this.setDefaultProperty("redirect_uri", redirectUri == null ? "urn:ietf:wg:oauth:2.0:oob" : redirectUri, this.authorizationProperties, this.accessTokenProperties);
        this.setDefaultProperty("state", UUID.randomUUID().toString(), this.authorizationProperties);
        this.setDefaultProperty("scope", scope, this.authorizationProperties);
        this.setDefaultProperty("client_secret", this.clientIdentifier.getClientSecret(), this.accessTokenProperties, this.refreshTokenProperties);
        this.setDefaultProperty("grant_type", OAuth2Parameters.GrantType.AUTHORIZATION_CODE.name().toLowerCase(Locale.ROOT), this.accessTokenProperties);
        this.setDefaultProperty("grant_type", OAuth2Parameters.GrantType.REFRESH_TOKEN.name().toLowerCase(Locale.ROOT), this.refreshTokenProperties);
    }

    @Override
    public String start() {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)this.authorizationUri);
        for (Map.Entry<String, String> entry : this.authorizationProperties.entrySet()) {
            uriBuilder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
        }
        return uriBuilder.build(new Object[0]).toString();
    }

    @Override
    public TokenResult finish(String authorizationCode, String state) {
        if (!this.authorizationProperties.get("state").equals(state)) {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_FLOW_WRONG_STATE());
        }
        this.accessTokenProperties.put("code", authorizationCode);
        Form form = new Form();
        for (Map.Entry<String, String> entry : this.accessTokenProperties.entrySet()) {
            form.param(entry.getKey(), entry.getValue());
        }
        Response response = this.client.target(this.accessTokenUri).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        if (response.getStatus() != 200) {
            throw new ProcessingException(LocalizationMessages.ERROR_FLOW_REQUEST_ACCESS_TOKEN(response.getStatus()));
        }
        this.tokenResult = (TokenResult)response.readEntity(TokenResult.class);
        return this.tokenResult;
    }

    @Override
    public TokenResult refreshAccessToken(String refreshToken) {
        this.refreshTokenProperties.put("refresh_token", refreshToken);
        Form form = new Form();
        for (Map.Entry<String, String> entry : this.refreshTokenProperties.entrySet()) {
            form.param(entry.getKey(), entry.getValue());
        }
        Response response = this.client.target(this.refreshTokenUri).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        if (response.getStatus() != 200) {
            throw new ProcessingException(LocalizationMessages.ERROR_FLOW_REQUEST_REFRESH_TOKEN(response.getStatus()));
        }
        this.tokenResult = (TokenResult)response.readEntity(TokenResult.class);
        return this.tokenResult;
    }

    @Override
    public Client getAuthorizedClient() {
        return (Client)ClientBuilder.newClient().register((Object)this.getOAuth2Feature());
    }

    @Override
    public Feature getOAuth2Feature() {
        if (this.tokenResult == null) {
            throw new IllegalStateException(LocalizationMessages.ERROR_FLOW_NOT_FINISHED());
        }
        return new OAuth2ClientFeature(this.tokenResult.getAccessToken());
    }

    static class DefaultTokenMessageBodyReader
    implements MessageBodyReader<TokenResult> {
        @Inject
        private Provider<MessageBodyWorkers> workers;
        @Inject
        private Provider<PropertiesDelegate> propertiesDelegateProvider;
        private static Iterable<ReaderInterceptor> EMPTY_INTERCEPTORS = new ArrayList<ReaderInterceptor>();

        DefaultTokenMessageBodyReader() {
        }

        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return type.equals(TokenResult.class);
        }

        public TokenResult readFrom(Class<TokenResult> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            GenericType<Map<String, Object>> mapType = new GenericType<Map<String, Object>>(){};
            Map map = (Map)((MessageBodyWorkers)this.workers.get()).readFrom(mapType.getRawType(), mapType.getType(), annotations, mediaType, httpHeaders, (PropertiesDelegate)this.propertiesDelegateProvider.get(), entityStream, EMPTY_INTERCEPTORS, false);
            return new TokenResult(map);
        }
    }

    static class Builder
    implements OAuth2CodeGrantFlow.Builder {
        private String accessTokenUri;
        private String refreshTokenUri;
        private String authorizationUri;
        private String callbackUri;
        private ClientIdentifier clientIdentifier;
        private Client client;
        private String scope;
        private Map<String, String> authorizationProperties = new HashMap<String, String>();
        private Map<String, String> accessTokenProperties = new HashMap<String, String>();
        private Map<String, String> refreshTokenProperties = new HashMap<String, String>();

        public Builder() {
        }

        public Builder(ClientIdentifier clientIdentifier, String authorizationUri, String accessTokenUri) {
            this();
            this.accessTokenUri = accessTokenUri;
            this.authorizationUri = authorizationUri;
            this.clientIdentifier = clientIdentifier;
        }

        public Builder(ClientIdentifier clientIdentifier, String authorizationUri, String accessTokenUri, String callbackUri) {
            this();
            this.accessTokenUri = accessTokenUri;
            this.authorizationUri = authorizationUri;
            this.callbackUri = callbackUri;
            this.clientIdentifier = clientIdentifier;
        }

        public Builder accessTokenUri(String accessTokenUri) {
            this.accessTokenUri = accessTokenUri;
            return this;
        }

        public Builder authorizationUri(String authorizationUri) {
            this.authorizationUri = authorizationUri;
            return this;
        }

        public Builder redirectUri(String redirectUri) {
            this.callbackUri = redirectUri;
            return this;
        }

        public Builder clientIdentifier(ClientIdentifier clientIdentifier) {
            this.clientIdentifier = clientIdentifier;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder client(Client client) {
            this.client = client;
            return this;
        }

        public Builder refreshTokenUri(String refreshTokenUri) {
            this.refreshTokenUri = refreshTokenUri;
            return this;
        }

        public Builder property(OAuth2CodeGrantFlow.Phase phase, String key, String value) {
            phase.property(key, value, this.authorizationProperties, this.accessTokenProperties, this.refreshTokenProperties);
            return this;
        }

        String getAccessTokenUri() {
            return this.accessTokenUri;
        }

        String getRefreshTokenUri() {
            return this.refreshTokenUri;
        }

        String getAuthorizationUri() {
            return this.authorizationUri;
        }

        String getScope() {
            return this.scope;
        }

        String getCallbackUri() {
            return this.callbackUri;
        }

        ClientIdentifier getClientIdentifier() {
            return this.clientIdentifier;
        }

        Client getClient() {
            return this.client;
        }

        Map<String, String> getAuthorizationProperties() {
            return this.authorizationProperties;
        }

        Map<String, String> getAccessTokenProperties() {
            return this.accessTokenProperties;
        }

        Map<String, String> getRefreshTokenProperties() {
            return this.refreshTokenProperties;
        }

        @Override
        public AuthCodeGrantImpl build() {
            return new AuthCodeGrantImpl(this.authorizationUri, this.accessTokenUri, this.callbackUri, this.refreshTokenUri, this.clientIdentifier, this.scope, this.client, this.authorizationProperties, this.accessTokenProperties, this.refreshTokenProperties);
        }
    }
}

