/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json.jaxrs1x;

import jakarta.json.Json;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonStructure;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/json", "text/json", "*/*"})
public class JsonStructureBodyReader
implements MessageBodyReader<JsonStructure> {
    private final JsonReaderFactory rf = Json.createReaderFactory(null);
    private static final String JSON = "json";
    private static final String PLUS_JSON = "+json";

    public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return JsonStructure.class.isAssignableFrom(aClass) && JsonStructureBodyReader.supportsMediaType(mediaType);
    }

    private static boolean supportsMediaType(MediaType mediaType) {
        return mediaType.getSubtype().equals(JSON) || mediaType.getSubtype().endsWith(PLUS_JSON);
    }

    public JsonStructure readFrom(Class<JsonStructure> jsonStructureClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> stringStringMultivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        try (JsonReader reader = this.rf.createReader(inputStream);){
            JsonStructure jsonStructure = reader.read();
            return jsonStructure;
        }
    }
}

