/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json.jaxrs1x;

import jakarta.json.Json;
import jakarta.json.JsonStructure;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/json", "text/json", "*/*"})
public class JsonStructureBodyWriter
implements MessageBodyWriter<JsonStructure> {
    private static final String JSON = "json";
    private static final String PLUS_JSON = "+json";
    private JsonWriterFactory wf = Json.createWriterFactory(null);

    @PostConstruct
    private void init() {
        this.wf = Json.createWriterFactory(new HashMap());
    }

    public boolean isWriteable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return JsonStructure.class.isAssignableFrom(aClass) && JsonStructureBodyWriter.supportsMediaType(mediaType);
    }

    private static boolean supportsMediaType(MediaType mediaType) {
        return mediaType.getSubtype().equals(JSON) || mediaType.getSubtype().endsWith(PLUS_JSON);
    }

    public long getSize(JsonStructure jsonStructure, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(JsonStructure jsonStructure, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> stringObjectMultivaluedMap, OutputStream outputStream) throws IOException, WebApplicationException {
        try (JsonWriter writer = this.wf.createWriter(outputStream);){
            writer.write(jsonStructure);
        }
    }
}

