/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.modularity.command;

import com.sun.enterprise.config.modularity.ConfigModularityUtils;
import com.sun.enterprise.config.modularity.annotation.CustomConfiguration;
import com.sun.enterprise.config.modularity.command.AbstractConfigModularityCommand;
import com.sun.enterprise.config.modularity.customization.ConfigBeanDefaultValue;
import com.sun.enterprise.config.modularity.customization.ConfigCustomizationToken;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.DomainExtension;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.config.ConfigExtension;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Dom;

@TargetType(value={CommandTarget.DAS, CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.STANDALONE_INSTANCE})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="create-module-config")
@PerLookup
@I18n(value="create.module.config")
public final class CreateModuleConfigCommand
extends AbstractConfigModularityCommand
implements AdminCommand,
AdminCommandSecurity.Preauthorization,
AdminCommandSecurity.AccessCheckProvider {
    private final Logger LOG = Logger.getLogger(CreateModuleConfigCommand.class.getName());
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateModuleConfigCommand.class);
    @Inject
    private ConfigModularityUtils configModularityUtils;
    @Inject
    private Domain domain;
    @Inject
    StartupContext startupContext;
    @Inject
    ServiceLocator serviceLocator;
    @Param(optional=true, defaultValue="false", name="dryRun")
    private Boolean dryRun;
    @Param(optional=true, defaultValue="false", name="all")
    private Boolean isAll;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    ServerEnvironmentImpl serverenv;
    @Param(optional=true, name="serviceName", primary=true)
    private String serviceName;
    private ActionReport report;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void execute(AdminCommandContext context) {
        if (!this.isAll.booleanValue() && this.serviceName == null) {
            this.report.setMessage(CreateModuleConfigCommand.localStrings.getLocalString("create.module.config.no.service.no.all", "No service name specified and the --all is not used either. Showing all default configurations not merged with domain configuration under target {0}.", new Object[]{this.target}));
            try {
                defaultConfigurationElements = this.getAllDefaultConfigurationElements(this.target);
                if (defaultConfigurationElements == null) ** GOTO lbl90
                this.report.setMessage(defaultConfigurationElements);
            }
            catch (Exception e) {
                msg = CreateModuleConfigCommand.localStrings.getLocalString("create.module.config.failure", "Failed to execute the command due to: {0}. For more details check the log file.", new Object[]{e.getLocalizedMessage()});
                this.LOG.log(Level.INFO, msg, e);
                this.report.setMessage(msg);
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setFailureCause((Throwable)e);
                return;
            }
        } else if (this.isAll.booleanValue() && this.dryRun.booleanValue()) {
            this.report.setMessage(CreateModuleConfigCommand.localStrings.getLocalString("create.module.config.show.all", "Showing all default configurations not merged with domain configuration under target {0}.", new Object[]{this.target}));
            try {
                defaultConfigurationElements = this.getAllDefaultConfigurationElements(this.target);
                if (defaultConfigurationElements == null) ** GOTO lbl90
                this.report.setMessage(defaultConfigurationElements);
            }
            catch (Exception e) {
                msg = CreateModuleConfigCommand.localStrings.getLocalString("create.module.config.show.all.failed", "Failed to show all default configurations not merged with domain configuration under target {0} due to: {1}.", new Object[]{this.target, e.getLocalizedMessage()});
                this.LOG.log(Level.INFO, msg, e);
                this.report.setMessage(msg);
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setFailureCause((Throwable)e);
                return;
            }
        } else {
            if (this.isAll.booleanValue() && !this.dryRun.booleanValue()) {
                this.report.appendMessage(CreateModuleConfigCommand.localStrings.getLocalString("create.module.config.creating.all", "Creating all default configuration elements that are not present in the domain.xml under target {0}.", new Object[]{this.target}));
                this.report.appendMessage(CreateModuleConfigCommand.LINE_SEPARATOR);
                e = this.configModularityUtils;
                synchronized (e) {
                    oldv = this.configModularityUtils.isCommandInvocation();
                    try {
                        this.configModularityUtils.setCommandInvocation(true);
                        this.createAllMissingElements(this.report);
                    }
                    catch (Exception e) {
                        msg = CreateModuleConfigCommand.localStrings.getLocalString("create.module.config.creating.all.failed", "Failed to create all default configuration elements that are not present in the domain.xml under target {0} due to: {1}.", new Object[]{this.target, e.getLocalizedMessage()});
                        this.LOG.log(Level.INFO, msg, e);
                        this.report.setMessage(msg);
                        this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        this.report.setFailureCause((Throwable)e);
                        return;
                    }
                    finally {
                        this.configModularityUtils.setCommandInvocation(oldv);
                    }
                }
            }
            if (this.serviceName != null) {
                className = this.configModularityUtils.convertConfigElementNameToClassName(this.serviceName);
                configBeanType = this.configModularityUtils.getClassFor(this.serviceName);
                if (configBeanType == null) {
                    msg = CreateModuleConfigCommand.localStrings.getLocalString("create.module.config.not.such.a.service.found", "A ConfigBean of type {0} which translates to your service name\\'s configuration elements does not exist.", new Object[]{className, this.serviceName});
                    this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    this.report.setMessage(msg);
                    return;
                }
                var5_14 = this.configModularityUtils;
                synchronized (var5_14) {
                    oldv = this.configModularityUtils.isCommandInvocation();
                    try {
                        if (this.dryRun.booleanValue()) {
                            serviceDefaultConfig = this.getDefaultConfigFor(configBeanType);
                            if (serviceDefaultConfig != null) {
                                this.report.setMessage(serviceDefaultConfig);
                            }
                        } else {
                            this.configModularityUtils.setCommandInvocation(true);
                            this.createMissingElementFor(configBeanType, this.report);
                        }
                    }
                    catch (Exception e) {
                        msg = CreateModuleConfigCommand.localStrings.getLocalString("create.module.config.creating.for.service.name.failed", "Failed to create module configuration for {0} under the target {1} due to: {2}.", new Object[]{this.serviceName, this.target, e.getMessage()});
                        this.LOG.log(Level.INFO, msg, e);
                        this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        this.report.setMessage(msg);
                        this.report.setFailureCause((Throwable)e);
                        return;
                    }
                    finally {
                        this.configModularityUtils.setCommandInvocation(oldv);
                    }
                }
            }
        }
lbl90:
        // 8 sources

        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean createMissingElementFor(Class configBeanType, ActionReport report) throws Exception {
        boolean defaultConfigCreated = false;
        if (ConfigExtension.class.isAssignableFrom(configBeanType)) {
            if (this.config.checkIfExtensionExists(configBeanType)) {
                report.appendMessage(localStrings.getLocalString("create.module.config.already.exists", "Configuration for {0} already exists. The command didn't change the existing configuration.", new Object[]{Dom.convertName((String)configBeanType.getSimpleName())}));
                report.appendMessage(LINE_SEPARATOR);
                return false;
            }
            this.config.getExtensionByType(configBeanType);
            report.appendMessage(localStrings.getLocalString("create.module.config.done", "Configuration for {0} added to domain.xml", new Object[]{Dom.convertName((String)configBeanType.getSimpleName())}));
            report.appendMessage(LINE_SEPARATOR);
            defaultConfigCreated = true;
        } else if (configBeanType.isAssignableFrom(DomainExtension.class)) {
            if (this.domain.checkIfExtensionExists(configBeanType)) {
                report.appendMessage(localStrings.getLocalString("create.module.config.already.exists", "Configuration for {0} already exists. The command didn't change the existing configuration.", new Object[]{Dom.convertName((String)configBeanType.getSimpleName())}));
                report.appendMessage(LINE_SEPARATOR);
                return false;
            }
            this.domain.getExtensionByType(configBeanType);
            report.appendMessage(localStrings.getLocalString("create.module.config.done", "Configuration for {0} added to domain.xml", new Object[]{Dom.convertName((String)configBeanType.getSimpleName())}));
            report.appendMessage(LINE_SEPARATOR);
            defaultConfigCreated = true;
        }
        return defaultConfigCreated;
    }

    private String getDefaultConfigFor(Class configBeanType) throws Exception {
        if (!this.configModularityUtils.hasCustomConfig(configBeanType)) {
            return this.configModularityUtils.serializeConfigBeanByType(configBeanType);
        }
        List<ConfigBeanDefaultValue> defaults = this.configModularityUtils.getDefaultConfigurations(configBeanType, this.configModularityUtils.getRuntimeTypePrefix(this.serverenv.getStartupContext()));
        StringBuilder builder = new StringBuilder();
        for (ConfigBeanDefaultValue value : defaults) {
            builder.append(localStrings.getLocalString("at.location", "At Location: "));
            builder.append(this.replaceExpressionsWithValues(value.getLocation()));
            String substituted = this.replacePropertiesWithDefaultValues(value.getCustomizationTokens(), value.getXmlConfiguration());
            builder.append(substituted);
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    private String replacePropertiesWithDefaultValues(List<ConfigCustomizationToken> tokens, String xmlConfig) {
        for (ConfigCustomizationToken token : tokens) {
            String toReplace = "\\$\\{" + token.getName() + "\\}";
            xmlConfig = xmlConfig.replaceAll(toReplace, token.getValue());
        }
        return xmlConfig;
    }

    private void createAllMissingElements(ActionReport report) throws Exception {
        List<Class> clzs = this.configModularityUtils.getAnnotatedConfigBeans(CustomConfiguration.class);
        for (Class clz : clzs) {
            this.createMissingElementFor(clz, report);
        }
    }

    private String getAllDefaultConfigurationElements(String target) throws Exception {
        List<Class> clzs = this.configModularityUtils.getAnnotatedConfigBeans(CustomConfiguration.class);
        StringBuilder sb = new StringBuilder();
        for (Class clz : clzs) {
            sb.append(this.getDefaultConfigFor(clz));
        }
        return sb.toString();
    }

    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        Class configBeanType = null;
        if (this.serviceName == null && this.isAll.booleanValue()) {
            ArrayList<AccessRequired.AccessCheck> l = new ArrayList<AccessRequired.AccessCheck>();
            List<Class> clzs = this.configModularityUtils.getAnnotatedConfigBeans(CustomConfiguration.class);
            for (Class clz : clzs) {
                List<ConfigBeanDefaultValue> configBeanDefaultValueList = this.configModularityUtils.getDefaultConfigurations(clz, this.configModularityUtils.getRuntimeTypePrefix(this.startupContext));
                l.addAll(this.getAccessChecksForDefaultValue(configBeanDefaultValueList, this.target, Arrays.asList("read", "create", "delete")));
            }
            return l;
        }
        if (this.serviceName == null) {
            return Collections.emptyList();
        }
        configBeanType = this.configModularityUtils.getClassFor(this.serviceName);
        if (configBeanType == null) {
            return Collections.emptyList();
        }
        if (this.configModularityUtils.hasCustomConfig(configBeanType)) {
            List<ConfigBeanDefaultValue> defaults = this.configModularityUtils.getDefaultConfigurations(configBeanType, this.configModularityUtils.getRuntimeTypePrefix(this.serverenv.getStartupContext()));
            return this.getAccessChecksForDefaultValue(defaults, this.target, Arrays.asList("read"));
        }
        if (ConfigExtension.class.isAssignableFrom(configBeanType)) {
            return this.getAccessChecksForConfigBean((ConfigBeanProxy)this.config.getExtensionByType(configBeanType), this.target, Arrays.asList("read", "create", "delete"));
        }
        if (configBeanType.isAssignableFrom(DomainExtension.class)) {
            return this.getAccessChecksForConfigBean((ConfigBeanProxy)this.domain.getExtensionByType(configBeanType), this.target, Arrays.asList("read", "create", "delete"));
        }
        return Collections.emptyList();
    }

    public boolean preAuthorization(AdminCommandContext context) {
        this.report = context.getActionReport();
        if (this.target != null) {
            Config newConfig = this.getConfigForName(this.target, this.serviceLocator, this.domain);
            if (newConfig != null) {
                this.config = newConfig;
            }
            if (this.config == null) {
                this.report.setMessage(localStrings.getLocalString("create.module.config.target.name.invalid", "The target name specified is invalid. Please double check the target name and try again"));
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return false;
            }
        }
        if (this.isAll.booleanValue() && this.serviceName != null) {
            this.report.setMessage(localStrings.getLocalString("create.module.config.service.name.ignored", "One of the --all service name parameters can be used at a time. These two options can not be used together."));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }
}

