/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.security.store.DomainScopedPasswordAliasStore;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.config.support.Strings;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigView;

public class TranslatedConfigView
implements ConfigView {
    static final Pattern p = Pattern.compile("([^\\$]*)\\$\\{([^\\}]*)\\}([^\\$]*)");
    private static final String ALIAS_TOKEN = "ALIAS";
    private static int MAX_SUBSTITUTION_DEPTH = 100;
    final ConfigView masterView;
    static ServiceLocator habitat;
    private static DomainScopedPasswordAliasStore domainPasswordAliasStore;

    public static Object getTranslatedValue(Object value) {
        if (value != null && value instanceof String) {
            int i;
            String stringValue = value.toString();
            if (stringValue.indexOf(36) == -1) {
                return value;
            }
            if (TranslatedConfigView.domainPasswordAliasStore() != null && TranslatedConfigView.getAlias(stringValue) != null) {
                try {
                    return TranslatedConfigView.getRealPasswordFromAlias(stringValue);
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().severe(Strings.get("TranslatedConfigView.aliaserror", stringValue, e.getLocalizedMessage()));
                    return stringValue;
                }
            }
            Matcher m = p.matcher(stringValue);
            String origValue = stringValue;
            for (i = 0; m.find() && i < MAX_SUBSTITUTION_DEPTH; ++i) {
                String newValue = System.getProperty(m.group(2).trim());
                if (newValue == null) continue;
                stringValue = m.replaceFirst(Matcher.quoteReplacement(m.group(1) + newValue + m.group(3)));
                m.reset(stringValue);
            }
            if (i >= MAX_SUBSTITUTION_DEPTH) {
                Logger.getAnonymousLogger().severe(Strings.get("TranslatedConfigView.badprop", i, origValue));
            }
            return stringValue;
        }
        return value;
    }

    TranslatedConfigView(ConfigView master) {
        this.masterView = master;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return TranslatedConfigView.getTranslatedValue(this.masterView.invoke(proxy, method, args));
    }

    public ConfigView getMasterView() {
        return this.masterView;
    }

    public void setMasterView(ConfigView view) {
    }

    public <T extends ConfigBeanProxy> Class<T> getProxyType() {
        return this.masterView.getProxyType();
    }

    public <T extends ConfigBeanProxy> T getProxy(Class<T> proxyType) {
        return (T)((ConfigBeanProxy)proxyType.cast(Proxy.newProxyInstance(proxyType.getClassLoader(), new Class[]{proxyType}, (InvocationHandler)((Object)this))));
    }

    public static void setHabitat(ServiceLocator h) {
        habitat = h;
    }

    private static synchronized DomainScopedPasswordAliasStore domainPasswordAliasStore() {
        if (domainPasswordAliasStore == null) {
            domainPasswordAliasStore = (DomainScopedPasswordAliasStore)habitat.getService(DomainScopedPasswordAliasStore.class, new Annotation[0]);
        }
        return domainPasswordAliasStore;
    }

    public static String getAlias(String propName) {
        int lastIdx;
        String aliasName = null;
        String starter = "${ALIAS=";
        String ender = "}";
        if ((propName = propName.trim()).startsWith(starter) && propName.endsWith(ender) && (lastIdx = (propName = propName.substring(starter.length())).length() - 1) > 1 && (propName = propName.substring(0, lastIdx)) != null) {
            aliasName = propName.trim();
        }
        return aliasName;
    }

    public static String getRealPasswordFromAlias(String at) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String an = TranslatedConfigView.getAlias(at);
        boolean exists = domainPasswordAliasStore.containsKey(an);
        if (!exists) {
            String msg = String.format("Alias  %s does not exist", an);
            throw new IllegalArgumentException(msg);
        }
        String real = new String(domainPasswordAliasStore.get(an));
        return real;
    }

    static {
        domainPasswordAliasStore = null;
    }
}

