/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.GFLauncherConstants;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.launcher.GFLauncherLogger;
import com.sun.enterprise.admin.launcher.GFLauncherNativeHelper;
import com.sun.enterprise.admin.launcher.JavaConfig;
import com.sun.enterprise.admin.launcher.JvmOptions;
import com.sun.enterprise.admin.launcher.Profiler;
import com.sun.enterprise.universal.collections.CollectionUtils;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;

public abstract class GFLauncher {
    private static final LocalStringsImpl strings = new LocalStringsImpl(GFLauncher.class);
    private GFLauncherInfo callerParameters;
    private Map<String, String> asenvProps;
    private JavaConfig domainXMLjavaConfig;
    private List<String> domainXMLjavaConfigDebugOptions;
    private int debugPort = -1;
    private boolean debugSuspend;
    private JvmOptions domainXMLjvmOptions;
    private List<String> domainXMLJvmOptionsAsList = new ArrayList<String>();
    private Profiler domainXMLJavaConfigProfiler;
    private Map<String, String> domainXMLSystemProperty;
    private String javaExe;
    private String classpath;
    private String adminFileRealmKeyFile;
    private boolean secureAdminEnabled;
    private String logFilename;
    private boolean logFilenameWasFixed;
    private boolean setupCalledByClients;
    private boolean needsAutoUpgrade;
    private boolean needsManualUpgrade;
    private LaunchType mode = LaunchType.normal;
    private List<String> commandLine = new ArrayList<String>();
    private long startTime;
    private Process glassFishProcess;
    private ProcessWhacker processWhacker;
    private ProcessStreamDrainer processStreamDrainer;
    private int exitValue = -1;

    GFLauncher(GFLauncherInfo info) {
        this.callerParameters = info;
    }

    public final void launch() throws GFLauncherException {
        try {
            this.startTime = System.currentTimeMillis();
            if (!this.setupCalledByClients) {
                this.setup();
            }
            this.internalLaunch();
        }
        catch (GFLauncherException gfe) {
            throw gfe;
        }
        catch (Throwable t) {
            throw new GFLauncherException(strings.get("unknownError", new Object[]{t.getMessage()}), t);
        }
        finally {
            GFLauncherLogger.removeLogFileHandler();
        }
    }

    public final void relaunch() throws GFLauncherException {
        this.setupCalledByClients = false;
        this.launch();
    }

    public final void launchJVM(List<String> cmdsIn) throws GFLauncherException {
        try {
            this.setup();
            LinkedList<String> commands = new LinkedList<String>();
            commands.add(this.javaExe);
            for (String cmd : cmdsIn) {
                commands.add(cmd);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(commands);
            Process process = processBuilder.start();
            ProcessStreamDrainer.drain((String)"launchJVM", (Process)process);
        }
        catch (GFLauncherException gfe) {
            throw gfe;
        }
        catch (Throwable t) {
            throw new GFLauncherException(strings.get("unknownError", new Object[]{t.getMessage()}), t);
        }
        finally {
            GFLauncherLogger.removeLogFileHandler();
        }
    }

    public void setup() throws GFLauncherException, MiniXmlParserException {
        this.asenvProps = this.getAsEnvConfReader().getProps();
        this.callerParameters.setup();
        this.setupLogLevels();
        MiniXmlParser domainXML = new MiniXmlParser(this.getInfo().getConfigFile(), this.getInfo().getInstanceName());
        String domainName = domainXML.getDomainName();
        if (GFLauncherUtils.ok((String)domainName)) {
            this.callerParameters.setDomainName(domainName);
        }
        this.callerParameters.setAdminAddresses(domainXML.getAdminAddresses());
        this.domainXMLjavaConfig = new JavaConfig(domainXML.getJavaConfig());
        this.setupProfilerAndJvmOptions(domainXML);
        this.setupUpgradeSecurity();
        Map realmprops = domainXML.getAdminRealmProperties();
        if (realmprops != null) {
            String classname = (String)realmprops.get("classname");
            String keyfile = (String)realmprops.get("file");
            if ("com.sun.enterprise.security.auth.realm.file.FileRealm".equals(classname) && keyfile != null) {
                this.adminFileRealmKeyFile = keyfile;
            }
        }
        this.secureAdminEnabled = domainXML.getSecureAdminEnabled();
        this.renameOsgiCache();
        this.setupMonitoring(domainXML);
        this.domainXMLSystemProperty = domainXML.getSystemProperties();
        this.asenvProps.put("com.sun.aas.instanceRoot", this.getInfo().getInstanceRootDir().getPath());
        String javaHome = this.domainXMLjavaConfig.getJavaHome();
        if (GFLauncherUtils.ok((String)javaHome) && !javaHome.trim().equals("${com.sun.aas.javaRoot}")) {
            this.asenvProps.put("com.sun.aas.javaRoot", javaHome);
        }
        this.domainXMLjavaConfigDebugOptions = this.getDebugOptionsFromDomainXMLJavaConfig();
        this.parseJavaConfigDebugOptions();
        domainXML.setupConfigDir(this.getInfo().getConfigDir(), this.getInfo().getInstallDir());
        this.setLogFilename(domainXML);
        this.resolveAllTokens();
        this.fixLogFilename();
        GFLauncherLogger.addLogFileHandler(this.logFilename, this.callerParameters);
        this.setJavaExecutable();
        this.setClasspath();
        this.setCommandLine();
        this.setJvmOptions();
        this.logCommandLine();
        this.needsAutoUpgrade = !domainXML.hasNetworkConfig();
        this.needsManualUpgrade = !domainXML.hasDefaultConfig();
        this.setupCalledByClients = true;
    }

    public final GFLauncherInfo getInfo() {
        return this.callerParameters;
    }

    public String getAdminRealmKeyFile() {
        return this.adminFileRealmKeyFile;
    }

    public boolean isSecureAdminEnabled() {
        return this.secureAdminEnabled;
    }

    public final int getExitValue() {
        return this.exitValue;
    }

    public final Process getProcess() throws GFLauncherException {
        if (this.glassFishProcess == null) {
            throw new GFLauncherException("invalid_process");
        }
        return this.glassFishProcess;
    }

    public final ProcessStreamDrainer getProcessStreamDrainer() throws GFLauncherException {
        if (this.processStreamDrainer == null) {
            throw new GFLauncherException("invalid_psd");
        }
        return this.processStreamDrainer;
    }

    public String getLogFilename() throws GFLauncherException {
        if (!this.logFilenameWasFixed) {
            throw new GFLauncherException(strings.get("internalError") + " call to getLogFilename() before it has been initialized");
        }
        return this.logFilename;
    }

    public final int getDebugPort() {
        return this.debugPort;
    }

    public final boolean isDebugSuspend() {
        return this.debugPort >= 0 && this.debugSuspend;
    }

    public final boolean needsAutoUpgrade() {
        return this.needsAutoUpgrade;
    }

    public final boolean needsManualUpgrade() {
        return this.needsManualUpgrade;
    }

    abstract void internalLaunch() throws GFLauncherException;

    void launchInstance() throws GFLauncherException, MiniXmlParserException {
        if (this.isFakeLaunch()) {
            return;
        }
        List<String> cmds = null;
        if (OS.isDarwin() && GFLauncher.useLaunchCtl(System.getProperty("os.version")) && !this.getInfo().isVerboseOrWatchdog()) {
            cmds = new ArrayList<String>();
            cmds.add("launchctl");
            cmds.add("bsexec");
            cmds.add("/");
            cmds.addAll(this.getCommandLine());
        } else {
            cmds = this.getCommandLine();
        }
        ProcessBuilder processBuilder = new ProcessBuilder(cmds);
        try {
            processBuilder.directory(this.getInfo().getConfigDir());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.closeStandardStreamsMaybe();
            this.glassFishProcess = processBuilder.start();
            String name = this.getInfo().getDomainName();
            this.processStreamDrainer = this.getInfo().isVerbose() ? ProcessStreamDrainer.redirect((String)name, (Process)this.glassFishProcess) : (this.getInfo().isWatchdog() ? ProcessStreamDrainer.dispose((String)name, (Process)this.glassFishProcess) : ProcessStreamDrainer.save((String)name, (Process)this.glassFishProcess));
            this.writeSecurityTokens(this.glassFishProcess);
        }
        catch (Exception e) {
            throw new GFLauncherException("jvmfailure", (Throwable)e, e);
        }
        if (this.getInfo().isVerboseOrWatchdog()) {
            this.wait(this.glassFishProcess);
        }
    }

    boolean isFakeLaunch() {
        return this.mode == LaunchType.fake;
    }

    public final List<String> getCommandLine() {
        return this.commandLine;
    }

    void setMode(LaunchType mode) {
        this.mode = mode;
    }

    LaunchType getMode() {
        return this.mode;
    }

    final long getStartTime() {
        return this.startTime;
    }

    abstract List<File> getMainClasspath() throws GFLauncherException;

    abstract String getMainClass() throws GFLauncherException;

    final Map<String, String> getEnvProps() {
        return this.asenvProps;
    }

    private static boolean useLaunchCtl(String osversion) {
        int major = 0;
        int minor = 0;
        if (osversion == null || osversion.isEmpty()) {
            return false;
        }
        String[] split = osversion.split("[\\._\\-]+");
        try {
            if (split.length > 0 && split[0].length() > 0) {
                major = Integer.parseInt(split[0]);
            }
            if (split.length > 1 && split[1].length() > 0) {
                minor = Integer.parseInt(split[1]);
            }
            return major <= 9 || major <= 10 && minor < 10;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private ASenvPropertyReader getAsEnvConfReader() {
        if (this.isFakeLaunch()) {
            return new ASenvPropertyReader(this.callerParameters.getInstallDir());
        }
        return new ASenvPropertyReader();
    }

    private List<String> getDebugOptionsFromDomainXMLJavaConfig() {
        if (this.callerParameters.isDebug() || this.callerParameters.isSuspend() || this.domainXMLjavaConfig.isDebugEnabled()) {
            if (!this.callerParameters.isSuspend()) {
                return this.domainXMLjavaConfig.getDebugOptions();
            }
            return this.domainXMLjavaConfig.getDebugOptions().stream().filter(e -> e.startsWith("-agentlib:jdwp")).map(e -> e.replace("suspend=n", "suspend=y")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void parseJavaConfigDebugOptions() {
        for (String option : this.domainXMLjavaConfigDebugOptions) {
            String[] attributes;
            if (!option.startsWith("-agentlib:jdwp")) continue;
            for (String attribute : attributes = option.substring(10).split(",")) {
                if (attribute.startsWith("address=")) {
                    try {
                        this.debugPort = Integer.parseInt(attribute.substring(8));
                    }
                    catch (NumberFormatException ex) {
                        this.debugPort = -1;
                    }
                }
                if (!attribute.startsWith("suspend=")) continue;
                try {
                    this.debugSuspend = attribute.substring(8).toLowerCase(Locale.getDefault()).equals("y");
                }
                catch (Exception ex) {
                    this.debugSuspend = false;
                }
            }
        }
    }

    private void setLogFilename(MiniXmlParser domainXML) throws GFLauncherException {
        this.logFilename = domainXML.getLogFilename();
        if (this.logFilename == null) {
            this.logFilename = "logs/server.log";
        }
    }

    private void resolveAllTokens() {
        HashMap<String, String> all = new HashMap<String, String>();
        all.putAll(System.getenv());
        all.putAll(this.asenvProps);
        all.putAll(CollectionUtils.propertiesToStringMap((Properties)System.getProperties()));
        all.putAll(this.domainXMLSystemProperty);
        all.putAll(this.domainXMLjvmOptions.getCombinedMap());
        all.putAll(this.domainXMLJavaConfigProfiler.getConfig());
        TokenResolver resolver = new TokenResolver(all);
        resolver.resolve(this.domainXMLjvmOptions.xProps);
        resolver.resolve(this.domainXMLjvmOptions.xxProps);
        resolver.resolve(this.domainXMLjvmOptions.plainProps);
        resolver.resolve(this.domainXMLjvmOptions.sysProps);
        resolver.resolve(this.domainXMLjavaConfig.getMap());
        resolver.resolve(this.domainXMLJavaConfigProfiler.getConfig());
        resolver.resolve(this.domainXMLjavaConfigDebugOptions);
        this.logFilename = resolver.resolve(this.logFilename);
        this.adminFileRealmKeyFile = resolver.resolve(this.adminFileRealmKeyFile);
    }

    private void fixLogFilename() throws GFLauncherException {
        boolean wasCreated;
        File parent;
        File logFile;
        if (!GFLauncherUtils.ok((String)this.logFilename)) {
            this.logFilename = "logs/server.log";
        }
        if (!(logFile = new File(this.logFilename)).isAbsolute()) {
            logFile = new File(this.callerParameters.getInstanceRootDir(), this.logFilename);
        }
        if (!((logFile = SmartFile.sanitize((File)logFile)).exists() || (parent = logFile.getParentFile()).isDirectory() || (wasCreated = parent.mkdirs()))) {
            logFile = null;
        }
        this.logFilename = logFile == null ? null : logFile.getPath();
        this.logFilenameWasFixed = true;
    }

    private void setJavaExecutable() throws GFLauncherException {
        if (this.setJavaExecutableIfValid(this.domainXMLjavaConfig.getJavaHome())) {
            return;
        }
        if (!this.setJavaExecutableIfValid(this.asenvProps.get("com.sun.aas.javaRoot"))) {
            throw new GFLauncherException("nojvm");
        }
    }

    boolean setJavaExecutableIfValid(String filename) {
        if (!GFLauncherUtils.ok((String)filename)) {
            return false;
        }
        File javaFile = new File(filename);
        if (!javaFile.isDirectory()) {
            return false;
        }
        javaFile = GFLauncherUtils.isWindows() ? new File(javaFile, "bin/java.exe") : new File(javaFile, "bin/java");
        if (javaFile.exists()) {
            this.javaExe = SmartFile.sanitize((File)javaFile).getPath();
            return true;
        }
        return false;
    }

    void setClasspath() throws GFLauncherException {
        List<File> mainCP = this.getMainClasspath();
        List<File> envCP = this.domainXMLjavaConfig.getEnvClasspath();
        List<File> sysCP = this.domainXMLjavaConfig.getSystemClasspath();
        List<File> prefixCP = this.domainXMLjavaConfig.getPrefixClasspath();
        List<File> suffixCP = this.domainXMLjavaConfig.getSuffixClasspath();
        List<File> profilerCP = this.domainXMLJavaConfigProfiler.getClasspath();
        ArrayList<File> all = new ArrayList<File>();
        all.addAll(prefixCP);
        all.addAll(profilerCP);
        all.addAll(mainCP);
        all.addAll(sysCP);
        all.addAll(envCP);
        all.addAll(suffixCP);
        this.setClasspath(GFLauncherUtils.fileListToPathString(all));
    }

    void setCommandLine() throws GFLauncherException {
        List<String> cmdLine = this.getCommandLine();
        cmdLine.clear();
        this.addIgnoreNull(cmdLine, this.javaExe);
        this.addIgnoreNull(cmdLine, "-cp");
        this.addIgnoreNull(cmdLine, this.getClasspath());
        this.addIgnoreNull(cmdLine, this.domainXMLjavaConfigDebugOptions);
        String CLIStartTime = System.getProperty("WALL_CLOCK_START");
        if (CLIStartTime != null && CLIStartTime.length() > 0) {
            cmdLine.add("-DWALL_CLOCK_START=" + CLIStartTime);
        }
        if (this.debugPort >= 0) {
            cmdLine.add("-Dcom.sun.aas.debugMode=" + Boolean.TRUE);
        }
        if (this.domainXMLjvmOptions != null) {
            this.addIgnoreNull(cmdLine, this.domainXMLjvmOptions.toList());
        }
        GFLauncherNativeHelper nativeHelper = new GFLauncherNativeHelper(this.callerParameters, this.domainXMLjavaConfig, this.domainXMLjvmOptions, this.domainXMLJavaConfigProfiler);
        this.addIgnoreNull(cmdLine, nativeHelper.getCommands());
        this.addIgnoreNull(cmdLine, this.getMainClass());
        try {
            this.addIgnoreNull(cmdLine, this.getInfo().getArgsAsList());
        }
        catch (GFLauncherException gfle) {
            throw gfle;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setJvmOptions() throws GFLauncherException {
        this.domainXMLJvmOptionsAsList.clear();
        if (this.domainXMLjvmOptions != null) {
            this.addIgnoreNull(this.domainXMLJvmOptionsAsList, this.domainXMLjvmOptions.toList());
        }
    }

    void logCommandLine() {
        StringBuilder sb = new StringBuilder();
        if (!this.isFakeLaunch()) {
            List<String> cmdLine = this.getCommandLine();
            for (String s : cmdLine) {
                sb.append(GFLauncherConstants.NEWLINE);
                sb.append(s);
            }
            GFLauncherLogger.info("NCLS-GFLAUNCHER-00005", sb.toString());
        }
    }

    public final List<String> getJvmOptions() {
        return this.domainXMLJvmOptionsAsList;
    }

    private void addIgnoreNull(List<String> list, String s) {
        if (GFLauncherUtils.ok((String)s)) {
            list.add(s);
        }
    }

    private void addIgnoreNull(List<String> list, Collection<String> ss) {
        if (ss != null && !ss.isEmpty()) {
            list.addAll(ss);
        }
    }

    private void wait(Process p) throws GFLauncherException {
        try {
            this.setShutdownHook(p);
            p.waitFor();
            this.exitValue = p.exitValue();
        }
        catch (InterruptedException ex) {
            throw new GFLauncherException("verboseInterruption", (Throwable)ex, ex);
        }
    }

    private void setShutdownHook(Process p) {
        if (this.processWhacker == null) {
            Runtime runtime = Runtime.getRuntime();
            String msg = strings.get("serverStopped", new Object[]{this.callerParameters.getType()});
            this.processWhacker = new ProcessWhacker(p, msg);
            runtime.addShutdownHook(new Thread(this.processWhacker));
        } else {
            this.processWhacker.setProcess(p);
        }
    }

    private void setupProfilerAndJvmOptions(MiniXmlParser domainXML) throws MiniXmlParserException, GFLauncherException {
        this.domainXMLJavaConfigProfiler = new Profiler(domainXML.getProfilerConfig(), domainXML.getProfilerJvmOptions(), domainXML.getProfilerSystemProperties());
        List rawJvmOptions = domainXML.getJvmOptions();
        rawJvmOptions.addAll(this.getSpecialSystemProperties());
        if (this.domainXMLJavaConfigProfiler.isEnabled()) {
            rawJvmOptions.addAll(this.domainXMLJavaConfigProfiler.getJvmOptions());
        }
        this.domainXMLjvmOptions = new JvmOptions(rawJvmOptions);
        if (this.callerParameters.isDropInterruptedCommands()) {
            this.domainXMLjvmOptions.sysProps.put("org.glassfish.job-manager.drop-interrupted-commands", Boolean.TRUE.toString());
        }
    }

    private void writeSecurityTokens(Process sp) throws GFLauncherException, IOException {
        this.handleDeadProcess();
        OutputStream os = sp.getOutputStream();
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            osw = new OutputStreamWriter(os);
            bw = new BufferedWriter(osw);
            for (String token : this.callerParameters.securityTokens) {
                bw.write(token);
                bw.newLine();
                bw.flush();
            }
        }
        catch (IOException e) {
            this.handleDeadProcess();
            throw e;
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (osw != null) {
                osw.close();
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            if (bw != null) {
                this.handleDeadProcess();
            }
        }
    }

    private void handleDeadProcess() throws GFLauncherException {
        String trace = this.getDeadProcessTrace(this.glassFishProcess);
        if (trace != null) {
            throw new GFLauncherException(trace);
        }
    }

    private String getDeadProcessTrace(Process sp) throws GFLauncherException {
        try {
            int ev = sp.exitValue();
            ProcessStreamDrainer psd1 = this.getProcessStreamDrainer();
            String output = psd1.getOutErrString();
            String trace = strings.get("server_process_died", new Object[]{ev, output});
            return trace;
        }
        catch (IllegalThreadStateException e) {
            return null;
        }
    }

    private void setupUpgradeSecurity() throws GFLauncherException {
        if (this.callerParameters.isUpgrade() && this.domainXMLjvmOptions.sysProps.containsKey("java.security.manager")) {
            GFLauncherLogger.info("NCLS-GFLAUNCHER-00004", new Object[0]);
            File source = new File(new File(new File(this.callerParameters.installDir, "lib"), "templates"), "server.policy");
            File target = new File(this.callerParameters.getConfigDir(), "server.policy");
            try {
                FileUtils.copyFile((File)source, (File)target);
            }
            catch (IOException ioe) {
                Throwable cause = ioe.getCause() == null ? ioe : ioe.getCause();
                throw new GFLauncherException(strings.get("copy_server_policy_error", new Object[]{cause.getMessage()}));
            }
        }
    }

    private void renameOsgiCache() throws GFLauncherException {
        if (this.callerParameters.isUpgrade()) {
            File osgiCacheDir = new File(this.callerParameters.getDomainRootDir(), "osgi-cache");
            File backupOsgiCacheDir = new File(this.callerParameters.getDomainRootDir(), "osgi-cache-" + System.currentTimeMillis());
            if (osgiCacheDir.exists() && !backupOsgiCacheDir.exists()) {
                if (!FileUtils.renameFile((File)osgiCacheDir, (File)backupOsgiCacheDir)) {
                    throw new GFLauncherException(strings.get("rename_osgi_cache_failed", new Object[]{osgiCacheDir, backupOsgiCacheDir}));
                }
                GFLauncherLogger.fine("rename_osgi_cache_succeeded", osgiCacheDir, backupOsgiCacheDir);
            }
        }
    }

    private void setupMonitoring(MiniXmlParser parser) throws GFLauncherException {
        if (!parser.isMonitoringEnabled()) {
            return;
        }
        Set<String> plainKeys = this.domainXMLjvmOptions.plainProps.keySet();
        for (String key : plainKeys) {
            if (!key.startsWith("javaagent:") || (key = key.replace('\\', '/')).indexOf("flashlight-agent.jar") < 0) continue;
            return;
        }
        try {
            this.domainXMLjvmOptions.plainProps.put(this.getMonitoringAgentJvmOptionString(), null);
        }
        catch (GFLauncherException gFLauncherException) {
            // empty catch block
        }
    }

    private String getMonitoringAgentJvmOptionString() throws GFLauncherException {
        File libMonDir = new File(this.getInfo().getInstallDir(), "lib/monitor");
        File flashlightJarFile = new File(libMonDir, "flashlight-agent.jar");
        if (flashlightJarFile.isFile()) {
            return "javaagent:" + GFLauncher.getCleanPath(flashlightJarFile);
        }
        String msg = strings.get("no_flashlight_agent", new Object[]{flashlightJarFile});
        GFLauncherLogger.warning("NCLS-GFLAUNCHER-00003", flashlightJarFile);
        throw new GFLauncherException(msg);
    }

    private static String getCleanPath(File f) {
        return SmartFile.sanitize((File)f).getPath().replace('\\', '/');
    }

    private List<String> getSpecialSystemProperties() throws GFLauncherException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("com.sun.aas.installRoot", this.getInfo().getInstallDir().getAbsolutePath());
        props.put("com.sun.aas.instanceRoot", this.getInfo().getInstanceRootDir().getAbsolutePath());
        return this.propsToJvmOptions(props);
    }

    String getClasspath() {
        return this.classpath;
    }

    void setClasspath(String s) {
        this.classpath = s;
    }

    private List<String> propsToJvmOptions(Map<String, String> map) {
        ArrayList<String> ss = new ArrayList<String>();
        Set<Map.Entry<String, String>> entries = map.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            String jvm = "-D" + name;
            if (value != null) {
                jvm = jvm + "=" + value;
            }
            ss.add(jvm);
        }
        return ss;
    }

    private void setupLogLevels() {
        if (this.callerParameters.isVerbose()) {
            GFLauncherLogger.setConsoleLevel(Level.INFO);
        } else {
            GFLauncherLogger.setConsoleLevel(Level.WARNING);
        }
    }

    private void closeStandardStreamsMaybe() {
        if (System.console() == null && OS.isWindows() && !this.callerParameters.isVerboseOrWatchdog()) {
            String sname = this.callerParameters.isDomain() ? this.callerParameters.getDomainName() : this.callerParameters.getInstanceName();
            System.out.println(strings.get("ssh", new Object[]{sname}));
            try {
                System.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                System.err.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                System.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static enum LaunchType {
        normal,
        debug,
        trace,
        fake;

    }

    private static class ProcessWhacker
    implements Runnable {
        private String message;
        private Process process;

        ProcessWhacker(Process p, String msg) {
            this.message = msg;
            this.process = p;
        }

        void setProcess(Process p) {
            this.process = p;
        }

        @Override
        public void run() {
            System.out.println(this.message);
            this.process.destroy();
        }
    }
}

