/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.custom;

import com.sun.enterprise.server.logging.logviewer.backend.LogFilter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.logviewer.LogRecord;
import org.glassfish.admin.rest.resources.custom.LogNamesResource;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.LogManager;

public class StructuredLogViewerResource {
    protected ServiceLocator habitat = Globals.getDefaultBaseServiceLocator();
    @Context
    protected ServiceLocator injector;

    @Path(value="lognames/")
    public LogNamesResource getLogNamesResource() {
        return (LogNamesResource)this.injector.createAndInitialize(LogNamesResource.class);
    }

    @GET
    @Produces(value={"text/plain; qs=0.5"})
    public Response getViewLogDetailsText(@BeanParam Params params) throws Exception {
        return this.getViewLogDetails(params, "text/plain");
    }

    @GET
    @Produces(value={"application/json; qs=1"})
    public Response getViewLogDetailsJson(@BeanParam Params params) throws Exception {
        return this.getViewLogDetails(params, "application/json");
    }

    @GET
    @Produces(value={"application/xml; qs=0.75"})
    public Response getViewLogDetailsXml(@BeanParam Params params) throws Exception {
        return this.getViewLogDetails(params, "application/xml");
    }

    private Response getViewLogDetails(Params params, String type) throws Exception {
        if (this.habitat.getService(LogManager.class, new Annotation[0]) == null) {
            throw new IOException("The GlassFish LogManager Service is not available. Not installed?");
        }
        ArrayList<String> modules = new ArrayList<String>();
        if (params.getListOfModules() != null && !params.getListOfModules().isEmpty()) {
            modules.addAll(Arrays.asList(params.getListOfModules().split(",")));
        }
        Properties nameValueMap = new Properties();
        LogFilter logFilter = (LogFilter)this.habitat.getService(LogFilter.class, new Annotation[0]);
        boolean sortAscending = params.isSearchForward();
        AttributeList result = params.getInstanceName().isEmpty() ? logFilter.getLogRecordsUsingQuery(params.getLogFileName(), Long.valueOf(params.getStartIndex()), Boolean.valueOf(params.isSearchForward()), Boolean.valueOf(sortAscending), Integer.valueOf(params.getMaximumNumberOfResults()), params.getFromTime() == -1L ? null : Instant.ofEpochMilli(params.getFromTime()), params.getToTime() == -1L ? null : Instant.ofEpochMilli(params.getToTime()), params.getLogLevel(), Boolean.valueOf(params.isOnlyLevel()), modules, nameValueMap, params.getAnySearch()) : logFilter.getLogRecordsUsingQuery(params.getLogFileName(), Long.valueOf(params.getStartIndex()), Boolean.valueOf(params.isSearchForward()), Boolean.valueOf(sortAscending), Integer.valueOf(params.getMaximumNumberOfResults()), params.getFromTime() == -1L ? null : Instant.ofEpochMilli(params.getFromTime()), params.getToTime() == -1L ? null : Instant.ofEpochMilli(params.getToTime()), params.getLogLevel(), Boolean.valueOf(params.isOnlyLevel()), modules, nameValueMap, params.getAnySearch(), params.getInstanceName());
        return this.convertQueryResult(result, type);
    }

    private <T> List<T> asList(Object list) {
        return (List)list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response convertQueryResult(AttributeList queryResult, String type) throws Exception {
        Appendable entity;
        List logRecords = this.asList(((Attribute)queryResult.get(1)).getValue());
        switch (type) {
            case "application/json": {
                JSONArray logDetails = new JSONArray();
                for (List logRecord : logRecords) {
                    logDetails.put((Object)new LogRecord(logRecord).toJSONObject());
                }
                entity = new JSONObject().put("records", (Object)logDetails);
                break;
            }
            case "application/xml": {
                StringWriter xml = new StringWriter();
                try (XMLStreamWriter writer = XMLOutputFactory.newDefaultFactory().createXMLStreamWriter(xml);){
                    writer.writeStartElement("records");
                    for (List logRecord : logRecords) {
                        new LogRecord(logRecord).writeXml(writer);
                    }
                    writer.writeEndElement();
                }
                entity = xml;
                break;
            }
            case "text/plain": {
                StringBuilder sb = new StringBuilder();
                String lineSeparator = "";
                for (List logRecord : logRecords) {
                    sb.append(lineSeparator);
                    new LogRecord(logRecord).writeCsv(sb);
                    lineSeparator = "\r\n";
                }
                entity = sb;
                break;
            }
            default: {
                return Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).build();
            }
        }
        return Response.ok((Object)((Object)entity).toString(), (String)type).build();
    }

    private static final class Params {
        @QueryParam(value="logFileName")
        @DefaultValue(value="${com.sun.aas.instanceRoot}/logs/server.log")
        private String logFileName;
        @QueryParam(value="startIndex")
        @DefaultValue(value="-1")
        private long startIndex;
        @QueryParam(value="searchForward")
        @DefaultValue(value="false")
        private boolean searchForward;
        @QueryParam(value="maximumNumberOfResults")
        @DefaultValue(value="40")
        private int maximumNumberOfResults;
        @QueryParam(value="onlyLevel")
        @DefaultValue(value="false")
        private boolean onlyLevel;
        @QueryParam(value="fromTime")
        @DefaultValue(value="-1")
        private long fromTime;
        @QueryParam(value="toTime")
        @DefaultValue(value="-1")
        private long toTime;
        @QueryParam(value="logLevel")
        @DefaultValue(value="INFO")
        private String logLevel;
        @QueryParam(value="anySearch")
        @DefaultValue(value="")
        private String anySearch;
        @QueryParam(value="listOfModules")
        private String listOfModules;
        @QueryParam(value="instanceName")
        @DefaultValue(value="")
        private String instanceName;

        private Params() {
        }

        public String getLogFileName() {
            return this.logFileName;
        }

        public long getStartIndex() {
            return this.startIndex;
        }

        public boolean isSearchForward() {
            return this.searchForward;
        }

        public int getMaximumNumberOfResults() {
            return this.maximumNumberOfResults;
        }

        public boolean isOnlyLevel() {
            return this.onlyLevel;
        }

        public long getFromTime() {
            return this.fromTime;
        }

        public long getToTime() {
            return this.toTime;
        }

        public String getLogLevel() {
            return this.logLevel;
        }

        public String getAnySearch() {
            return this.anySearch;
        }

        public String getListOfModules() {
            return this.listOfModules;
        }

        public String getInstanceName() {
            return this.instanceName;
        }
    }
}

