/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.zip;

import com.sun.enterprise.util.CULoggerInfo;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipFileException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipFile {
    private static final int BUFFER_SIZE = 65536;
    private File explodeDir = null;
    private ArrayList<String> files = null;
    private byte[] buffer = new byte[65536];
    private ZipInputStream zipStream = null;
    private static final Logger _utillogger = CULoggerInfo.getLogger();
    private File zipFile = null;

    public ZipFile(String zipFilename, String explodeDirName) throws ZipFileException {
        this(new File(zipFilename), new File(explodeDirName));
    }

    public ZipFile(InputStream inStream, String anExplodeDirName) throws ZipFileException {
        this((InputStream)new BufferedInputStream(inStream, 65536), new File(anExplodeDirName));
    }

    public ZipFile(File zipFile, File anExplodeDir) throws ZipFileException {
        this.checkZipFile(zipFile);
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(zipFile), 65536);
            this.ctor(bis, anExplodeDir);
            this.zipFile = zipFile;
        }
        catch (Throwable e) {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Throwable thr) {
                    throw new ZipFileException(thr);
                }
            }
            throw new ZipFileException(e);
        }
    }

    public ZipFile(InputStream inStream, File anExplodeDir) throws ZipFileException {
        this.ctor(inStream, anExplodeDir);
    }

    public ArrayList<String> explode() throws ZipFileException {
        this.files = new ArrayList();
        ZipInputStream zin = null;
        FilterOutputStream bos = null;
        try {
            ZipEntry ze;
            zin = this.zipStream;
            while ((ze = zin.getNextEntry()) != null) {
                File f;
                File fullpath;
                String filename = ze.getName();
                if (this.isDirectory(filename)) {
                    fullpath = new File(this.explodeDir, filename.substring(0, filename.length() - 1));
                    if (fullpath.mkdirs()) continue;
                    throw new IOException("Cannot create directory: " + fullpath);
                }
                fullpath = new File(this.explodeDir, filename);
                File newDir = fullpath.getParentFile();
                if (!newDir.mkdirs()) {
                    _utillogger.log(Level.FINE, "Cannot create directory {0}", newDir);
                }
                if (fullpath.delete() && _utillogger.isLoggable(Level.FINE)) {
                    _utillogger.log(Level.FINE, "File {0} is being overwritten during expansion of {1}", new Object[]{fullpath.getAbsolutePath(), this.zipFile != null ? "file " + this.zipFile.getAbsolutePath() : "stream"});
                }
                if ((f = new File(this.explodeDir, filename)).isDirectory()) continue;
                bos = new BufferedOutputStream(this.getOutputStream(f), 65536);
                int totalBytes = 0;
                int numBytes = zin.read(this.buffer);
                while (numBytes > 0) {
                    ((BufferedOutputStream)bos).write(this.buffer, 0, numBytes);
                    totalBytes += numBytes;
                    numBytes = zin.read(this.buffer);
                }
                bos.close();
                bos = null;
                this.files.add(filename);
            }
        }
        catch (IOException e) {
            throw new ZipFileException(e);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
            try {
                if (zin != null) {
                    zin.close();
                }
            }
            catch (IOException e) {
                throw new ZipFileException("Got an exception while trying to close Jar input stream: " + e);
            }
        }
        return this.files;
    }

    public static void extractJar(String jarEntryName, JarFile earFile, File jarFile) throws ZipFileException {
        try {
            File parent = jarFile.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new ZipFileException("Cannot create directory: " + parent);
            }
            ZipEntry jarEntry = earFile.getEntry(jarEntryName);
            if (jarEntry == null) {
                throw new ZipFileException(jarEntryName + " not found in " + earFile.getName());
            }
            InputStream is = earFile.getInputStream(jarEntry);
            FileOutputStream fos = new FileOutputStream(jarFile);
            FileUtils.copy(is, fos, jarEntry.getSize());
        }
        catch (IOException e) {
            throw new ZipFileException(e);
        }
    }

    public ArrayList getFileList() {
        return this.files;
    }

    private void ctor(InputStream inStream, File anExplodeDir) throws ZipFileException {
        ZipFile.insist(anExplodeDir != null);
        this.explodeDir = anExplodeDir;
        try {
            this.zipStream = new ZipInputStream(inStream);
            this.checkExplodeDir();
        }
        catch (Throwable t) {
            if (this.zipStream != null) {
                try {
                    this.zipStream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw new ZipFileException(t.toString());
        }
    }

    private boolean isDirectory(String s) {
        char c = s.charAt(s.length() - 1);
        return c == '/' || c == '\\';
    }

    private void checkZipFile(File zipFile) throws ZipFileException {
        ZipFile.insist(zipFile != null);
        String zipFileName = zipFile.getPath();
        ZipFile.insist(zipFile.exists(), "zipFile (" + zipFileName + ") doesn't exist");
        ZipFile.insist(!zipFile.isDirectory(), "zipFile (" + zipFileName + ") is actually a directory!");
    }

    private void checkExplodeDir() throws ZipFileException {
        String explodeDirName = this.explodeDir.getPath();
        ZipFile.insist(this.explodeDir.mkdirs(), "Unable to create target directory: " + explodeDirName);
        ZipFile.insist(this.explodeDir.exists(), "Target Directory doesn't exist: " + explodeDirName);
        ZipFile.insist(this.explodeDir.isDirectory(), "Target Directory isn't a directory: " + explodeDirName);
        ZipFile.insist(this.explodeDir.canWrite(), "Can't write to Target Directory: " + explodeDirName);
    }

    private FileOutputStream getOutputStream(File f) throws ZipFileException {
        try {
            return new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new ZipFileException("filename: " + f.getPath() + "  " + e);
        }
        catch (IOException e) {
            throw new ZipFileException(e);
        }
    }

    private static void insist(boolean b) throws ZipFileException {
        if (!b) {
            throw new ZipFileException();
        }
    }

    private static void insist(boolean b, String mesg) throws ZipFileException {
        if (!b) {
            throw new ZipFileException(mesg);
        }
    }
}

