/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2013-2017 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://oss.oracle.com/licenses/CDDL+GPL-1.1
 * or LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.glassfish.api.admin;

import org.glassfish.api.ActionReport;

import java.io.File;
import java.io.Serializable;
import java.util.List;

/** Represents running (or finished) command instance.
 *
 *
 * @author Martin Mares
 * @author Bhakti Mehta
 */
public interface Job extends AdminCommandState, Serializable {
    
    /** Command progress only if it is supported by command
     */
    public CommandProgress getCommandProgress();
    
    public void setCommandProgress(CommandProgress commandProgress);
    
    public void complete(ActionReport report, Payload.Outbound outbound);
    
    /** Change state to reverting. Command Can use it to send info about reverting
     * to Job management infrastructure.
     */
    public void revert();
    
    public AdminCommandEventBroker getEventBroker();

    public List<String> getSubjectUsernames();

    public String getName();

    public long getCommandExecutionDate();

    public Payload.Outbound getPayload();

    public File getJobsFile() ;

    public void setJobsFile(File jobsFile) ;

    public String getScope();

    public long getCommandCompletionDate();
    
    /** Job will be considered as retryable after fail. It means that checkpoint
     * will not be deleted and revert or continue can be decided by the user.
     */
    public void setFailToRetryable(boolean value);
    
    public ParameterMap getParameters();
    
}
