/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime.common.wls;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.EjbReferenceContainer;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.deployment.common.Descriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EjbReferenceDescriptionNode
extends RuntimeDescriptorNode<EjbReference> {
    private EjbReference descriptor = null;

    @Override
    public EjbReference getDescriptor() {
        return this.descriptor;
    }

    @Override
    protected Map getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("jndi-name", "setJndiName");
        return table;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("ejb-ref-name".equals(element.getQName())) {
            Object parentDesc = this.getParentNode().getDescriptor();
            if (parentDesc instanceof EjbReferenceContainer) {
                try {
                    this.descriptor = ((EjbReferenceContainer)parentDesc).getEjbReference(value);
                    DOLUtils.getDefaultLogger().finer("Applying ref runtime to " + this.descriptor);
                }
                catch (IllegalArgumentException iae) {
                    DOLUtils.getDefaultLogger().warning(iae.getMessage());
                }
            }
            if (this.descriptor == null) {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.addDescriptorFailure", new Object[]{"ejb-ref", value});
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, EjbReference descriptor) {
        Element ejbRef = EjbReferenceDescriptionNode.appendChild(parent, nodeName);
        EjbReferenceDescriptionNode.appendTextChild((Node)ejbRef, "ejb-ref-name", descriptor.getName());
        EjbReferenceDescriptionNode.appendTextChild((Node)ejbRef, "jndi-name", descriptor.getJndiName());
        return ejbRef;
    }

    @Override
    public Node writeDescriptors(Node parent, String nodeName, Descriptor parentDesc) {
        if (parentDesc instanceof EjbReferenceContainer) {
            EjbReferenceContainer ejbReferenceContainer = (EjbReferenceContainer)parentDesc;
            Set ejbReferences = ejbReferenceContainer.getEjbReferenceDescriptors();
            for (EjbReference ejbReference : ejbReferences) {
                this.writeDescriptor(parent, nodeName, ejbReference);
            }
        }
        return parent;
    }
}

