/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.container.common.spi.util.IndirectlySerializable;
import com.sun.enterprise.container.common.spi.util.SerializableObjectFactory;
import jakarta.ejb.EJBException;
import jakarta.ejb.EJBLocalHome;
import jakarta.ejb.EJBLocalObject;
import jakarta.ejb.RemoveException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.logging.Logger;

public abstract class EJBLocalObjectImpl
extends EJBLocalRemoteObject
implements EJBLocalObject,
IndirectlySerializable {
    private static final Logger _logger = EjbContainerUtilImpl.getLogger();
    private static final Method REMOVE_METHOD = EJBLocalObjectImpl.getRemoveMethod();
    private boolean isLocalHomeView;
    private boolean isOptionalLocalBusinessView;
    private Object optionalLocalBusinessClientObject;
    private final HashMap<String, Object> clientObjectMap = new HashMap();

    private static Method getRemoveMethod() {
        try {
            return EJBLocalObject.class.getMethod("remove", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Exception retrieving remove method", e);
        }
    }

    public Object getClientObject() {
        return this;
    }

    void mapClientObject(String intfClassName, Object obj) {
        this.clientObjectMap.put(intfClassName, obj);
        if (this.isOptionalLocalBusinessView) {
            this.optionalLocalBusinessClientObject = obj;
        }
    }

    Object getClientObject(String intfClassName) {
        return this.clientObjectMap.get(intfClassName);
    }

    void setIsLocalHomeView(boolean flag) {
        this.isLocalHomeView = flag;
    }

    boolean isLocalHomeView() {
        return this.isLocalHomeView;
    }

    boolean isOptionalLocalBusinessView() {
        return this.isOptionalLocalBusinessView;
    }

    void setIsOptionalLocalBusinessView(boolean flag) {
        this.isOptionalLocalBusinessView = flag;
    }

    Object getOptionalLocalBusinessClientObject() {
        return this.optionalLocalBusinessClientObject;
    }

    public static EJBLocalObjectImpl toEJBLocalObjectImpl(EJBLocalObject localObj) {
        if (localObj instanceof EJBLocalObjectImpl) {
            return (EJBLocalObjectImpl)localObj;
        }
        return (EJBLocalObjectImpl)((Object)Proxy.getInvocationHandler(localObj));
    }

    public EJBLocalHome getEJBLocalHome() throws EJBException {
        this.container.authorizeLocalMethod(10);
        this.container.checkExists(this);
        return this.container.getEJBLocalHome();
    }

    public void remove() throws RemoveException, EJBException {
        try {
            this.container.removeBean(this, REMOVE_METHOD, true);
        }
        catch (RemoteException re) {
            throw new EJBException("unexpected RemoteException", (Exception)re);
        }
    }

    public Object getPrimaryKey() throws EJBException {
        this.container.authorizeLocalGetPrimaryKey(this);
        return this.primaryKey;
    }

    public boolean isIdentical(EJBLocalObject other) throws EJBException {
        this.container.authorizeLocalMethod(13);
        this.container.checkExists(this);
        return this == other;
    }

    public SerializableObjectFactory getSerializableObjectFactory() {
        return new SerializableLocalObject(this.container.getEjbDescriptor().getUniqueId(), this.isLocalHomeView, this.isOptionalLocalBusinessView, this.primaryKey, this.getSfsbClientVersion());
    }

    private static final class SerializableLocalObject
    implements SerializableObjectFactory {
        private static final long serialVersionUID = 1L;
        private final long containerId;
        private final boolean localHomeView;
        private final boolean optionalLocalBusView;
        private final Object primaryKey;
        private final long version;

        SerializableLocalObject(long containerId, boolean localHomeView, boolean optionalLocalBusinessView, Object primaryKey, long version) {
            this.containerId = containerId;
            this.localHomeView = localHomeView;
            this.optionalLocalBusView = optionalLocalBusinessView;
            this.primaryKey = primaryKey;
            this.version = version;
        }

        long getVersion() {
            return this.version;
        }

        public Object createObject() throws IOException {
            BaseContainer container = EjbContainerUtilImpl.getInstance().getContainer(this.containerId);
            if (this.localHomeView) {
                EJBLocalObjectImpl ejbLocalObjectImpl = container.getEJBLocalObjectImpl(this.primaryKey);
                ejbLocalObjectImpl.setSfsbClientVersion(this.version);
                return ejbLocalObjectImpl.getClientObject();
            }
            EJBLocalObjectImpl ejbLocalBusinessObjectImpl = this.optionalLocalBusView ? container.getOptionalEJBLocalBusinessObjectImpl(this.primaryKey) : container.getEJBLocalBusinessObjectImpl(this.primaryKey);
            ejbLocalBusinessObjectImpl.setSfsbClientVersion(this.version);
            return ejbLocalBusinessObjectImpl.getClientObject();
        }
    }
}

