/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.main.jul.GlassFishLogger;
import org.glassfish.main.jul.GlassFishLoggerWrapper;
import org.glassfish.main.jul.GlassFishLoggingStatus;
import org.glassfish.main.jul.StartupQueue;
import org.glassfish.main.jul.cfg.ConfigurationHelper;
import org.glassfish.main.jul.cfg.GlassFishLogManagerConfiguration;
import org.glassfish.main.jul.cfg.GlassFishLogManagerProperty;
import org.glassfish.main.jul.cfg.LoggingProperties;
import org.glassfish.main.jul.env.LoggingSystemEnvironment;
import org.glassfish.main.jul.handler.ExternallyManagedLogHandler;
import org.glassfish.main.jul.handler.SimpleLogHandler;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

public class GlassFishLogManager
extends LogManager {
    public static final String ROOT_LOGGER_NAME = "";
    private static final AtomicBoolean RESET_PROTECTION = new AtomicBoolean(true);
    private static volatile GlassFishLoggingStatus status = GlassFishLoggingStatus.UNINITIALIZED;
    private static GlassFishLogManager glassfishLogManager;
    private volatile GlassFishLogger systemRootLogger;
    private volatile GlassFishLogger userRootLogger;
    private volatile GlassFishLogger globalLogger;
    private GlassFishLogManagerConfiguration configuration;

    static synchronized boolean initialize(Properties configuration) {
        GlassFishLoggingTracer.trace(GlassFishLogManager.class, "initialize(configuration)");
        if (status.ordinal() > GlassFishLoggingStatus.UNINITIALIZED.ordinal()) {
            GlassFishLoggingTracer.error(GlassFishLogManager.class, "Initialization of the logging system failed - it was already executed");
            return false;
        }
        status = GlassFishLoggingStatus.UNCONFIGURED;
        GlassFishLogManager logManager = GlassFishLogManager.getLogManager();
        if (logManager == null) {
            return false;
        }
        logManager.doFirstInitialization(GlassFishLogManager.ensureSortedProperties(configuration));
        return true;
    }

    public static boolean isGlassFishLogManager() {
        if (glassfishLogManager == null) {
            return GlassFishLogManager.getLogManager() != null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlassFishLogManager getLogManager() {
        if (glassfishLogManager != null) {
            return glassfishLogManager;
        }
        Class<GlassFishLogManager> clazz = GlassFishLogManager.class;
        synchronized (GlassFishLogManager.class) {
            LogManager logManager = LogManager.getLogManager();
            if (logManager instanceof GlassFishLogManager) {
                glassfishLogManager = (GlassFishLogManager)logManager;
                // ** MonitorExit[var0] (shouldn't be in output)
                return glassfishLogManager;
            }
            if (GlassFishLoggingTracer.isTracingEnabled()) {
                GlassFishLoggingTracer.stacktrace(GlassFishLogManager.class, "GlassFishLogManager not available, using " + logManager + ". Classloader used:\n here:  " + GlassFishLogManager.class.getClassLoader() + "\n there: " + logManager.getClass().getClassLoader());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return null;
        }
    }

    @Deprecated
    public GlassFishLogManager() {
        GlassFishLoggingTracer.trace(this.getClass(), "new GlassFishLogManager()");
        LoggingSystemEnvironment.initialize();
    }

    @Override
    public String getProperty(String name) {
        return this.configuration == null ? null : this.configuration.getProperty(name);
    }

    public GlassFishLogManagerConfiguration getConfiguration() {
        return this.configuration.clone();
    }

    @Override
    public boolean addLogger(Logger logger) {
        GlassFishLogger replacementLogger;
        boolean loggerAdded;
        Objects.requireNonNull(logger, "logger is null");
        Objects.requireNonNull(logger.getName(), "logger.name is null");
        GlassFishLoggingTracer.trace(this.getClass(), () -> "addLogger(logger.name=" + logger.getName() + ")");
        if (this.getLoggingStatus().ordinal() < GlassFishLoggingStatus.CONFIGURING.ordinal()) {
            try {
                if (ROOT_LOGGER_NAME.equals(logger.getName())) {
                    GlassFishLoggingTracer.trace(this.getClass(), () -> "System root logger catched: " + logger + ")");
                    this.systemRootLogger = new GlassFishLoggerWrapper(logger);
                    this.userRootLogger = new GlassFishLogger(ROOT_LOGGER_NAME);
                    boolean bl = this.callJULAddLogger(this.userRootLogger);
                    return bl;
                }
                if ("global".equals(logger.getName())) {
                    GlassFishLoggingTracer.trace(this.getClass(), () -> "System global logger catched: " + logger + ")");
                    this.globalLogger = new GlassFishLoggerWrapper(Logger.getGlobal());
                    boolean bl = this.callJULAddLogger(this.globalLogger);
                    return bl;
                }
            }
            finally {
                if (this.systemRootLogger != null && this.globalLogger != null && this.getLoggingStatus() == GlassFishLoggingStatus.UNINITIALIZED) {
                    this.doFirstInitialization(GlassFishLogManager.provideProperties());
                }
            }
        }
        if ((loggerAdded = this.callJULAddLogger(replacementLogger = GlassFishLogManager.replaceWithGlassFishLogger(logger))) && replacementLogger.getParent() == null && !ROOT_LOGGER_NAME.equals(replacementLogger.getName())) {
            replacementLogger.setParent(this.getRootLogger());
        }
        return loggerAdded && replacementLogger == logger;
    }

    @Override
    public GlassFishLogger getLogger(String name) {
        GlassFishLoggingTracer.trace(this.getClass(), "getLogger(name=" + name + ")");
        Objects.requireNonNull(name, "logger name is null");
        if (ROOT_LOGGER_NAME.equals(name)) {
            return this.getRootLogger();
        }
        if ("global".equals(name)) {
            return this.globalLogger;
        }
        Logger logger = super.getLogger(name);
        if (logger == null) {
            return null;
        }
        if (logger instanceof GlassFishLogger) {
            return (GlassFishLogger)logger;
        }
        return this.ensureGlassFishLoggerOrWrap(super.getLogger(name));
    }

    @Override
    @Deprecated
    public synchronized void reset() {
        if (RESET_PROTECTION.get()) {
            GlassFishLoggingTracer.stacktrace(GlassFishLogManager.class, "reset() ignored.");
            return;
        }
        super.reset();
        GlassFishLoggingTracer.trace(this.getClass(), "reset() done.");
    }

    @Override
    @Deprecated
    public synchronized void readConfiguration() throws SecurityException, IOException {
        GlassFishLoggingTracer.trace(this.getClass(), "readConfiguration() ignored.");
    }

    @Override
    @Deprecated
    public synchronized void readConfiguration(InputStream input) throws SecurityException, IOException {
        GlassFishLoggingTracer.trace(this.getClass(), () -> "readConfiguration(ins=" + input + ")");
        this.configuration = GlassFishLogManagerConfiguration.parse(input);
        GlassFishLoggingTracer.trace(this.getClass(), "readConfiguration(input) done.");
    }

    @Override
    @Deprecated
    public void updateConfiguration(Function<String, BiFunction<String, String, String>> mapper) throws IOException {
        GlassFishLoggingTracer.trace(this.getClass(), "updateConfiguration(mapper) ignored.");
    }

    @Override
    @Deprecated
    public void updateConfiguration(InputStream ins, Function<String, BiFunction<String, String, String>> mapper) throws IOException {
        GlassFishLoggingTracer.trace(this.getClass(), "updateConfiguration(ins, mapper) ignored.");
    }

    public GlassFishLoggingStatus getLoggingStatus() {
        return status;
    }

    public List<GlassFishLogger> getAllLoggers() {
        return Collections.list(this.getLoggerNames()).stream().map(this::getLogger).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Handler> getAllHandlers() {
        Function<GlassFishLogger, Stream> toHandler = logger -> Arrays.stream(logger.getHandlers());
        return Collections.list(this.getLoggerNames()).stream().map(this::getLogger).filter(Objects::nonNull).flatMap(toHandler).collect(Collectors.toList());
    }

    public GlassFishLogger getRootLogger() {
        return this.userRootLogger;
    }

    public void reconfigure(GlassFishLogManagerConfiguration cfg) {
        this.reconfigure(cfg, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reconfigure(GlassFishLogManagerConfiguration cfg, Action reconfigureAction, Action flushAction) {
        block15: {
            long start = System.nanoTime();
            GlassFishLoggingTracer.trace(this.getClass(), () -> "reconfigure(cfg, action, action); Configuration:\n" + cfg + "\n reconfigureAction: " + reconfigureAction + "\n flushAction: " + flushAction);
            if (cfg.isTracingEnabled()) {
                GlassFishLoggingTracer.setTracingEnabled(cfg.isTracingEnabled());
            }
            this.setStatus(GlassFishLoggingStatus.CONFIGURING);
            this.configuration = cfg;
            ConfigurationHelper configurationHelper = this.getConfigurationHelper();
            LoggingSystemEnvironment.setReleaseParametersEarly(configurationHelper.getBoolean(GlassFishLogManagerProperty.KEY_RELEASE_PARAMETERS_EARLY, LoggingSystemEnvironment.isReleaseParametersEarly()));
            LoggingSystemEnvironment.setResolveLevelWithIncompleteConfiguration(configurationHelper.getBoolean(GlassFishLogManagerProperty.KEY_RESOLVE_LEVEL_WITH_INCOMPLETE_CONFIGURATION, LoggingSystemEnvironment.isResolveLevelWithIncompleteConfiguration()));
            Thread currentThread = Thread.currentThread();
            ClassLoader originalCL = currentThread.getContextClassLoader();
            try {
                GlassFishLoggingTracer.trace(GlassFishLogManager.class, "Reconfiguring logger levels...");
                Enumeration<String> existingLoggerNames = this.getLoggerNames();
                while (existingLoggerNames.hasMoreElements()) {
                    String existingLoggerName = existingLoggerNames.nextElement();
                    if (ROOT_LOGGER_NAME.equals(existingLoggerName)) {
                        this.systemRootLogger.setLevel(this.getLevel(GlassFishLogManagerProperty.KEY_SYS_ROOT_LOGGER_LEVEL, Level.INFO));
                        this.userRootLogger.setLevel(this.getLevel(GlassFishLogManagerProperty.KEY_USR_ROOT_LOGGER_LEVEL, Level.INFO));
                        continue;
                    }
                    GlassFishLogger logger = this.getLogger(existingLoggerName);
                    if (logger == null) continue;
                    Level level = this.getLevel(existingLoggerName + ".level", null);
                    GlassFishLoggingTracer.trace(this.getClass(), "Configuring logger level for '" + existingLoggerName + "' to '" + level + "'");
                    logger.setLevel(level);
                }
                GlassFishLoggingTracer.trace(this.getClass(), "Updated logger levels successfully.");
                this.initializeRootLoggers();
                if (reconfigureAction != null) {
                    try {
                        currentThread.setContextClassLoader(reconfigureAction.getClassLoader());
                        reconfigureAction.run();
                    }
                    finally {
                        currentThread.setContextClassLoader(originalCL);
                    }
                }
                Predicate<Handler> isReadyPredicate = h -> !ExternallyManagedLogHandler.class.isInstance(h) || ((ExternallyManagedLogHandler)ExternallyManagedLogHandler.class.cast(h)).isReady();
                List<Handler> handlers = this.getAllHandlers();
                if (!handlers.isEmpty() && !handlers.stream().allMatch(isReadyPredicate)) break block15;
                this.setStatus(GlassFishLoggingStatus.FLUSHING_BUFFERS);
                if (flushAction != null) {
                    try {
                        currentThread.setContextClassLoader(flushAction.getClassLoader());
                        flushAction.run();
                    }
                    finally {
                        currentThread.setContextClassLoader(originalCL);
                    }
                }
                StartupQueue queue = StartupQueue.getInstance();
                GlassFishLoggingTracer.trace(this.getClass(), () -> "Count of records waiting in the queue: " + queue.getSize());
                queue.toStream().forEach(o -> o.getLogger().checkAndLog(o.getRecord()));
                queue.reset();
                this.setStatus(GlassFishLoggingStatus.FULL_SERVICE);
            }
            finally {
                GlassFishLoggingTracer.trace(this.getClass(), "Reconfiguration finished in " + (System.nanoTime() - start) + " ns");
                GlassFishLoggingTracer.setTracingEnabled(cfg.isTracingEnabled());
            }
        }
    }

    public void closeAllExternallyManagedLogHandlers() {
        GlassFishLoggingTracer.trace(GlassFishLogManager.class, "closeAllExternallyManagedLogHandlers()");
        List<GlassFishLogger> loggers = this.getAllLoggers();
        HashSet handlersToClose = new HashSet();
        Consumer<GlassFishLogger> remover = logger -> {
            List<Handler> handlers = logger.getHandlers(ExternallyManagedLogHandler.class);
            handlersToClose.addAll(handlers);
            handlers.forEach(logger::removeHandler);
        };
        loggers.forEach(remover);
        GlassFishLoggingTracer.trace(this.getClass(), () -> "Handlers to be closed: " + handlersToClose);
        handlersToClose.forEach(Handler::close);
    }

    private boolean callJULAddLogger(GlassFishLogger newLogger) {
        if (System.getSecurityManager() == null) {
            return super.addLogger(newLogger);
        }
        PrivilegedAction<Boolean> action = () -> super.addLogger(newLogger);
        return AccessController.doPrivileged(action);
    }

    private void setStatus(GlassFishLoggingStatus status) {
        GlassFishLoggingTracer.trace(this.getClass(), () -> "setLoggingStatus(status=" + status + ")");
        GlassFishLogManager.status = status;
    }

    private static GlassFishLogger replaceWithGlassFishLogger(Logger logger) {
        GlassFishLoggingTracer.trace(GlassFishLogManager.class, "replaceWithGlassFishLogger(" + logger.getName() + ")");
        if (logger instanceof GlassFishLogger) {
            return (GlassFishLogger)logger;
        }
        return new GlassFishLogger(logger);
    }

    private GlassFishLogger ensureGlassFishLoggerOrWrap(Logger logger) {
        if (logger instanceof GlassFishLogger) {
            return (GlassFishLogger)logger;
        }
        GlassFishLoggingTracer.error(this.getClass(), "Emergency wrapping logger!", new RuntimeException());
        return new GlassFishLoggerWrapper(logger);
    }

    private void doFirstInitialization(LoggingProperties properties) {
        GlassFishLoggingTracer.trace(this.getClass(), () -> "Initializing logManager: " + this);
        try {
            RESET_PROTECTION.set(false);
            this.setStatus(GlassFishLoggingStatus.UNCONFIGURED);
            this.configuration = new GlassFishLogManagerConfiguration(properties);
            this.globalLogger.setParent(this.userRootLogger);
            this.initializeRootLoggers();
            this.reconfigure(this.configuration);
        }
        catch (Exception e) {
            GlassFishLoggingTracer.error(this.getClass(), "Initialization of " + this + " failed!", e);
            throw e;
        }
        finally {
            RESET_PROTECTION.set(true);
        }
    }

    private void initializeRootLoggers() {
        GlassFishLoggingTracer.trace(this.getClass(), "initializeRootLoggers()");
        GlassFishLogger referenceLogger = this.getRootLogger();
        List<String> requestedHandlerNames = this.getConfigurationHelper().getList(GlassFishLogManagerProperty.KEY_ROOT_HANDLERS, null);
        List<Handler> currentHandlers = Arrays.asList(referenceLogger.getHandlers());
        ArrayList<Handler> handlersToAdd = new ArrayList<Handler>();
        ArrayList<Handler> handlersToRemove = new ArrayList<Handler>();
        for (String handlerClass : requestedHandlerNames) {
            Handler newHandler;
            if (currentHandlers.stream().noneMatch(h -> h.getClass().getName().equals(handlerClass)) && (newHandler = (Handler)GlassFishLogManager.create(handlerClass)) != null) {
                handlersToAdd.add(newHandler);
            }
            List existingToReinstantiate = currentHandlers.stream().filter(h -> h.getClass().getName().equals(handlerClass) && !ExternallyManagedLogHandler.class.isAssignableFrom(h.getClass())).collect(Collectors.toList());
            handlersToRemove.addAll(existingToReinstantiate);
            Function<Handler, Handler> mapper = h -> (Handler)GlassFishLogManager.create(h.getClass().getName());
            handlersToAdd.addAll(existingToReinstantiate.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        Level systemRootLevel = this.getLevel(GlassFishLogManagerProperty.KEY_SYS_ROOT_LOGGER_LEVEL, Level.INFO);
        Level rootLoggerLevel = this.getLevel(GlassFishLogManagerProperty.KEY_USR_ROOT_LOGGER_LEVEL, Level.INFO);
        this.configureRootLogger(this.systemRootLogger, systemRootLevel, requestedHandlerNames, handlersToRemove, handlersToAdd);
        this.configureRootLogger(this.userRootLogger, rootLoggerLevel, requestedHandlerNames, handlersToRemove, handlersToAdd);
        this.setMissingParentToRootLogger(this.userRootLogger);
    }

    private ConfigurationHelper getConfigurationHelper() {
        return new ConfigurationHelper(null, ConfigurationHelper.ERROR_HANDLER_PRINT_TO_STDERR);
    }

    private void setMissingParentToRootLogger(GlassFishLogger rootParentLogger) {
        Enumeration<String> names = this.getLoggerNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            GlassFishLogger logger = this.getLogger(name);
            if (logger == null || logger.getParent() != null || ROOT_LOGGER_NAME.equals(logger.getName())) continue;
            GlassFishLoggingTracer.error(this.getClass(), "Setting parent to logger: " + logger.getName() + "/" + logger);
            logger.setParent(rootParentLogger);
        }
    }

    private void configureRootLogger(GlassFishLogger rootLogger, Level level, List<String> requestedHandlers, List<Handler> handlersToRemove, List<Handler> handlersToAdd) {
        GlassFishLoggingTracer.trace(this.getClass(), () -> "configureRootLogger(rootLogger=" + rootLogger + ", level=" + level + ", requestedHandlers=" + requestedHandlers + ")");
        rootLogger.setLevel(level);
        List<Handler> currentHandlers = Arrays.asList(rootLogger.getHandlers());
        if (requestedHandlers == null || requestedHandlers.isEmpty()) {
            GlassFishLoggingTracer.error(this.getClass(), "No handlers set for the root logger!");
            return;
        }
        for (Handler handler : handlersToRemove) {
            rootLogger.removeHandler(handler);
            handler.close();
        }
        for (Handler handler : currentHandlers) {
            if (!requestedHandlers.stream().noneMatch(name -> name.equals(handler.getClass().getName()))) continue;
            rootLogger.removeHandler(handler);
            handler.close();
        }
        for (Handler handler : handlersToAdd) {
            rootLogger.addHandler(handler);
        }
    }

    private Level getLevel(GlassFishLogManagerProperty property, Level defaultLevel) {
        return this.getLevel(property.getPropertyName(), defaultLevel);
    }

    private Level getLevel(String property, Level defaultLevel) {
        String levelProperty = this.getProperty(property);
        if (levelProperty == null || levelProperty.isEmpty()) {
            return defaultLevel;
        }
        try {
            return Level.parse(levelProperty);
        }
        catch (IllegalArgumentException e) {
            GlassFishLoggingTracer.error(this.getClass(), "Could not parse level " + levelProperty + ", returning " + defaultLevel + ".", e);
            return defaultLevel;
        }
    }

    private static <T> T create(String clazz) {
        GlassFishLoggingTracer.trace(GlassFishLogManager.class, () -> "create(clazz=" + clazz + ")");
        try {
            return (T)Class.forName(clazz).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            GlassFishLoggingTracer.error(GlassFishLogManager.class, "Could not create " + clazz, e);
            return null;
        }
    }

    private static LoggingProperties ensureSortedProperties(Properties properties) {
        if (properties == null) {
            return GlassFishLogManager.provideProperties();
        }
        if (properties instanceof LoggingProperties) {
            return (LoggingProperties)properties;
        }
        return new LoggingProperties(properties);
    }

    private static LoggingProperties provideProperties() {
        try {
            LoggingProperties propertiesFromJvmOption = GlassFishLogManager.toProperties(System.getProperty("java.util.logging.config.file"));
            if (propertiesFromJvmOption != null) {
                return propertiesFromJvmOption;
            }
            LoggingProperties propertiesFromClasspath = GlassFishLogManager.loadFromClasspath();
            if (propertiesFromClasspath != null) {
                return propertiesFromClasspath;
            }
            if (Boolean.getBoolean("java.util.logging.config.useDefaults")) {
                return GlassFishLogManager.createDefaultProperties();
            }
            throw new IllegalStateException("Could not find any logging.properties configuration file neither from JVM option (java.util.logging.config.file) nor from classpath and even java.util.logging.config.useDefaults wasn't set to true.");
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load logging configuration file.", e);
        }
    }

    private static LoggingProperties createDefaultProperties() {
        LoggingProperties cfg = new LoggingProperties();
        String level = System.getProperty("java.util.logging.config.defaultLevel", Level.INFO.getName());
        cfg.setProperty(GlassFishLogManagerProperty.KEY_SYS_ROOT_LOGGER_LEVEL.getPropertyName(), level);
        cfg.setProperty(GlassFishLogManagerProperty.KEY_USR_ROOT_LOGGER_LEVEL.getPropertyName(), level);
        cfg.setProperty(GlassFishLogManagerProperty.KEY_ROOT_HANDLERS.getPropertyName(), SimpleLogHandler.class.getName());
        cfg.setProperty(SimpleLogHandler.SimpleLogHandlerProperty.LEVEL.getPropertyFullName(), level);
        return cfg;
    }

    private static LoggingProperties toProperties(String absolutePath) throws IOException {
        if (absolutePath == null) {
            return null;
        }
        File file = new File(absolutePath);
        if (!file.canRead()) {
            return null;
        }
        return LoggingProperties.loadFrom(file);
    }

    private static LoggingProperties loadFromClasspath() throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        GlassFishLoggingTracer.trace(GlassFishLogManager.class, () -> "loadFromClasspath(); classloader: " + classLoader);
        try (InputStream input = classLoader.getResourceAsStream("logging.properties");){
            if (input == null) {
                LoggingProperties loggingProperties = null;
                return loggingProperties;
            }
            LoggingProperties loggingProperties = LoggingProperties.loadFrom(input);
            return loggingProperties;
        }
    }

    @FunctionalInterface
    public static interface Action {
        public void run();

        default public ClassLoader getClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

