/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.tracing;

import java.io.PrintStream;
import java.util.function.Supplier;

public final class GlassFishLoggingTracer {
    private static final String JVM_OPT_LOGGING_TRACING_ENABLED = "org.glassfish.main.jul.tracing.enabled";
    private static final PrintStream OUT = System.out;
    private static final PrintStream ERR = System.err;
    private static volatile boolean tracingEnabled = Boolean.getBoolean("org.glassfish.main.jul.tracing.enabled");

    private GlassFishLoggingTracer() {
    }

    public static void setTracingEnabled(boolean tracingEnabled) {
        GlassFishLoggingTracer.tracingEnabled = tracingEnabled;
    }

    public static boolean isTracingEnabled() {
        return tracingEnabled;
    }

    public static synchronized void trace(Class<?> source, Supplier<String> message) {
        if (tracingEnabled) {
            GlassFishLoggingTracer.trace(source, message.get());
        }
    }

    public static synchronized void trace(Class<?> source, String message) {
        if (tracingEnabled) {
            OUT.println(source.getCanonicalName() + ": " + message);
            OUT.flush();
        }
    }

    public static synchronized void stacktrace(Class<?> source, String exceptionMessage) {
        if (tracingEnabled) {
            OUT.println(source.getCanonicalName() + ": Don't panic, following stacktrace is only to see what invoked this!");
            new RuntimeException(exceptionMessage).printStackTrace(OUT);
            OUT.flush();
        }
    }

    public static synchronized void error(Class<?> source, String message) {
        ERR.println(source.getCanonicalName() + ": " + message);
        ERR.flush();
    }

    public static synchronized void error(Class<?> source, String message, Throwable cause) {
        ERR.println(source.getCanonicalName() + ": " + message);
        cause.printStackTrace(ERR);
        ERR.flush();
    }
}

