/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.config.GrizzlyConfigException;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.bootstrap.DescriptorFileFinder;
import org.glassfish.hk2.bootstrap.HK2Populator;
import org.glassfish.hk2.bootstrap.impl.ClasspathDescriptorFileFinder;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

public class Utils {
    private static final Logger LOGGER = Grizzly.logger(Utils.class);

    public static ServiceLocator getServiceLocator(String fileURL) {
        ServiceLocator habitat;
        URL url = Utils.class.getClassLoader().getResource(fileURL);
        if (url == null) {
            try {
                url = new URL(fileURL);
            }
            catch (MalformedURLException e) {
                throw new GrizzlyConfigException(e.getMessage());
            }
        }
        try {
            habitat = Utils.getServiceLocator(url.openStream(), url.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return habitat;
    }

    public static ServiceLocator getServiceLocator(InputStream inputStream, String name) {
        try {
            ServiceLocator habitat = Utils.getNewServiceLocator(name);
            ConfigParser parser = new ConfigParser(habitat);
            XMLInputFactory xif = XMLInputFactory.class.getClassLoader() == null ? XMLInputFactory.newFactory() : XMLInputFactory.newFactory(XMLInputFactory.class.getName(), XMLInputFactory.class.getClassLoader());
            DomDocument document = parser.parse(xif.createXMLStreamReader(inputStream));
            ServiceLocatorUtilities.addOneConstant((ServiceLocator)habitat, (Object)document);
            return habitat;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GrizzlyConfigException(e.getMessage(), e);
        }
    }

    public static ServiceLocator getNewServiceLocator(String name) {
        ServiceLocator habitat = null;
        if (ServiceLocatorFactory.getInstance().find(name) == null) {
            ServiceLocator serviceLocator = ServiceLocatorFactory.getInstance().create(name);
            DynamicConfigurationService dcs = (DynamicConfigurationService)serviceLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
            DynamicConfiguration config = dcs.createDynamicConfiguration();
            config.commit();
            habitat = ServiceLocatorFactory.getInstance().create(name);
            try {
                HK2Populator.populate((ServiceLocator)serviceLocator, (DescriptorFileFinder)new ClasspathDescriptorFileFinder(Utils.class.getClassLoader()), null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return habitat != null ? habitat : ServiceLocatorFactory.getInstance().create(name);
    }

    public static String composeThreadPoolName(NetworkListener networkListener) {
        return networkListener.getThreadPool() + '-' + networkListener.getPort();
    }

    public static <E> E newInstance(ServiceLocator habitat, Class<E> clazz, String name, String realClassName) {
        return Utils.newInstance(habitat, clazz, name, realClassName, null, null);
    }

    public static <E> E newInstance(ServiceLocator habitat, Class<E> clazz, String name, String realClassName, Class<?>[] argTypes, Object[] args) {
        boolean isInitialized = false;
        Object instance = null;
        if (habitat != null) {
            instance = habitat.getService(clazz, name, new Annotation[0]);
        }
        if (instance == null) {
            try {
                instance = argTypes == null || argTypes.length == 0 ? Utils.newInstance(realClassName) : Utils.newInstance(realClassName, argTypes, args);
                isInitialized = true;
            }
            catch (Exception ignored) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, ignored.toString(), ignored);
                }
            }
        } else {
            isInitialized = true;
        }
        if (!isInitialized) {
            LOGGER.log(Level.WARNING, "Instance could not be initialized. Class={0}, name={1}, realClassName={2}", new Object[]{clazz, name, realClassName});
            return null;
        }
        return (E)instance;
    }

    public static Object newInstance(String classname) throws Exception {
        return Utils.loadClass(classname).newInstance();
    }

    public static Object newInstance(String classname, Class<?>[] argTypes, Object[] args) throws Exception {
        Class clazz = Utils.loadClass(classname);
        Constructor c = clazz.getConstructor(argTypes);
        assert (c != null);
        return c.newInstance(args);
    }

    public static Class loadClass(String classname) throws ClassNotFoundException {
        Class<?> clazz = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            try {
                clazz = cl.loadClass(classname);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (clazz == null) {
            clazz = Utils.class.getClassLoader().loadClass(classname);
        }
        return clazz;
    }

    public static boolean isDebugVM() {
        boolean debugMode = false;
        List<String> l = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String s : l) {
            if (!s.trim().startsWith("-Xrunjdwp:") && !s.contains("jdwp")) continue;
            debugMode = true;
            break;
        }
        return debugMode;
    }
}

