/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.RemoteConsumer;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.FeatureUnavailableException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.DestMetricsCounters;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.lists.SimpleNFLHashMap;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Topic
extends Destination {
    static final long serialVersionUID = -5748515630523651753L;
    private static boolean DEBUG = false;
    private transient Map selectorToInterest;
    private transient List selectors;
    private transient Map remoteConsumers;
    private static int TOPIC_DEFAULT_PREFETCH = Globals.getConfig().getIntProperty("imq.autocreate.topic.consumerFlowLimit", 1000);
    private boolean hasNoLocalConsumers = false;
    int maxSharedConsumers = 0;
    int sharedPrefetch = 0;
    public static final String MAX_SHARE_CONSUMERS = "max_shared_consumers";
    public static final String SHARED_PREFETCH = "sharedPrefetch";
    public static final int AUTO_MAX_SHARED_CONSUMER_LIMIT = Globals.getConfig().getIntProperty("imq.autocreate.topic.maxNumSharedConsumers", -1);
    public static final int AUTO_MAX_SHARED_FLOW_LIMIT = Globals.getConfig().getIntProperty("imq.autocreate.topic.sharedConsumerFlowLimit", 5);
    public static final int ADMIN_MAX_SHARED_CONSUMER_LIMIT = Globals.getConfig().getIntProperty("imq.admincreate.topic.maxNumSharedConsumers", -1);
    public static final int ADMIN_MAX_SHARED_FLOW_LIMIT = Globals.getConfig().getIntProperty("imq.admincreate.topic.sharedConsumerFlowLimit", 5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable getDebugState() {
        Hashtable ht = super.getDebugState();
        Hashtable sel = new Hashtable();
        Map map = this.selectorToInterest;
        synchronized (map) {
            for (Selector selector : this.selectorToInterest.keySet()) {
                Set s = (Set)this.selectorToInterest.get(selector);
                Vector<String> v = new Vector<String>();
                Set set = s;
                synchronized (set) {
                    for (Consumer c : s) {
                        v.add(String.valueOf(c.getConsumerUID().longValue()));
                    }
                }
                sel.put(selector == null ? "no selector" : selector.toString(), v);
            }
        }
        ht.put("selectorInfo", sel);
        ht.put(MAX_SHARE_CONSUMERS, this.maxSharedConsumers);
        ht.put(SHARED_PREFETCH, this.sharedPrefetch);
        return ht;
    }

    protected Topic(DestinationUID uid) {
        super(uid);
    }

    protected Topic(String destination, int type, boolean store, ConnectionUID id, boolean autocreate, DestinationList dl) throws FeatureUnavailableException, BrokerException, IOException {
        super(destination, type, store, id, autocreate, dl);
        this.maxPrefetch = TOPIC_DEFAULT_PREFETCH;
        if (autocreate) {
            this.maxSharedConsumers = AUTO_MAX_SHARED_CONSUMER_LIMIT;
            this.sharedPrefetch = AUTO_MAX_SHARED_FLOW_LIMIT;
        } else {
            this.maxSharedConsumers = ADMIN_MAX_SHARED_CONSUMER_LIMIT;
            this.sharedPrefetch = ADMIN_MAX_SHARED_FLOW_LIMIT;
        }
    }

    @Override
    protected void initVar() {
        this.selectorToInterest = new HashMap();
        this.selectors = new ArrayList();
        this.remoteConsumers = new HashMap();
    }

    @Override
    public void unload(boolean refs) {
        super.unload(refs);
        if (refs) {
            for (Consumer con : this.consumers.values()) {
                con.unloadMessages();
            }
        }
    }

    @Override
    public int getUnackSize() {
        return this.getUnackSize(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUnackSize(Set msgset) {
        HashSet s = msgset;
        if (s == null) {
            SimpleNFLHashMap simpleNFLHashMap = this.destMessages;
            synchronized (simpleNFLHashMap) {
                s = new HashSet(this.destMessages.values());
            }
        }
        int counter = 0;
        for (PacketReference ref : s) {
            if (ref.isInvalid() || ref.isDestroyed() || ref.getDeliverCnt() - ref.getCompleteCnt() <= 0) continue;
            ++counter;
        }
        return counter;
    }

    @Override
    public Set routeAndMoveMessage(PacketReference oldRef, PacketReference newRef) throws IOException, BrokerException {
        throw new RuntimeException("XXX not implemented");
    }

    @Override
    public boolean queueMessage(PacketReference pkt, boolean trans) throws BrokerException {
        if (!trans && this.consumers.size() == 0) {
            return false;
        }
        return super.queueMessage(pkt, trans);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.initVar();
        ois.defaultReadObject();
    }

    @Override
    public void eventOccured(EventType type, Reason reason, Object source, Object OrigValue, Object NewValue, Object userdata) {
        super.eventOccured(type, reason, source, OrigValue, NewValue, userdata);
    }

    @Deprecated
    public void routeNewMessage(SysMessageID id) throws BrokerException, SelectorFormatException {
        PacketReference ref = (PacketReference)this.destMessages.get((Object)id);
        Set s = this.routeNewMessage(ref);
        this.forwardMessage(s, ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConsumerCount() {
        int count = super.getConsumerCount();
        Map map = this.remoteConsumers;
        synchronized (map) {
            for (RemoteConsumer rc : this.remoteConsumers.values()) {
                count += rc.getConsumerCount();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ConsumerUID[] routeLoadedTransactionMessage(PacketReference msg) throws BrokerException, SelectorFormatException {
        HashSet matching = new HashSet();
        Map props = null;
        HashMap headers = null;
        Map map = this.selectorToInterest;
        synchronized (map) {
            for (Selector selector : this.selectorToInterest.keySet()) {
                Set s;
                boolean matches;
                if (selector != null) {
                    if (props == null && selector.usesProperties()) {
                        try {
                            props = msg.getProperties();
                        }
                        catch (ClassNotFoundException ex) {
                            this.logger.logStack(32, "INTERNAL ERROR", (Throwable)ex);
                            props = new HashMap();
                        }
                    }
                    if (headers == null && selector.usesFields()) {
                        headers = msg.getHeaders();
                    }
                }
                if (!(matches = selector == null || selector.match(props, headers))) continue;
                if (DEBUG) {
                    this.logger.log(8, "Selector " + selector + " Matches " + msg.getSysMessageID());
                }
                if ((s = (Set)this.selectorToInterest.get(selector)) == null) continue;
                Set set = s;
                synchronized (set) {
                    matching.addAll(s);
                }
            }
        }
        HashSet<ConsumerUID> hs = new HashSet<ConsumerUID>();
        Iterator nlitr = matching.iterator();
        ConnectionUID pcuid = msg.getProducingConnectionUID();
        String clientid = msg.getClientID();
        while (nlitr.hasNext()) {
            Consumer c = (Consumer)nlitr.next();
            if (c.getNoLocal()) {
                if (c instanceof Subscription && clientid != null && ((Subscription)c).getClientID() != null && ((Subscription)c).getClientID().equals(clientid)) {
                    nlitr.remove();
                    continue;
                }
                if (c.getConsumerUID().getConnectionUID() == pcuid) {
                    nlitr.remove();
                    continue;
                }
                hs.add(c.getConsumerUID());
                continue;
            }
            hs.add(c.getConsumerUID());
        }
        return hs.toArray(new ConsumerUID[hs.size()]);
    }

    @Override
    public void unrouteLoadedTransactionAckMessage(PacketReference ref, ConsumerUID consumerId) throws BrokerException {
        this.logger.log(4, "unrouteLoadedTransactionAckMessage num consumers = " + this.consumers.size());
        Consumer consumer = this.getConsumer(consumerId);
        if (consumer == null) {
            this.logger.log(4, "could not find consumer for " + consumerId);
        } else {
            consumer.unrouteMessage(ref);
        }
    }

    @Override
    public void routeNewMessageWithDeliveryDelay(PacketReference msg) throws BrokerException, SelectorFormatException {
        this.routeNewMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set routeNewMessage(PacketReference msg) throws BrokerException, SelectorFormatException {
        HashSet matching = new HashSet();
        Map props = null;
        HashMap headers = null;
        for (int i = 0; i < this.selectors.size(); ++i) {
            Set set;
            Set s;
            Selector selector = null;
            try {
                selector = (Selector)this.selectors.get(i);
            }
            catch (Exception ex) {
                continue;
            }
            if (selector == null) {
                s = (Set)this.selectorToInterest.get(null);
                if (s == null) continue;
                set = s;
                synchronized (set) {
                    matching.addAll(s);
                    continue;
                }
            }
            if (props == null && selector.usesProperties()) {
                try {
                    props = msg.getProperties();
                }
                catch (ClassNotFoundException ex) {
                    this.logger.logStack(32, "INTERNAL ERROR", (Throwable)ex);
                    props = new HashMap();
                }
            }
            if (headers == null && selector.usesFields()) {
                headers = msg.getHeaders();
            }
            if (!selector.match(props, headers) || (s = (Set)this.selectorToInterest.get(selector)) == null) continue;
            set = s;
            synchronized (set) {
                matching.addAll(s);
                continue;
            }
        }
        if (this.hasNoLocalConsumers) {
            Iterator nlitr = matching.iterator();
            ConnectionUID pcuid = msg.getProducingConnectionUID();
            String clientid = msg.getClientID();
            while (nlitr.hasNext()) {
                Consumer c = (Consumer)nlitr.next();
                if (!c.getNoLocal()) continue;
                if (c instanceof Subscription && clientid != null && ((Subscription)c).getClientID() != null && ((Subscription)c).getClientID().equals(clientid)) {
                    nlitr.remove();
                    continue;
                }
                if (c.getConsumerUID().getConnectionUID() != pcuid) continue;
                nlitr.remove();
            }
        }
        if (matching.isEmpty()) {
            this.removeMessage(msg.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
            return null;
        }
        msg.store(matching);
        return matching;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set routeMessage(PacketReference msg, boolean forStoreOnly) throws BrokerException, SelectorFormatException {
        HashSet matching = new HashSet();
        Map props = null;
        HashMap headers = null;
        for (int i = 0; i < this.selectors.size(); ++i) {
            Set s;
            Selector selector = null;
            try {
                selector = (Selector)this.selectors.get(i);
            }
            catch (Exception ex) {
                continue;
            }
            if (selector == null) {
                s = (Set)this.selectorToInterest.get(null);
                if (s == null) continue;
                Set set = s;
                synchronized (set) {
                    matching.addAll(s);
                    continue;
                }
            }
            if (props == null && selector.usesProperties()) {
                try {
                    props = msg.getProperties();
                }
                catch (ClassNotFoundException ex) {
                    this.logger.logStack(32, "INTERNAL ERROR", (Throwable)ex);
                    props = new HashMap();
                }
            }
            if (headers == null && selector.usesFields()) {
                headers = msg.getHeaders();
            }
            if ((s = (Set)this.selectorToInterest.get(selector)) == null) continue;
            if (forStoreOnly) {
                boolean needsStoring = false;
                Set set = s;
                synchronized (set) {
                    for (Consumer consumer : s) {
                        if (consumer == null || !consumer.getStoredConsumerUID().shouldStore) continue;
                        needsStoring = true;
                        break;
                    }
                    if (!needsStoring) {
                        continue;
                    }
                }
            }
            if (!selector.match(props, (Map)headers)) continue;
            Set needsStoring = s;
            synchronized (needsStoring) {
                matching.addAll(s);
                continue;
            }
        }
        if (this.hasNoLocalConsumers) {
            Iterator nlitr = matching.iterator();
            ConnectionUID pcuid = msg.getProducingConnectionUID();
            String clientid = msg.getClientID();
            while (nlitr.hasNext()) {
                Consumer c = (Consumer)nlitr.next();
                if (!c.getNoLocal()) continue;
                if (c instanceof Subscription && clientid != null && ((Subscription)c).getClientID() != null && ((Subscription)c).getClientID().equals(clientid)) {
                    nlitr.remove();
                    continue;
                }
                if (c.getConsumerUID().getConnectionUID() != pcuid) continue;
                nlitr.remove();
            }
        }
        return matching;
    }

    @Override
    public ConsumerUID[] calculateStoredInterests(PacketReference ref) throws BrokerException, SelectorFormatException {
        ConsumerUID[] storedInterests = null;
        try {
            Set allConsumers = this.routeMessage(ref, true);
            storedInterests = ref.getRoutingForStore(allConsumers);
        }
        catch (BrokerException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new BrokerException(ex.toString(), ex);
        }
        return storedInterests;
    }

    @Override
    public void forwardOrphanMessages(Collection refs, ConsumerUID consumer) throws BrokerException {
        BrokerException ex = new BrokerException("INTERNAL ERROR: Unexpected call");
        this.logger.logStack(32, ex.getMessage(), (Throwable)ex);
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forwardOrphanMessage(PacketReference ref, ConsumerUID consumer) throws BrokerException {
        Consumer c;
        block7: {
            c = this.getConsumer(consumer);
            if (c == null) {
                this.logger.log(4, "Could not find " + consumer + " in " + this.getName() + "size=" + this.consumers.size());
                for (Object v : this.consumers.keySet()) {
                    this.logger.log(4, "consumer= " + v);
                }
                this.logger.log(4, "Dumping orphan message " + ref);
                try {
                    if (!ref.acknowledged(consumer, consumer, false, false)) break block7;
                    try {
                        this.removeMessage(ref.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                    }
                    finally {
                        ref.postAcknowledgedRemoval();
                    }
                }
                catch (Exception ex) {
                    this.logger.logStack(4, "Error forwarding orphan", (Throwable)ex);
                }
            }
        }
        HashSet<Consumer> matches = new HashSet<Consumer>();
        matches.add(c);
        this.forwardMessage(matches, ref, false, ref.getOrder() != null);
    }

    @Override
    public void forwardMessage(Set matching, PacketReference msg) throws BrokerException {
        this.forwardMessage(matching, msg, false, false);
    }

    @Override
    public void forwardDeliveryDelayedMessage(Set<ConsumerUID> matching, PacketReference msg) throws BrokerException {
        HashSet<Consumer> targets = null;
        if (matching != null) {
            Consumer c = null;
            ConsumerUID cuid2 = null;
            for (ConsumerUID cuid2 : matching) {
                c = this.getConsumer(cuid2);
                if (c == null || !c.isValid()) continue;
                if (targets == null) {
                    targets = new HashSet<Consumer>();
                }
                targets.add(c);
            }
        }
        this.forwardMessage(targets, msg, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardMessage(Set<Consumer> matching, PacketReference msg, boolean toFront, boolean ordered) throws BrokerException {
        HashSet<Consumer> remote = null;
        if (matching == null || matching.isEmpty()) {
            this.removeMessage(msg.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
        } else {
            for (Consumer c : matching) {
                if (c.isFalconRemote()) {
                    if (remote == null) {
                        remote = new HashSet<Consumer>();
                    }
                    remote.add(c);
                    continue;
                }
                if (c.routeMessage(msg, false, ordered)) continue;
                boolean acked = false;
                try {
                    ConsumerUID cid = c.getConsumerUID();
                    acked = msg.acknowledged(cid, c.getStoredConsumerUID(), !cid.isUnsafeAck(), true);
                    if (!acked) continue;
                    try {
                        this.removeMessage(msg.getSysMessageID(), null);
                    }
                    finally {
                        msg.postAcknowledgedRemoval();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (remote != null && !remote.isEmpty()) {
            Globals.getClusterBroadcast().forwardMessage(msg, remote);
        }
    }

    @Override
    public Consumer addConsumer(Consumer c, boolean notify, Connection conn) throws BrokerException, SelectorFormatException {
        return this.addConsumer(c, notify, conn, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Consumer addConsumer(Consumer c, boolean notify, Connection conn, boolean loadIfActive) throws BrokerException, SelectorFormatException {
        if (c instanceof Subscription && this.consumers.get((Object)c.getConsumerUID()) != null) {
            return null;
        }
        super.addConsumer(c, notify, conn, loadIfActive);
        this.hasNoLocalConsumers |= c.getNoLocal();
        Selector selector = c.getSelector();
        HashSet<Consumer> s = null;
        Object object = this.selectorToInterest;
        synchronized (object) {
            s = (HashSet<Consumer>)this.selectorToInterest.get(selector);
            if (s == null) {
                s = new HashSet<Consumer>();
                this.selectorToInterest.put(selector, s);
                this.selectors.add(selector);
            }
        }
        object = s;
        synchronized (object) {
            s.add(c);
        }
        if (!(c instanceof Subscription)) {
            this.notifyConsumerAdded(c, conn);
        }
        return null;
    }

    @Override
    public void removeConsumer(ConsumerUID interest, boolean notify) throws BrokerException {
        this.removeConsumer(interest, null, false, notify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(ConsumerUID interest, Map remotePendings, boolean remoteCleanup, boolean notify) throws BrokerException {
        Consumer c = (Consumer)this.consumers.get((Object)interest);
        if (c == null) {
            return;
        }
        Set s = null;
        Map map = this.selectorToInterest;
        synchronized (map) {
            s = (Set)this.selectorToInterest.get(c.getSelector());
            if (s != null) {
                Set set = s;
                synchronized (set) {
                    s.remove(c);
                    if (s.isEmpty()) {
                        this.selectorToInterest.remove(c.getSelector());
                        this.selectors.remove(c.getSelector());
                    }
                }
            }
        }
        super.removeConsumer(interest, remotePendings, remoteCleanup, notify);
        if (!(c instanceof Subscription)) {
            this.notifyConsumerRemoved();
        }
    }

    @Override
    public void sort(Comparator c) {
    }

    @Override
    protected void getDestinationProps(Map m) {
        super.getDestinationProps(m);
        m.put(MAX_SHARE_CONSUMERS, this.maxSharedConsumers);
        m.put(SHARED_PREFETCH, this.sharedPrefetch);
    }

    @Override
    public void setDestinationProperties(Map m) throws BrokerException {
        super.setDestinationProperties(m);
        if (m.get(MAX_SHARE_CONSUMERS) != null) {
            try {
                this.setMaxSharedConsumers((Integer)m.get(MAX_SHARE_CONSUMERS));
            }
            catch (Exception ex) {
                this.logger.logStack(16, "setMaxSharedConsumers()", (Throwable)ex);
            }
        }
        if (m.get(SHARED_PREFETCH) != null) {
            try {
                this.setSharedFlowLimit((Integer)m.get(SHARED_PREFETCH));
            }
            catch (Exception ex) {
                this.logger.logStack(16, "setSharedFlowLimit()", (Throwable)ex);
            }
        }
    }

    @Override
    public DestMetricsCounters getMetrics() {
        DestMetricsCounters dmc = super.getMetrics();
        return dmc;
    }

    @Override
    public void setMaxSharedConsumers(int max) {
        this.maxSharedConsumers = max;
    }

    @Override
    public void setSharedFlowLimit(int prefetch) {
        this.sharedPrefetch = prefetch;
    }

    @Override
    public int getMaxNumSharedConsumers() {
        return this.maxSharedConsumers;
    }

    @Override
    public int getSharedConsumerFlowLimit() {
        return this.sharedPrefetch;
    }
}

