/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public class TransactionWorkMessageAck {
    DestinationUID destUID;
    SysMessageID sysMessageID;
    ConsumerUID consumerID;
    TransactionAcknowledgement ta = null;

    public TransactionWorkMessageAck() {
    }

    public TransactionWorkMessageAck(DestinationUID dest, SysMessageID sysMessageID, ConsumerUID consumerID) {
        this.destUID = dest;
        this.sysMessageID = sysMessageID;
        this.consumerID = consumerID;
    }

    public DestinationUID getDestUID() {
        return this.destUID;
    }

    public void setDest(DestinationUID dest) {
        this.destUID = dest;
    }

    public SysMessageID getSysMessageID() {
        return this.sysMessageID;
    }

    public void setSysMessageID(SysMessageID sysMessageID) {
        this.sysMessageID = sysMessageID;
    }

    public ConsumerUID getConsumerID() {
        return this.consumerID;
    }

    public void setConsumerID(ConsumerUID consumerID) {
        this.consumerID = consumerID;
    }

    public void setTransactionAcknowledgement(TransactionAcknowledgement ta) {
        this.ta = ta;
    }

    public TransactionAcknowledgement getTransactionAcknowledgement() {
        return this.ta;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("dest=").append(this.destUID);
        result.append(" sysMessageID=").append(this.sysMessageID);
        result.append(" consumerID=").append(this.consumerID);
        return result.toString();
    }

    public void writeWork(DataOutputStream dos) throws IOException {
        dos.writeUTF(this.destUID.toString());
        this.sysMessageID.writeID((DataOutput)dos);
        dos.writeLong(this.consumerID.longValue());
    }

    public void readWork(DataInputStream dis) throws IOException, BrokerException {
        String dest = dis.readUTF();
        this.destUID = new DestinationUID(dest);
        this.sysMessageID = new SysMessageID();
        this.sysMessageID.readID((DataInput)dis);
        long cid = dis.readLong();
        this.consumerID = new ConsumerUID(cid);
    }
}

