/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import java.lang.reflect.Method;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public abstract class MQMBeanReadWrite
extends MQMBeanReadOnly {
    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("MBean " + this.getMBeanName() + ": Null attribute passed to setAttribute()"));
        }
        String name = attribute.getName();
        String methodName = "set" + name;
        Object value = attribute.getValue();
        Method m = null;
        this.checkSettableAttribute(name, value);
        try {
            Class[] methodParams = new Class[]{value.getClass()};
            m = this.getClass().getMethod(methodName, methodParams);
        }
        catch (NoSuchMethodException noSuchE) {
            String tmp = "MBean " + this.getMBeanName() + ": Cannot find method " + methodName;
            throw new ReflectionException(noSuchE, tmp);
        }
        catch (SecurityException se) {
            throw new ReflectionException(se);
        }
        try {
            Object[] params = new Object[]{value};
            m.invoke((Object)this, params);
        }
        catch (Exception e) {
            throw new MBeanException(e, e.toString());
        }
    }

    public void logProblemGettingOldVal(String attr, Exception e) {
        this.logger.log(32, this.getMBeanName() + " notification " + "jmx.attribute.change" + ": encountered problem while getting old value of attribute " + attr + ": " + e);
    }

    private void checkSettableAttribute(String name, Object value) throws AttributeNotFoundException, InvalidAttributeValueException {
        MBeanAttributeInfo attrInfo = this.getAttributeInfo(name);
        if (attrInfo == null) {
            throw new AttributeNotFoundException("The attribute " + name + " is not a valid attribute for MBean" + this.getMBeanName());
        }
        if (!attrInfo.isWritable()) {
            throw new AttributeNotFoundException("The attribute " + name + " is not a settable attribute for MBean" + this.getMBeanName());
        }
        if (!attrInfo.getType().equals(value.getClass().getName())) {
            throw new InvalidAttributeValueException("The type of the value used to set the attribute " + name + " is incorrect (" + value.getClass().getName() + ").\nThe expected value type is " + attrInfo.getType() + ".");
        }
    }
}

