/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.log;

import com.sun.messaging.jmq.resources.SharedResources;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.log.SysLog;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class SysLogHandler
extends Handler {
    static String ident = "SysLogHandler";
    static int facility = 24;
    static int logopt = 3;
    private static final String PREFIX = "imq.log.syslog.";
    public static final String FACILITY = "facility";
    public static final String LOGPID = "logpid";
    public static final String LOGCONSOLE = "logconsole";
    public static final String IDENTITY = "identity";
    public static final String OUTPUT = "output";
    static boolean open = false;
    private boolean allowForceMessage = false;

    public SysLogHandler() {
        try {
            LogManager lm = LogManager.getLogManager();
            String property = "imq.log.syslog.facility";
            String facilityStr = lm.getProperty(property);
            property = "imq.log.syslog.logpid";
            String logpidStr = lm.getProperty(property);
            property = "imq.log.syslog.logconsole";
            String logconsoleStr = lm.getProperty(property);
            property = "imq.log.syslog.identity";
            String identityStr = lm.getProperty(property);
            property = "imq.log.syslog.output";
            String outputStr = lm.getProperty(property);
            this.configure(facilityStr, logpidStr, logconsoleStr, identityStr, outputStr);
        }
        catch (UnsatisfiedLinkError e) {
            java.util.logging.Logger logger = java.util.logging.Logger.getLogger("imq.log.Logger");
            logger.log(Level.WARNING, SharedResources.getResources().getKString("S2004", this.getClass().getName(), e.getMessage()));
            open = false;
        }
        catch (NoClassDefFoundError e) {
            java.util.logging.Logger logger = java.util.logging.Logger.getLogger("imq.log.Logger");
            logger.log(Level.WARNING, SharedResources.getResources().getKString("S2004", this.getClass().getName(), e.getMessage()));
            open = false;
        }
    }

    public SysLogHandler(Properties props) {
        try {
            String property = "imq.log.syslog.facility";
            String facilityStr = props.getProperty(property);
            property = "imq.log.syslog.logpid";
            String logpidStr = props.getProperty(property);
            property = "imq.log.syslog.logconsole";
            String logconsoleStr = props.getProperty(property);
            property = "imq.log.syslog.identity";
            String identityStr = props.getProperty(property);
            property = "imq.log.syslog.output";
            String outputStr = props.getProperty(property);
            this.configure(facilityStr, logpidStr, logconsoleStr, identityStr, outputStr);
        }
        catch (UnsatisfiedLinkError e) {
            java.util.logging.Logger logger = java.util.logging.Logger.getLogger("imq.log.Logger");
            logger.log(Level.WARNING, SharedResources.getResources().getKString("S2004", this.getClass().getName(), e.getMessage()));
            open = false;
        }
        catch (NoClassDefFoundError e) {
            java.util.logging.Logger logger = java.util.logging.Logger.getLogger("imq.log.Logger");
            logger.log(Level.WARNING, SharedResources.getResources().getKString("S2004", this.getClass().getName(), e.getMessage()));
            open = false;
        }
    }

    public static void setFacility(int f) {
        facility = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(String facilityStr, String logpidStr, String logconsoleStr, String identityStr, String outputStr) throws IllegalArgumentException, UnsatisfiedLinkError {
        String error_msg = null;
        Class<SysLogHandler> clazz = SysLogHandler.class;
        synchronized (SysLogHandler.class) {
            if (facilityStr != null) {
                try {
                    SysLogHandler.setFacility(24);
                }
                catch (Exception e) {
                    error_msg = "Bad syslog facility imq.log.syslog.facility=" + facilityStr;
                }
            }
            if (logpidStr != null && logpidStr.equalsIgnoreCase("true")) {
                logopt |= 1;
            }
            if (logconsoleStr != null && logconsoleStr.equalsIgnoreCase("true")) {
                logopt |= 2;
            }
            ident = identityStr;
            if (outputStr != null) {
                try {
                    int configLevel = Logger.levelStrToInt(outputStr);
                    Level levelSetByConfig = Logger.levelIntToJULLevel(configLevel);
                    this.setLevel(levelSetByConfig);
                }
                catch (IllegalArgumentException e) {
                    error_msg = (error_msg != null ? error_msg + "\n" : "") + PREFIX + OUTPUT + ": " + e.getMessage();
                }
            }
            if (open) {
                this.close();
            }
            this.open();
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Class<SysLogHandler> clazz = SysLogHandler.class;
        synchronized (SysLogHandler.class) {
            if (!open) {
                SysLog.openlog(ident, logopt, facility);
                open = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Class<SysLogHandler> clazz = SysLogHandler.class;
        synchronized (SysLogHandler.class) {
            if (open) {
                SysLog.closelog();
                open = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        return this.getClass().getName() + ":" + ident;
    }

    @Override
    public void publish(LogRecord record) {
        if (!open) {
            return;
        }
        int priority = 6;
        if (Logger.levelJULLevelToInt(record.getLevel()) == 64 && !this.allowForceMessage) {
            return;
        }
        if (!this.isLoggable(record)) {
            return;
        }
        switch (Logger.levelJULLevelToInt(record.getLevel())) {
            case 32: {
                priority = 3;
                break;
            }
            case 16: {
                priority = 4;
                break;
            }
            case 8: {
                priority = 6;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                priority = 7;
            }
        }
        SysLog.syslog(priority, record.getMessage());
    }

    @Override
    public void flush() {
    }
}

