/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsclient.ContainerType;
import com.sun.messaging.jmq.jmsclient.JMSContextImpl;
import com.sun.messaging.jms.JMSException;
import com.sun.messaging.jms.JMSSecurityException;
import com.sun.messaging.jms.ra.ConnectionAdapter;
import com.sun.messaging.jms.ra.ConnectionCreator;
import com.sun.messaging.jms.ra.ConnectionRequestInfo;
import com.sun.messaging.jms.ra.ManagedConnection;
import com.sun.messaging.jms.ra.ManagedConnectionFactory;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.SecurityException;
import javax.transaction.xa.XAResource;

public class ConnectionFactoryAdapter
extends ConnectionCreator
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
Referenceable,
Serializable {
    private ManagedConnectionFactory mcf = null;
    private ConnectionManager cm = null;
    private Reference reference = null;
    private static final String _className = "com.sun.messaging.jms.ra.ConnectionFactoryAdapter";
    protected static final String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    protected static final String _lgrNameJMSConnectionFactory = "javax.jms.ConnectionFactory.mqjmsra";
    protected static final Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    protected static final Logger _loggerJF = Logger.getLogger("javax.jms.ConnectionFactory.mqjmsra");
    protected static final String _lgrMIDPrefix = "MQJMSRA_FA";
    protected static final String _lgrMID_EET = "MQJMSRA_FA1001: ";
    protected static final String _lgrMID_INF = "MQJMSRA_FA1101: ";
    protected static final String _lgrMID_WRN = "MQJMSRA_FA2001: ";
    protected static final String _lgrMID_ERR = "MQJMSRA_FA3001: ";
    protected static final String _lgrMID_EXC = "MQJMSRA_FA4001: ";

    public ConnectionFactoryAdapter(ManagedConnectionFactory mcf, ConnectionManager cm) {
        Object[] params = new Object[]{mcf, cm};
        _loggerOC.entering(_className, "constructor()", params);
        this.mcf = mcf;
        this.cm = cm;
    }

    public void setReference(Reference ref) {
        this.reference = ref;
    }

    public Reference getReference() throws NamingException {
        throw new NamingException("MQRA:CFA:getReference:NOT Supported");
    }

    public Connection createConnection() throws javax.jms.JMSException {
        _loggerJF.entering(_className, "createConnection()");
        return this.createConnection(null, null);
    }

    public Connection createConnection(String username, String password) throws javax.jms.JMSException {
        _loggerJF.entering(_className, "createConnection()", username);
        return this._allocateConnection(username, password);
    }

    public JMSContext createContext() {
        return new JMSContextImpl(this, this.getContainerType());
    }

    public JMSContext createContext(String userName, String password) {
        return new JMSContextImpl(this, this.getContainerType(), userName, password);
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        return new JMSContextImpl(this, this.getContainerType(), userName, password, sessionMode);
    }

    public JMSContext createContext(int sessionMode) {
        return new JMSContextImpl(this, this.getContainerType(), sessionMode);
    }

    private ContainerType getContainerType() {
        if (this.mcf.getInAppClientContainer()) {
            return ContainerType.JavaEE_ACC;
        }
        return ContainerType.JavaEE_Web_or_EJB;
    }

    private Connection _allocateConnection(String username, String password) throws javax.jms.JMSException {
        ConnectionAdapter ca;
        ConnectionRequestInfo.ConnectionType connectionType = ConnectionRequestInfo.ConnectionType.TOPIC_CONNECTION;
        ConnectionRequestInfo crinfo = new ConnectionRequestInfo(this.mcf, username, password, connectionType);
        try {
            ca = (ConnectionAdapter)this.cm.allocateConnection((javax.resource.spi.ManagedConnectionFactory)this.mcf, (javax.resource.spi.ConnectionRequestInfo)crinfo);
        }
        catch (SecurityException se) {
            throw new JMSSecurityException("MQRA:CFA:allocation failure:createConnection:" + se.getMessage(), se.getErrorCode(), se);
        }
        catch (ResourceException re) {
            throw new JMSException("MQRA:CFA:allocation failure:createConnection:" + re.getMessage(), re.getErrorCode(), re);
        }
        return ca;
    }

    public QueueConnection createQueueConnection() throws javax.jms.JMSException {
        _loggerJF.entering(_className, "createQueueConnection()");
        return this.createQueueConnection(null, null);
    }

    public QueueConnection createQueueConnection(String username, String password) throws javax.jms.JMSException {
        _loggerJF.entering(_className, "createQueueConnection()", username);
        return this._allocateQueueConnection(username, password);
    }

    private QueueConnection _allocateQueueConnection(String username, String password) throws javax.jms.JMSException {
        ConnectionAdapter ca;
        ConnectionRequestInfo.ConnectionType connectionType = ConnectionRequestInfo.ConnectionType.QUEUE_CONNECTION;
        ConnectionRequestInfo crinfo = new ConnectionRequestInfo(this.mcf, username, password, connectionType);
        try {
            ca = (ConnectionAdapter)this.cm.allocateConnection((javax.resource.spi.ManagedConnectionFactory)this.mcf, (javax.resource.spi.ConnectionRequestInfo)crinfo);
        }
        catch (SecurityException se) {
            throw new JMSSecurityException("MQRA:CFA:allocation failure:createQueueConnection:" + se.getMessage(), se.getErrorCode(), se);
        }
        catch (ResourceException re) {
            throw new JMSException("MQRA:CFA:allocation failure:createQueueConnection:" + re.getMessage(), re.getErrorCode(), re);
        }
        return ca;
    }

    public TopicConnection createTopicConnection() throws javax.jms.JMSException {
        _loggerJF.entering(_className, "createTopicConnection()");
        return this.createTopicConnection(null, null);
    }

    public TopicConnection createTopicConnection(String username, String password) throws javax.jms.JMSException {
        _loggerJF.entering(_className, "createTopicConnection()", username);
        return this._allocateTopicConnection(username, password);
    }

    private TopicConnection _allocateTopicConnection(String username, String password) throws javax.jms.JMSException {
        ConnectionRequestInfo.ConnectionType connectionType = ConnectionRequestInfo.ConnectionType.TOPIC_CONNECTION;
        ConnectionRequestInfo crinfo = new ConnectionRequestInfo(this.mcf, username, password, connectionType);
        try {
            ConnectionAdapter ca = (ConnectionAdapter)this.cm.allocateConnection((javax.resource.spi.ManagedConnectionFactory)this.mcf, (javax.resource.spi.ConnectionRequestInfo)crinfo);
            return ca;
        }
        catch (SecurityException se) {
            throw new JMSSecurityException("MQRA:CFA:allocation failure:createTopicConnection:" + se.getMessage(), se.getErrorCode(), se);
        }
        catch (ResourceException re) {
            throw new JMSException("MQRA:CFA:allocation failure:createTopicConnection:" + re.getMessage(), re.getErrorCode(), re);
        }
    }

    @Override
    protected Connection _createConnection(String un, String pw) throws javax.jms.JMSException {
        return this.mcf._getXACF().createXAConnection(un, pw);
    }

    @Override
    protected Connection _createQueueConnection(String un, String pw) throws javax.jms.JMSException {
        return null;
    }

    @Override
    protected Connection _createTopicConnection(String un, String pw) throws javax.jms.JMSException {
        return null;
    }

    @Override
    protected XAResource _createXAResource(ManagedConnection mc, Object conn) throws javax.jms.JMSException {
        return null;
    }

    ManagedConnectionFactory getMCF() {
        return this.mcf;
    }
}

