/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jts.admin.cli;

import com.sun.enterprise.config.serverbeans.Server;
import jakarta.inject.Inject;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.jts.admin.cli.RecoverTransactionsBase;
import org.jvnet.hk2.annotations.Service;

@Service(name="recover-transactions")
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@ExecuteOn(value={RuntimeType.DAS})
@PerLookup
@I18n(value="recover.transactions")
@RestEndpoints(value={@RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.POST, path="recover-transactions", description="Recover Transactions", params={@RestParam(name="id", value="$parent")})})
public class RecoverTransactions
extends RecoverTransactionsBase
implements AdminCommand {
    @Param(name="target", alias="destination", optional=true)
    String destinationServer;
    @Inject
    CommandRunner runner;

    public void execute(AdminCommandContext context) {
        String error;
        ActionReport report = context.getActionReport();
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("==> original target: " + this.destinationServer + " ... server: " + this.serverToRecover);
        }
        if ((error = this.validate(this.destinationServer, false)) != null) {
            LOG.log(Level.WARNING, MESSAGES.getString("recover.transactions.failed") + " " + error);
            report.setMessage(error);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.destinationServer == null) {
            this.destinationServer = this.serverToRecover;
        }
        try {
            CommandRunner.CommandInvocation inv = this.runner.getCommandInvocation("_recover-transactions-internal", report, context.getSubject());
            ParameterMap parameters = new ParameterMap();
            parameters.add((Object)"target", (Object)this.destinationServer);
            parameters.add((Object)"DEFAULT", (Object)this.serverToRecover);
            parameters.add((Object)"transactionlogdir", (Object)this.transactionLogDir);
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("==> calling _recover-transactions-internal with params: " + parameters);
            }
            inv.parameters(parameters).execute();
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("==> _recover-transactions-internal returned with: " + report.getActionExitCode());
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, MESSAGES.getString("recover.transactions.failed"), e);
            report.setMessage(MESSAGES.getString("recover.transactions.failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

