/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.WebArchivist;
import com.sun.enterprise.security.web.GlassFishSingleSignOn;
import com.sun.enterprise.server.logging.GFFileHandler;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.common.PlainTextActionReporter;
import com.sun.enterprise.v3.services.impl.GrizzlyListener;
import com.sun.enterprise.v3.services.impl.GrizzlyProxy;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.web.ContextFacade;
import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.PEAccessLogValve;
import com.sun.enterprise.web.PEWebContainerFeatureFactoryImpl;
import com.sun.enterprise.web.SSOFactory;
import com.sun.enterprise.web.VirtualServerPipeline;
import com.sun.enterprise.web.WebConnector;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.logger.CatalinaLogger;
import com.sun.enterprise.web.logger.FileLoggerHandler;
import com.sun.enterprise.web.logger.FileLoggerHandlerFactory;
import com.sun.enterprise.web.pluggable.WebContainerFeatureFactory;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.http.ErrorHandler;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Request;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.valves.RemoteAddrValve;
import org.apache.catalina.valves.RemoteHostValve;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.web.ConfigException;
import org.glassfish.embeddable.web.Context;
import org.glassfish.embeddable.web.WebListener;
import org.glassfish.embeddable.web.config.VirtualServerConfig;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.web.loader.WebappClassLoader;
import org.glassfish.web.valve.GlassFishValve;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualServer
extends StandardHost
implements org.glassfish.embeddable.web.VirtualServer {
    private static final String STATE = "state";
    private static final String SSO_MAX_IDLE = "sso-max-inactive-seconds";
    private static final String SSO_REAP_INTERVAL = "sso-reap-interval-seconds";
    private static final String SSO_COOKIE_SECURE = "sso-cookie-secure";
    private static final String DISABLED = "disabled";
    private static final String OFF = "off";
    private static final String ON = "on";
    private static final Logger DEFAULT_LOGGER = LogDomains.getLogger(VirtualServer.class, (String)"javax.enterprise.system.container.web");
    protected static final ResourceBundle rb = DEFAULT_LOGGER.getResourceBundle();
    private VirtualServerPipeline vsPipeline;
    private Pipeline origPipeline;
    private String _id = null;
    protected volatile Logger _logger = DEFAULT_LOGGER;
    private static final String _info = "com.sun.enterprise.web.VirtualServer/1.0";
    private com.sun.enterprise.config.serverbeans.VirtualServer vsBean;
    private MimeMap mimeMap;
    private boolean allowLinking = false;
    private String[] cacheControls;
    private ClassLoaderHierarchy clh;
    private Domain domain;
    private Habitat habitat;
    private CommandRunner runner;
    private ServerEnvironment instance;
    private boolean isActive;
    private String authRealmName;
    private PEAccessLogValve accessLogValve;
    private String ssoCookieSecure = null;
    private boolean ssoCookieHttpOnly = false;
    private String defaultContextPath = null;
    private ServerContext serverContext;
    private Config serverConfig;
    private GrizzlyService grizzlyService;
    private WebContainer webContainer;
    private boolean ssoFailoverEnabled = false;
    private volatile FileLoggerHandler fileLoggerHandler = null;
    private volatile FileLoggerHandlerFactory fileLoggerHandlerFactory = null;
    private VirtualServerConfig config;
    private List<WebListener> listeners = new ArrayList<WebListener>();
    private ArchiveFactory factory = null;
    private ActionReport report = null;
    private Deployment deployment = null;

    public VirtualServer() {
        this.origPipeline = this.pipeline;
        this.vsPipeline = new VirtualServerPipeline(this);
        this.accessLogValve = new PEAccessLogValve();
        this.accessLogValve.setContainer((Container)this);
    }

    public String getID() {
        return this._id;
    }

    public void setID(String id) {
        this._id = id;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
        if (isActive) {
            this.vsPipeline.setIsDisabled(false);
            this.vsPipeline.setIsOff(false);
            if (this.pipeline == this.vsPipeline && !this.vsPipeline.hasRedirects()) {
                this.setPipeline(this.origPipeline);
            }
        }
    }

    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public com.sun.enterprise.config.serverbeans.VirtualServer getBean() {
        return this.vsBean;
    }

    public void setBean(com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        this.vsBean = vsBean;
    }

    public MimeMap getMimeMap() {
        return this.mimeMap;
    }

    public void setMimeMap(MimeMap mimeMap) {
        this.mimeMap = mimeMap;
    }

    public String[] getCacheControls() {
        return this.cacheControls;
    }

    public void setCacheControls(String[] cacheControls) {
        this.cacheControls = cacheControls;
    }

    public void setCommandRunner(CommandRunner runner) {
        this.runner = runner;
    }

    public String getInfo() {
        return _info;
    }

    public void setDefaultContextPath(String defaultContextPath) {
        this.defaultContextPath = defaultContextPath;
    }

    public void setFileLoggerHandlerFactory(FileLoggerHandlerFactory factory) {
        this.fileLoggerHandlerFactory = factory;
    }

    public void setServerEnvironment(ServerEnvironment instance) {
        this.instance = instance;
    }

    public void setClassLoaderHierarchy(ClassLoaderHierarchy clh) {
        this.clh = clh;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public void setHabitat(Habitat habitat) {
        this.habitat = habitat;
    }

    public Container findChild(String contextRoot) {
        if (this.defaultContextPath != null && "/".equals(contextRoot)) {
            return super.findChild(this.defaultContextPath);
        }
        return super.findChild(contextRoot);
    }

    public void configureSingleSignOnCookieSecure(Cookie ssoCookie, HttpServletRequest hreq) {
        super.configureSingleSignOnCookieSecure(ssoCookie, hreq);
        if (this.ssoCookieSecure != null && !this.ssoCookieSecure.equals("dynamic")) {
            ssoCookie.setSecure(Boolean.parseBoolean(this.ssoCookieSecure));
        }
    }

    public void configureSingleSignOnCookieHttpOnly(Cookie ssoCookie) {
        ssoCookie.setHttpOnly(this.ssoCookieHttpOnly);
    }

    public synchronized void addValve(GlassFishValve valve) {
        super.addValve(valve);
        if (this.pipeline == this.vsPipeline) {
            this.origPipeline.addValve(valve);
        } else {
            this.vsPipeline.addValve(valve);
        }
    }

    public synchronized void addValve(Valve valve) {
        super.addValve(valve);
        if (this.pipeline == this.vsPipeline) {
            this.origPipeline.addValve(valve);
        } else {
            this.vsPipeline.addValve(valve);
        }
    }

    public synchronized void removeValve(GlassFishValve valve) {
        super.removeValve(valve);
        if (this.pipeline == this.vsPipeline) {
            this.origPipeline.removeValve(valve);
        } else {
            this.vsPipeline.removeValve(valve);
        }
    }

    protected String getDefaultContextPath(Domain domain, ApplicationRegistry appRegistry) {
        Applications appsBean;
        WebModuleConfig wmInfo;
        String contextRoot = null;
        String wmID = this.getDefaultWebModuleID();
        if (wmID != null && (contextRoot = (wmInfo = this.findWebModuleInJ2eeApp(appsBean = domain.getApplications(), wmID, appRegistry)) == null ? ConfigBeansUtilities.getContextRoot((String)wmID) : wmInfo.getContextPath()) == null) {
            Object[] params = new Object[]{wmID, this.getID()};
            this._logger.log(Level.SEVERE, "vs.defaultWebModuleNotFound", params);
        }
        return contextRoot;
    }

    protected WebModuleConfig getDefaultWebModule(Domain domain, WebArchivist webArchivist, ApplicationRegistry appRegistry) {
        WebModuleConfig wmInfo = null;
        String wmID = this.getDefaultWebModuleID();
        if (wmID != null) {
            Applications appsBean = domain.getApplications();
            wmInfo = this.findWebModuleInJ2eeApp(appsBean, wmID, appRegistry);
            if (wmInfo == null) {
                String contextRoot = ConfigBeansUtilities.getContextRoot((String)wmID);
                String location = ConfigBeansUtilities.getLocation((String)wmID);
                if (contextRoot != null && location != null) {
                    File docroot = new File(location);
                    WebBundleDescriptor wbd = webArchivist.getDefaultWebXmlBundleDescriptor();
                    wmInfo = new WebModuleConfig();
                    wbd.setName("__default-web-module");
                    wbd.setContextRoot(contextRoot);
                    wmInfo.setLocation(docroot);
                    wmInfo.setDescriptor(wbd);
                    wmInfo.setParentLoader(EmbeddedWebContainer.class.getClassLoader());
                    wmInfo.setAppClassLoader((ClassLoader)new WebappClassLoader(wmInfo.getParentLoader()));
                }
            }
            if (wmInfo == null) {
                this._logger.log(Level.SEVERE, "vs.defaultWebModuleNotFound", new Object[]{wmID, this.getID()});
            }
        }
        return wmInfo;
    }

    public WebModuleConfig createSystemDefaultWebModuleIfNecessary(WebArchivist webArchivist) {
        WebModuleConfig wmInfo = null;
        String docroot = this.getAppBase();
        if (this.getDefaultWebModuleID() == null && this.findChild("") == null && docroot != null) {
            WebBundleDescriptor wbd = webArchivist.getDefaultWebXmlBundleDescriptor();
            wmInfo = new WebModuleConfig();
            wbd.setModuleID("__default-web-module");
            wbd.setContextRoot("");
            wmInfo.setLocation(new File(docroot));
            wmInfo.setDescriptor(wbd);
            wmInfo.setParentLoader(this.serverContext.getCommonClassLoader());
            WebappClassLoader loader = new WebappClassLoader(wmInfo.getParentLoader());
            loader.start();
            wmInfo.setAppClassLoader((ClassLoader)loader);
            if (wbd.getApplication() == null) {
                Application application = new Application(Globals.getDefaultHabitat());
                application.setVirtual(true);
                application.setName("__default-web-module");
                wbd.setApplication(application);
            }
        }
        return wmInfo;
    }

    private boolean isActive(com.sun.enterprise.config.serverbeans.WebModule wm) {
        return this.isActive(wm, true);
    }

    protected boolean isActive(com.sun.enterprise.config.serverbeans.WebModule wm, boolean matchVSID) {
        String vsID = this.getID();
        boolean active = vsID != null && vsID.length() > 0;
        if (active &= wm != null) {
            List vsList;
            active &= Boolean.valueOf(wm.getEnabled()).booleanValue();
            String vsIDs = this.getVirtualServers(wm.getName());
            if (this.getID().equals("__asadmin") && matchVSID && (vsIDs == null || vsIDs.length() == 0)) {
                return false;
            }
            active = matchVSID && vsIDs != null && vsIDs.length() > 0 ? ((vsList = StringUtils.parseStringList((String)vsIDs, (String)" ,")) != null ? (active &= vsList.contains(vsID.trim())) : (active &= true)) : (active &= true);
        }
        return active;
    }

    protected String getDefaultWebModuleID() {
        String wmID = this.vsBean.getDefaultWebModule();
        if ("".equals(wmID)) {
            wmID = null;
        }
        if (wmID != null && this._logger.isLoggable(Level.FINE)) {
            Object[] params = new Object[]{wmID, this._id};
            this._logger.log(Level.FINE, "vs.defaultWebModule", params);
        }
        return wmID;
    }

    protected WebModuleConfig findWebModuleInJ2eeApp(Applications appsBean, String id, ApplicationRegistry appRegistry) {
        WebModuleConfig wmInfo = null;
        int length = id.length();
        int separatorIndex = id.indexOf(":");
        if (separatorIndex == -1) {
            separatorIndex = id.indexOf(35);
        }
        if (separatorIndex != -1) {
            String appID = id.substring(0, separatorIndex);
            String moduleID = id.substring(separatorIndex + 1);
            com.sun.enterprise.config.serverbeans.Application appBean = (com.sun.enterprise.config.serverbeans.Application)appsBean.getModule(com.sun.enterprise.config.serverbeans.Application.class, appID);
            if (appBean != null && Boolean.valueOf(appBean.getEnabled()).booleanValue()) {
                String location = appBean.getLocation();
                String moduleDir = DeploymentUtils.getRelativeEmbeddedModulePath((String)location, (String)moduleID);
                ApplicationInfo appInfo = appRegistry.get(appID);
                Application app = null;
                if (appInfo == null) {
                    Object[] params = new Object[]{id, this.getID()};
                    this._logger.log(Level.SEVERE, "vs.defaultWebModuleDisabled", params);
                    return wmInfo;
                }
                app = (Application)appInfo.getMetaData(Application.class);
                WebBundleDescriptor wbd = app.getWebBundleDescriptorByUri(moduleID);
                String webUri = wbd.getModuleDescriptor().getArchiveUri();
                String contextRoot = wbd.getModuleDescriptor().getContextRoot();
                if (moduleID.equals(webUri)) {
                    StringBuilder dir = new StringBuilder(location);
                    dir.append(File.separator);
                    dir.append(moduleDir);
                    File docroot = new File(dir.toString());
                    wmInfo = new WebModuleConfig();
                    wbd.setName(moduleID);
                    wbd.setContextRoot(contextRoot);
                    wmInfo.setDescriptor(wbd);
                    wmInfo.setLocation(docroot);
                    wmInfo.setParentLoader(EmbeddedWebContainer.class.getClassLoader());
                    wmInfo.setAppClassLoader((ClassLoader)new WebappClassLoader(wmInfo.getParentLoader()));
                }
            } else {
                Object[] params = new Object[]{id, this.getID()};
                this._logger.log(Level.SEVERE, "vs.defaultWebModuleDisabled", params);
            }
        }
        return wmInfo;
    }

    private String getVirtualServers(String appName) {
        String ret = null;
        Server server = (Server)Globals.getDefaultHabitat().getComponent(Server.class);
        for (ApplicationRef appRef : server.getApplicationRef()) {
            if (!appRef.getRef().equals(appName)) continue;
            return appRef.getVirtualServers();
        }
        return ret;
    }

    public void clearAliases() {
        this.aliases = new String[0];
    }

    private void setIsDisabled(boolean isDisabled) {
        this.vsPipeline.setIsDisabled(isDisabled);
        this.vsPipeline.setIsOff(false);
        if (isDisabled && this.pipeline != this.vsPipeline) {
            this.setPipeline((Pipeline)this.vsPipeline);
        }
    }

    private void setIsOff(boolean isOff) {
        this.vsPipeline.setIsOff(isOff);
        this.vsPipeline.setIsDisabled(false);
        if (isOff && this.pipeline != this.vsPipeline) {
            this.setPipeline((Pipeline)this.vsPipeline);
        }
    }

    private void close(FileLoggerHandler handler) {
        if (handler != null && !handler.isAssociated()) {
            if (this.fileLoggerHandlerFactory != null) {
                this.fileLoggerHandlerFactory.removeHandler(handler.getLogFile());
            }
            handler.flush();
            handler.close();
        }
    }

    private void setLogger(Logger newLogger, String logLevel) {
        this._logger = newLogger;
        CatalinaLogger catalinaLogger = new CatalinaLogger(newLogger);
        catalinaLogger.setLevel(logLevel);
        this.setLogger(catalinaLogger);
    }

    List<Property> getProperties() {
        return this.vsBean.getProperty();
    }

    public void configure(String vsID, com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String vsDocroot, String vsLogFile, MimeMap vsMimeMap, String logServiceFile, String logLevel) {
        this.setDebug(this.debug);
        this.setAppBase(vsDocroot);
        this.setName(vsID);
        this.setID(vsID);
        this.setBean(vsBean);
        this.setMimeMap(vsMimeMap);
        String defaultContextXmlLocation = "config/context.xml";
        String defaultWebXmlLocation = "config/default-web.xml";
        Property prop = vsBean.getProperty("default-web-xml");
        if (prop != null) {
            defaultWebXmlLocation = prop.getValue();
        }
        boolean allowLinking = false;
        prop = vsBean.getProperty("allowLinking");
        if (prop != null) {
            allowLinking = Boolean.parseBoolean(prop.getValue());
        }
        this.setAllowLinking(allowLinking);
        prop = vsBean.getProperty("contextXmlDefault");
        if (prop != null) {
            defaultContextXmlLocation = prop.getValue();
        }
        this.setDefaultWebXmlLocation(defaultWebXmlLocation);
        this.setDefaultContextXmlLocation(defaultContextXmlLocation);
        String state = vsBean.getState();
        if (state == null) {
            state = ON;
        }
        if (DISABLED.equalsIgnoreCase(state)) {
            this.setIsActive(false);
        } else {
            this.setIsActive(Boolean.parseBoolean(state));
        }
        this.setLogFile(vsLogFile, logLevel, logServiceFile);
    }

    protected void configureCatalinaProperties() {
        List props = this.vsBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                this._logger.log(Level.WARNING, "webcontainer.nullWebModuleProperty", this.getName());
            }
            if (propName.startsWith("valve_")) {
                this.addValve(propValue);
                continue;
            }
            if (propName.startsWith("listener_")) {
                this.addListener(propValue);
                continue;
            }
            if (!propName.equals("securePagesWithPragma")) continue;
            this.setSecurePagesWithPragma(Boolean.valueOf(propValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    synchronized void setLogFile(String logFile, String logLevel, String logServiceFile) {
        boolean noCustomLog;
        boolean bl = noCustomLog = logFile == null || logFile.equals(logServiceFile);
        if (this.fileLoggerHandler == null) {
            if (noCustomLog) return;
        }
        if (this.fileLoggerHandler != null && logFile != null && logFile.equals(this.fileLoggerHandler.getLogFile())) {
            return;
        }
        Logger newLogger = null;
        FileLoggerHandler oldHandler = this.fileLoggerHandler;
        if (oldHandler != null) {
            this._logger.removeHandler(oldHandler);
        }
        if (noCustomLog) {
            this.fileLoggerHandler = null;
            newLogger = DEFAULT_LOGGER;
        } else {
            Handler[] rootHandlers;
            Logger rootLogger;
            Handler[] handlers;
            String lname = DEFAULT_LOGGER.getName() + "._vs." + this.getID();
            newLogger = LogManager.getLogManager().getLogger(lname);
            if (newLogger == null) {
                newLogger = new Logger(lname, null){

                    public void log(LogRecord record) {
                        ResourceBundle bundle;
                        if (record.getResourceBundle() == null && (bundle = this.getResourceBundle()) != null) {
                            record.setResourceBundle(bundle);
                        }
                        record.setThreadID((int)Thread.currentThread().getId());
                        super.log(record);
                    }

                    public ResourceBundle getResourceBundle() {
                        return rb;
                    }

                    public synchronized void addHandler(Handler handler) {
                        super.addHandler(handler);
                        if (handler instanceof FileLoggerHandler) {
                            ((FileLoggerHandler)handler).associate();
                        }
                    }

                    public synchronized void removeHandler(Handler handler) {
                        if (!(handler instanceof FileLoggerHandler)) {
                            super.removeHandler(handler);
                        } else {
                            boolean hasHandler = false;
                            Handler[] hs = this.getHandlers();
                            if (hs != null) {
                                for (Handler h : hs) {
                                    if (h != handler) continue;
                                    hasHandler = true;
                                    break;
                                }
                            }
                            if (hasHandler) {
                                super.removeHandler(handler);
                                ((FileLoggerHandler)handler).disassociate();
                            }
                        }
                    }
                };
                Class<Logger> clazz = Logger.class;
                // MONITORENTER : java.util.logging.Logger.class
                LogManager.getLogManager().addLogger(newLogger);
                // MONITOREXIT : clazz
            }
            if ((handlers = newLogger.getHandlers()) != null) {
                for (Handler h : handlers) {
                    newLogger.removeHandler(h);
                }
            }
            if ((rootLogger = Logger.global.getParent()) != null && (rootHandlers = rootLogger.getHandlers()) != null) {
                for (Handler h : rootHandlers) {
                    if (h instanceof GFFileHandler) continue;
                    newLogger.addHandler(h);
                }
            }
            this.fileLoggerHandler = this.fileLoggerHandlerFactory.getHandler(logFile);
            newLogger.addHandler(this.fileLoggerHandler);
            newLogger.setUseParentHandlers(false);
        }
        this.setLogger(newLogger, logLevel);
        this.close(oldHandler);
    }

    void configureAliases() {
        List hosts = StringUtils.parseStringList((String)this.vsBean.getHosts(), (String)",");
        for (int i = 0; i < hosts.size(); ++i) {
            String alias = hosts.get(i).toString();
            if (alias.equalsIgnoreCase("localhost") || alias.equalsIgnoreCase("localhost.localdomain")) continue;
            this.addAlias(alias);
        }
    }

    void configureAliases(String ... hosts) {
        for (String host : hosts) {
            if (host.equalsIgnoreCase("localhost") || host.equalsIgnoreCase("localhost.localdomain")) continue;
            this.addAlias(host);
        }
    }

    void configureAuthRealm(SecurityService securityService) {
        List properties = this.vsBean.getProperty();
        if (properties != null && properties.size() > 0) {
            for (Property p : properties) {
                if (p == null || !"authRealm".equals(p.getName())) continue;
                this.authRealmName = p.getValue();
                if (this.authRealmName == null) break;
                AuthRealm realm = null;
                List rs = securityService.getAuthRealm();
                if (rs != null && rs.size() > 0) {
                    for (AuthRealm r : rs) {
                        if (r == null || !r.getName().equals(this.authRealmName)) continue;
                        realm = r;
                        break;
                    }
                }
                if (realm != null) break;
                this._logger.log(Level.SEVERE, "vs.invalidAuthRealm", new Object[]{this.getID(), this.authRealmName});
                break;
            }
        }
    }

    String getAuthRealmName() {
        return this.authRealmName;
    }

    protected void addValve(String valveName) {
        Object valve = this.safeLoadInstance(valveName);
        if (valve instanceof Valve) {
            this.addValve((Valve)valve);
        } else if (valve instanceof GlassFishValve) {
            this.addValve((GlassFishValve)valve);
        } else {
            this._logger.log(Level.WARNING, "webcontainer.notAValve", valveName);
        }
    }

    protected void addListener(String listenerName) {
        Object listener = this.safeLoadInstance(listenerName);
        if (listener == null) {
            return;
        }
        if (listener instanceof ContainerListener) {
            this.addContainerListener((ContainerListener)listener);
        } else if (listener instanceof LifecycleListener) {
            this.addLifecycleListener((LifecycleListener)listener);
        } else {
            this._logger.log(Level.SEVERE, "vs.invalidListener", new Object[]{listenerName, this.getID()});
        }
    }

    protected Object loadInstance(String className) throws Exception {
        Class<?> clazz = this.serverContext.getCommonClassLoader().loadClass(className);
        return clazz.newInstance();
    }

    private Object safeLoadInstance(String className) {
        try {
            return this.loadInstance(className);
        }
        catch (Throwable ex) {
            this._logger.log(Level.SEVERE, "webcontainer.unableToLoadExtension", ex);
            return null;
        }
    }

    void configureErrorPage() {
        ErrorPage errorPage = null;
        List props = this.vsBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                this._logger.log(Level.WARNING, "webcontainer.nullVirtualServerProperty", this.getID());
                continue;
            }
            if (!propName.startsWith("send-error_")) continue;
            String path = null;
            String reason = null;
            String status = null;
            String[] errorParams = propValue.split(" ");
            for (int j = 0; j < errorParams.length; ++j) {
                if (errorParams[j].startsWith("path=")) {
                    if (path != null) {
                        this._logger.log(Level.WARNING, "webcontainer.sendErrorMultipleElement", new Object[]{propValue, this.getID(), "path"});
                    }
                    path = errorParams[j].substring("path=".length());
                }
                if (errorParams[j].startsWith("reason=")) {
                    if (reason != null) {
                        this._logger.log(Level.WARNING, "webcontainer.sendErrorMultipleElement", new Object[]{propValue, this.getID(), "reason"});
                    }
                    reason = errorParams[j].substring("reason=".length());
                }
                if (!errorParams[j].startsWith("code=")) continue;
                if (status != null) {
                    this._logger.log(Level.WARNING, "webcontainer.sendErrorMultipleElement", new Object[]{propValue, this.getID(), "code"});
                }
                status = errorParams[j].substring("code=".length());
            }
            if (path == null || path.length() == 0) {
                this._logger.log(Level.WARNING, "webcontainer.sendErrorMissingPath", new Object[]{propValue, this.getID()});
            }
            errorPage = new ErrorPage();
            errorPage.setLocation(path);
            errorPage.setErrorCode(status);
            errorPage.setReason(reason);
            this.addErrorPage(errorPage);
        }
    }

    void configureRedirect() {
        this.vsPipeline.clearRedirects();
        List props = this.vsBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                this._logger.log(Level.WARNING, "webcontainer.nullVirtualServerProperty", this.getID());
                continue;
            }
            if (!propName.startsWith("redirect_")) continue;
            String from = null;
            String url = null;
            String urlPrefix = null;
            String escape = null;
            String[] redirectParams = propValue.split(" ");
            for (int j = 0; j < redirectParams.length; ++j) {
                if (redirectParams[j].startsWith("from=")) {
                    if (from != null) {
                        this._logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, this.getID(), "from"});
                    }
                    from = redirectParams[j].substring("from=".length());
                }
                if (redirectParams[j].startsWith("url=")) {
                    if (url != null) {
                        this._logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, this.getID(), "url"});
                    }
                    url = redirectParams[j].substring("url=".length());
                }
                if (redirectParams[j].startsWith("url-prefix=")) {
                    if (urlPrefix != null) {
                        this._logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, this.getID(), "url-prefix"});
                    }
                    urlPrefix = redirectParams[j].substring("url-prefix=".length());
                }
                if (!redirectParams[j].startsWith("escape=")) continue;
                if (escape != null) {
                    this._logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, this.getID(), "escape"});
                }
                escape = redirectParams[j].substring("escape=".length());
            }
            if (from == null || from.length() == 0) {
                this._logger.log(Level.WARNING, "webcontainer.redirectMissingFrom", new Object[]{propValue, this.getID()});
            }
            if (!(url != null && url.length() != 0 || urlPrefix != null && urlPrefix.length() != 0)) {
                this._logger.log(Level.WARNING, "webcontainer.redirectMissingUrlOrUrlPrefix", new Object[]{propValue, this.getID()});
            }
            if (url != null && url.length() > 0 && urlPrefix != null && urlPrefix.length() > 0) {
                this._logger.log(Level.WARNING, "webcontainer.redirectBothUrlAndUrlPrefix", new Object[]{propValue, this.getID()});
            }
            boolean escapeURI = true;
            if (escape != null) {
                if ("yes".equalsIgnoreCase(escape)) {
                    escapeURI = true;
                } else if ("no".equalsIgnoreCase(escape)) {
                    escapeURI = false;
                } else {
                    this._logger.log(Level.WARNING, "webcontainer.redirectInvalidEscape", new Object[]{propValue, this.getID()});
                }
            }
            this.vsPipeline.addRedirect(from, url, urlPrefix, escapeURI);
        }
        if (this.vsPipeline.hasRedirects()) {
            if (this.pipeline != this.vsPipeline) {
                this.setPipeline((Pipeline)this.vsPipeline);
            }
        } else if (this.isActive && this.pipeline != this.origPipeline) {
            this.setPipeline(this.origPipeline);
        }
    }

    void configureSingleSignOn(boolean globalSSOEnabled, WebContainerFeatureFactory webContainerFeatureFactory, boolean ssoFailoverEnabled) {
        if (!this.isSSOEnabled(globalSSOEnabled)) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Disabling Single Sign On (SSO) for virtual server " + this.getID() + ", as configured");
            }
            boolean hasExistingSSO = false;
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                this.removeValve(valves[i]);
                hasExistingSSO = true;
                break;
            }
            this.ssoFailoverEnabled = ssoFailoverEnabled;
            if (hasExistingSSO) {
                this.setSingleSignOnForChildren(null);
            }
        } else {
            Property expireTime;
            Property idle;
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Enabling Single Sign On (SSO) for virtual server " + this.getID() + ", as configured");
            }
            GlassFishSingleSignOn sso = null;
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof GlassFishSingleSignOn)) continue;
                sso = (GlassFishSingleSignOn)valves[i];
                break;
            }
            if (sso != null && this.ssoFailoverEnabled != ssoFailoverEnabled) {
                this.removeValve((GlassFishValve)sso);
                sso = null;
            }
            if (sso == null) {
                SSOFactory ssoFactory = webContainerFeatureFactory.getSSOFactory();
                sso = ssoFactory.createSingleSignOnValve(this.getName());
                this.ssoFailoverEnabled = ssoFailoverEnabled;
                this.setSingleSignOnForChildren(sso);
                this.addValve((GlassFishValve)sso);
            }
            if ((idle = this.vsBean.getProperty(SSO_MAX_IDLE)) != null && idle.getValue() != null) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("SSO entry max idle time set to: " + idle.getValue() + " for virtual server " + this.getID());
                }
                sso.setMaxInactive(Integer.parseInt(idle.getValue()));
            }
            if ((expireTime = this.vsBean.getProperty(SSO_REAP_INTERVAL)) != null && expireTime.getValue() != null) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("SSO expire thread interval set to: " + expireTime.getValue() + " for virtual server " + this.getID());
                }
                sso.setReapInterval(Integer.parseInt(expireTime.getValue()));
            }
            this.configureSingleSignOnCookieSecure();
            this.configureSingleSignOnCookieHttpOnly();
        }
    }

    void configureState() {
        String stateValue = this.vsBean.getState();
        if (!stateValue.equalsIgnoreCase(ON) && this.getName().equalsIgnoreCase("__asadmin")) {
            throw new IllegalArgumentException("virtual-server __asadmin state property cannot be modified");
        }
        if (stateValue.equalsIgnoreCase(DISABLED)) {
            this.setIsDisabled(true);
        } else if (!ConfigBeansUtilities.toBoolean((String)stateValue)) {
            this.setIsOff(true);
        } else {
            this.setIsActive(true);
        }
    }

    void configureRemoteAddressFilterValve() {
        Property allow = this.vsBean.getProperty("allowRemoteAddress");
        Property deny = this.vsBean.getProperty("denyRemoteAddress");
        String allowStr = null;
        String denyStr = null;
        if (allow != null) {
            allowStr = allow.getValue();
        }
        if (deny != null) {
            denyStr = deny.getValue();
        }
        this.configureRemoteAddressFilterValve(allowStr, denyStr);
    }

    protected void configureRemoteAddressFilterValve(String allow, String deny) {
        RemoteAddrValve remoteAddrValve = null;
        if (allow != null || deny != null) {
            remoteAddrValve = new RemoteAddrValve();
        }
        if (allow != null) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Allowing access to " + this.getID() + " from " + allow);
            }
            remoteAddrValve.setAllow(allow);
        }
        if (deny != null) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Denying access to " + this.getID() + " from " + deny);
            }
            remoteAddrValve.setDeny(deny);
        }
        if (remoteAddrValve != null) {
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteAddrValve)) continue;
                this.removeValve(valves[i]);
                break;
            }
            this.addValve((GlassFishValve)remoteAddrValve);
        }
    }

    void configureRemoteHostFilterValve() {
        Property allow = this.vsBean.getProperty("allowRemoteHost");
        Property deny = this.vsBean.getProperty("denyRemoteHost");
        String allowStr = null;
        String denyStr = null;
        if (allow != null) {
            allowStr = allow.getValue();
        }
        if (deny != null) {
            denyStr = deny.getValue();
        }
        this.configureRemoteHostFilterValve(allowStr, denyStr);
    }

    void configureRemoteHostFilterValve(String allow, String deny) {
        RemoteHostValve remoteHostValve = null;
        if (allow != null || deny != null) {
            remoteHostValve = new RemoteHostValve();
        }
        if (allow != null) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Allowing access to " + this.getID() + " from " + allow);
            }
            remoteHostValve.setAllow(allow);
        }
        if (deny != null) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Denying access to " + this.getID() + " from " + deny);
            }
            remoteHostValve.setDeny(deny);
        }
        if (remoteHostValve != null) {
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteHostValve)) continue;
                this.removeValve(valves[i]);
                break;
            }
            this.addValve((GlassFishValve)remoteHostValve);
        }
    }

    void setErrorHandler(Config serverConfig, GrizzlyService grizzlyService, boolean disable) {
        List listenerList = StringUtils.parseStringList((String)this.vsBean.getNetworkListeners(), (String)",");
        String[] listeners = listenerList != null ? listenerList.toArray(new String[listenerList.size()]) : new String[]{};
        ArrayList<NetworkListener> networkListeners = new ArrayList<NetworkListener>();
        for (String listener : listeners) {
            for (NetworkListener networkListener : serverConfig.getNetworkConfig().getNetworkListeners().getNetworkListener()) {
                if (!networkListener.getName().equals(listener)) continue;
                networkListeners.add(networkListener);
            }
        }
        for (final NetworkListener listener : networkListeners) {
            GrizzlyListener grizzlyListener;
            GrizzlyProxy grizzlyProxy = (GrizzlyProxy)grizzlyService.lookupNetworkProxy(listener);
            if (grizzlyProxy == null || (grizzlyListener = grizzlyProxy.getUnderlyingListener()) == null) continue;
            if (disable) {
                grizzlyListener.getEmbeddedHttp().setErrorHandler(null);
                continue;
            }
            if (grizzlyListener.getEmbeddedHttp().getErrorHandler() != null) continue;
            grizzlyListener.getEmbeddedHttp().setErrorHandler(new ErrorHandler(){

                public void onParsingError(com.sun.grizzly.tcp.Response response) {
                    Response res = new Response();
                    res.setCoyoteResponse(response);
                    WebConnector connector = VirtualServer.this.webContainer.getConnectorMap().get(listener.getName());
                    if (connector != null) {
                        org.apache.catalina.connector.Request req = new org.apache.catalina.connector.Request();
                        req.setCoyoteRequest(response.getRequest());
                        req.setConnector((Connector)connector);
                        try {
                            VirtualServer.this.accessLogValve.postInvoke((Request)req, (org.apache.catalina.Response)res);
                        }
                        catch (IOException ex) {
                            VirtualServer.this._logger.log(Level.SEVERE, "pewebcontainer.accesslog.reconfigure", ex);
                        }
                    } else {
                        VirtualServer.this._logger.log(Level.SEVERE, "pewebcontainer.accesslog.reconfigure");
                    }
                }
            });
        }
    }

    void reconfigureAccessLog(String globalAccessLogBufferSize, String globalAccessLogWriteInterval, Habitat habitat, Domain domain, boolean globalAccessLoggingEnabled) {
        try {
            boolean start;
            if (this.accessLogValve.isStarted()) {
                this.accessLogValve.stop();
            }
            if ((start = this.accessLogValve.updateVirtualServerProperties(this.vsBean.getId(), this.vsBean, domain, habitat, globalAccessLogBufferSize, globalAccessLogWriteInterval)) && this.isAccessLoggingEnabled(globalAccessLoggingEnabled)) {
                this.enableAccessLogging();
            } else {
                this.disableAccessLogging();
            }
        }
        catch (LifecycleException le) {
            this._logger.log(Level.SEVERE, "pewebcontainer.accesslog.reconfigure", le);
        }
    }

    void reconfigureAccessLog(HttpService httpService, WebContainerFeatureFactory webcontainerFeatureFactory) {
        try {
            boolean restart = false;
            if (this.accessLogValve.isStarted()) {
                this.accessLogValve.stop();
                restart = true;
            }
            this.accessLogValve.updateAccessLogAttributes(httpService, webcontainerFeatureFactory);
            if (restart) {
                this.accessLogValve.start();
                this.setErrorHandler(this.serverConfig, this.grizzlyService, false);
            }
        }
        catch (LifecycleException le) {
            this._logger.log(Level.SEVERE, "pewebcontainer.accesslog.reconfigure", le);
        }
    }

    PEAccessLogValve getAccessLogValve() {
        return this.accessLogValve;
    }

    void enableAccessLogging() {
        if (!this.isAccessLogValveActivated()) {
            this.addValve((GlassFishValve)this.accessLogValve);
        } else {
            try {
                if (this.accessLogValve.isStarted()) {
                    this.accessLogValve.stop();
                }
                this.accessLogValve.start();
            }
            catch (LifecycleException le) {
                this._logger.log(Level.SEVERE, "pewebcontainer.accesslog.reconfigure", le);
            }
        }
        this.setErrorHandler(this.serverConfig, this.grizzlyService, false);
    }

    void disableAccessLogging() {
        this.removeValve((GlassFishValve)this.accessLogValve);
        this.setErrorHandler(this.serverConfig, this.grizzlyService, true);
    }

    private boolean isAccessLogValveActivated() {
        GlassFishValve[] valves;
        Pipeline p = this.getPipeline();
        if (p != null && (valves = p.getValves()) != null) {
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof PEAccessLogValve)) continue;
                return true;
            }
        }
        return false;
    }

    void configureCacheControl(String cacheControl) {
        List values;
        if (cacheControl != null && (values = StringUtils.parseStringList((String)cacheControl, (String)",")) != null && !values.isEmpty()) {
            this.setCacheControls(values.toArray(new String[values.size()]));
        }
    }

    private boolean isSSOEnabled(boolean globalSSOEnabled) {
        String ssoEnabled = "inherit";
        if (this.vsBean != null) {
            ssoEnabled = this.vsBean.getSsoEnabled();
        }
        return "inherit".equals(ssoEnabled) && globalSSOEnabled || ConfigBeansUtilities.toBoolean((String)ssoEnabled);
    }

    private void setSingleSignOnForChildren(SingleSignOn sso) {
        block0: for (Container container : this.findChildren()) {
            if (!(container instanceof StandardContext)) continue;
            StandardContext context = (StandardContext)container;
            for (GlassFishValve valve : context.getValves()) {
                if (!(valve instanceof AuthenticatorBase)) continue;
                ((AuthenticatorBase)valve).setSingleSignOn(sso);
                continue block0;
            }
        }
    }

    boolean isAccessLoggingEnabled(boolean globalAccessLoggingEnabled) {
        String enabled = this.vsBean.getAccessLoggingEnabled();
        return "inherit".equals(enabled) && globalAccessLoggingEnabled || ConfigBeansUtilities.toBoolean((String)enabled);
    }

    public void setRealm(Realm realm) {
        if (realm != null && !(realm instanceof RealmAdapter)) {
            this._logger.log(Level.SEVERE, "vs.ignoreInvalidRealm", new Object[]{realm.getClass().getName(), RealmAdapter.class.getName()});
        } else {
            super.setRealm(realm);
        }
    }

    private void configureSingleSignOnCookieSecure() {
        String cookieSecure = this.vsBean.getSsoCookieSecure();
        if (!("true".equalsIgnoreCase(cookieSecure) || "false".equalsIgnoreCase(cookieSecure) || cookieSecure.equalsIgnoreCase("dynamic"))) {
            this._logger.log(Level.WARNING, "vs.invalidSsoCookieSecure", new Object[]{cookieSecure, this.getID()});
        } else {
            this.ssoCookieSecure = cookieSecure;
        }
    }

    private void configureSingleSignOnCookieHttpOnly() {
        this.ssoCookieHttpOnly = Boolean.parseBoolean(this.vsBean.getSsoCookieHttpOnly());
    }

    void configureErrorReportValve() {
        Property prop = this.vsBean.getProperty("errorReportValve");
        if (prop != null) {
            this.setErrorReportValveClass(prop.getValue());
        }
    }

    void setServerContext(ServerContext serverContext) {
        this.serverContext = serverContext;
    }

    void setServerConfig(Config serverConfig) {
        this.serverConfig = serverConfig;
    }

    void setGrizzlyService(GrizzlyService grizzlyService) {
        this.grizzlyService = grizzlyService;
    }

    void setWebContainer(WebContainer webContainer) {
        this.webContainer = webContainer;
    }

    public void setDocRoot(File docRoot) {
        this.setAppBase(docRoot.getPath());
    }

    public File getDocRoot() {
        return new File(this.getAppBase());
    }

    public void setWebListeners(WebListener ... webListeners) {
        if (webListeners != null) {
            this.listeners = Arrays.asList(webListeners);
        }
    }

    public Collection<WebListener> getWebListeners() {
        return this.listeners;
    }

    public void addContext(Context context, String contextRoot) throws ConfigException, GlassFishException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Virtual server " + this.getName() + " adding context " + contextRoot);
        }
        if (!(context instanceof ContextFacade)) {
            return;
        }
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        ExtendedDeploymentContext deploymentContext = null;
        try {
            WebModule wm;
            ArchiveHandler archiveHandler;
            if (this.factory == null) {
                this.factory = (ArchiveFactory)this.habitat.getComponent(ArchiveFactory.class);
            }
            ContextFacade facade = (ContextFacade)context;
            File docRoot = facade.getDocRoot();
            ClassLoader classLoader = facade.getClassLoader();
            ReadableArchive archive = this.factory.openArchive(docRoot);
            if (this.report == null) {
                this.report = new PlainTextActionReporter();
            }
            ServerEnvironment env = (ServerEnvironment)this.habitat.getComponent(ServerEnvironment.class);
            DeployCommandParameters params = new DeployCommandParameters();
            params.contextroot = contextRoot;
            params.enabled = Boolean.FALSE;
            params.origin = OpsParams.Origin.deploy;
            params.target = "server";
            params.virtualservers = this.getName();
            DeploymentContextImpl initialContext = new DeploymentContextImpl(this.report, this._logger, archive, (OpsParams)params, env);
            if (this.deployment == null) {
                this.deployment = (Deployment)this.habitat.getComponent(Deployment.class);
            }
            if ((archiveHandler = this.deployment.getArchiveHandler(archive)) == null) {
                throw new RuntimeException("Cannot find archive handler for source archive");
            }
            params.name = archiveHandler.getDefaultApplicationName(archive, (DeploymentContext)initialContext);
            Applications apps = this.domain.getApplications();
            ApplicationInfo appInfo = this.deployment.get(params.name);
            ApplicationRef appRef = this.domain.getApplicationRefInServer(params.target, params.name);
            if (appInfo != null) {
                if (appRef != null && appRef.getVirtualServers().contains(this.getName())) {
                    throw new ConfigException("Context with name " + params.name + " is already registered on virtual server " + this.getName());
                }
                String virtualServers = appRef.getVirtualServers();
                params.virtualservers = virtualServers = virtualServers + "," + this.getName();
                params.force = Boolean.TRUE;
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "Virtual server " + this.getName() + " added to context " + params.name);
                }
                return;
            }
            deploymentContext = this.deployment.getBuilder(this._logger, (OpsParams)params, this.report).source(archive).archiveHandler(archiveHandler).build((ExtendedDeploymentContext)initialContext);
            Properties properties = new Properties();
            deploymentContext.getAppProps().putAll((Map<?, ?>)properties);
            if (classLoader != null) {
                ClassLoader parentCL = this.clh.createApplicationParentCL(classLoader, (DeploymentContext)deploymentContext);
                ClassLoader cl = archiveHandler.getClassLoader(parentCL, (DeploymentContext)deploymentContext);
                deploymentContext.setClassLoader(cl);
            }
            ApplicationConfigInfo savedAppConfig = new ApplicationConfigInfo((com.sun.enterprise.config.serverbeans.Application)apps.getModule(com.sun.enterprise.config.serverbeans.Application.class, params.name));
            Properties appProps = deploymentContext.getAppProps();
            String appLocation = DeploymentUtils.relativizeWithinDomainIfPossible((URI)deploymentContext.getSource().getURI());
            appProps.setProperty("location", appLocation);
            appProps.setProperty("object-type", "user");
            appProps.setProperty("context-root", contextRoot);
            savedAppConfig.store(appProps);
            Transaction t = this.deployment.prepareAppConfigChanges((DeploymentContext)deploymentContext);
            appInfo = this.deployment.deploy(deploymentContext);
            if (appInfo != null) {
                facade.setAppName(appInfo.getName());
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "Virtual server " + this.getName() + " added context " + appInfo.getName());
                }
                this.deployment.registerAppInDomainXML(appInfo, (DeploymentContext)deploymentContext, t);
            } else if (this.report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                throw new ConfigException(this.report.getMessage());
            }
            File file = null;
            boolean delete = true;
            com.sun.enterprise.config.serverbeans.Application appBean = apps.getApplication(params.name);
            if (appBean != null) {
                file = new File(deploymentContext.getSource().getURI().getPath(), "/WEB-INF/web.xml");
                if (file.exists()) {
                    delete = false;
                }
                this.updateWebXml(facade, file);
            } else {
                this._logger.log(Level.SEVERE, "Application " + params.name + " not found");
            }
            ReadableArchive source = appInfo.getSource();
            UndeployCommandParameters undeployParams = new UndeployCommandParameters(params.name);
            undeployParams.origin = OpsParams.Origin.undeploy;
            undeployParams.target = "server";
            ExtendedDeploymentContext undeploymentContext = this.deployment.getBuilder(this._logger, (OpsParams)undeployParams, this.report).source(source).build();
            this.deployment.undeploy(params.name, undeploymentContext);
            params.origin = OpsParams.Origin.load;
            params.enabled = Boolean.TRUE;
            archive = this.factory.openArchive(docRoot);
            deploymentContext = this.deployment.getBuilder(this._logger, (OpsParams)params, this.report).source(archive).build();
            if (classLoader != null) {
                ClassLoader parentCL = this.clh.createApplicationParentCL(classLoader, (DeploymentContext)deploymentContext);
                archiveHandler = this.deployment.getArchiveHandler(archive);
                ClassLoader cl = archiveHandler.getClassLoader(parentCL, (DeploymentContext)deploymentContext);
                deploymentContext.setClassLoader(cl);
            }
            this.deployment.deploy(deploymentContext);
            this.deployment.updateAppEnabledAttributeInDomainXML(params.name, params.target, true);
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Virtual server " + this.getName() + " enabled context " + params.name());
            }
            if (delete && file != null && file.exists() && !file.delete()) {
                String path = file.toString();
                this._logger.log(Level.WARNING, "webcontainer.unableToDelete", path);
            }
            if (contextRoot.equals("/")) {
                contextRoot = "";
            }
            if ((wm = (WebModule)this.findChild(contextRoot)) != null) {
                facade.setUnwrappedContext(wm);
                wm.setEmbedded(true);
                if (this.config != null) {
                    wm.setDefaultWebXml(this.config.getDefaultWebXml());
                }
            } else {
                throw new ConfigException("Deployed app not found " + contextRoot);
            }
            if (deploymentContext != null) {
                deploymentContext.postDeployClean(true);
            }
        }
        catch (Exception ex) {
            if (this.deployment != null && deploymentContext != null) {
                deploymentContext.clean();
            }
            throw new GlassFishException((Throwable)ex);
        }
    }

    public void removeContext(Context context) throws GlassFishException {
        String name;
        ActionReport report = (ActionReport)this.habitat.getComponent(ActionReport.class, "plain");
        Deployment deployment = (Deployment)this.habitat.getComponent(Deployment.class);
        ApplicationInfo appInfo = deployment.get(name = ((ContextFacade)context).getAppName());
        if (appInfo == null) {
            report.setMessage("Cannot find deployed application of name " + name);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            throw new GlassFishException("Cannot find deployed application of name " + name);
        }
        ReadableArchive source = appInfo.getSource();
        if (source == null) {
            report.setMessage("Cannot get source archive for undeployment");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            throw new GlassFishException("Cannot get source archive for undeployment");
        }
        UndeployCommandParameters params = new UndeployCommandParameters(name);
        params.origin = OpsParams.Origin.undeploy;
        params.target = "server";
        ExtendedDeploymentContext deploymentContext = null;
        try {
            deploymentContext = deployment.getBuilder(this._logger, (OpsParams)params, report).source(source).build();
            deployment.undeploy(name, deploymentContext);
            deployment.unregisterAppFromDomainXML(name, "server");
        }
        catch (IOException e) {
            this._logger.log(Level.SEVERE, "Cannot create context for undeployment ", e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            throw new GlassFishException("Cannot create context for undeployment ", (Throwable)e);
        }
        catch (TransactionFailure e) {
            throw new GlassFishException((Throwable)e);
        }
        finally {
            deploymentContext.clean();
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Successfully removed context " + name);
        }
    }

    public Context getContext(String contextRoot) {
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        return (Context)this.findChild(contextRoot);
    }

    public Collection<Context> getContexts() {
        ArrayList<Context> ctxs = new ArrayList<Context>();
        for (Container container : this.findChildren()) {
            if (!(container instanceof Context)) continue;
            ctxs.add((Context)container);
        }
        return ctxs;
    }

    public void setConfig(VirtualServerConfig config) throws ConfigException {
        this.config = config;
        this.configureSingleSignOn(config.isSsoEnabled(), (WebContainerFeatureFactory)this.habitat.getComponent(PEWebContainerFeatureFactoryImpl.class), false);
        if (config.isAccessLoggingEnabled()) {
            this.enableAccessLogging();
        } else {
            this.disableAccessLogging();
        }
        this.setDefaultWebXmlLocation(config.getDefaultWebXml());
        this.setDefaultContextXmlLocation(config.getContextXmlDefault());
        this.setAllowLinking(config.isAllowLinking());
        this.configureRemoteAddressFilterValve(config.getAllowRemoteAddress(), config.getDenyRemoteAddress());
        this.configureRemoteHostFilterValve(config.getAllowRemoteHost(), config.getAllowRemoteHost());
        this.configureAliases(config.getHostNames());
    }

    public VirtualServerConfig getConfig() {
        return this.config;
    }

    public synchronized void stop() throws LifecycleException {
        if (this.fileLoggerHandler != null) {
            this._logger.removeHandler(this.fileLoggerHandler);
            this.close(this.fileLoggerHandler);
            this.fileLoggerHandler = null;
        }
        this.setLogger(DEFAULT_LOGGER, "INFO");
        super.stop();
    }

    public void updateWebXml(ContextFacade facade, File file) throws Exception {
        Map<String, String> servlets = facade.getAddedServlets();
        Map<String, String[]> mappings = facade.getServletMappings();
        List<String> listeners = facade.getListeners();
        Map<String, String> filters = facade.getAddedFilters();
        Map<String, String> servletNameFilterMappings = facade.getServletNameFilterMappings();
        Map<String, String> urlPatternFilterMappings = facade.getUrlPatternFilterMappings();
        if (!(filters.isEmpty() && listeners.isEmpty() && servlets.isEmpty())) {
            Node servletNode;
            NodeList servletList;
            Element servletName;
            Element filterMapping;
            Element paramValue;
            Element paramName;
            Element initParam;
            NodeList children;
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Modifying web.xml " + file.getAbsolutePath());
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = null;
            Element webapp = null;
            if (file != null && file.exists()) {
                doc = dBuilder.parse(file);
                webapp = doc.getDocumentElement();
            } else {
                doc = dBuilder.newDocument();
                webapp = doc.createElement("web-app");
                webapp.setAttribute("xmln", "http://java.sun.com/xml/ns/javaee");
                webapp.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                webapp.setAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd");
                webapp.setAttribute("version", "3.0");
                doc.appendChild(webapp);
            }
            boolean entryFound = false;
            for (Map.Entry<String, String> entry : filters.entrySet()) {
                NodeList filterList = doc.getElementsByTagName("filter-name");
                block1: for (int i = 0; i < filterList.getLength(); ++i) {
                    Node filterNode = filterList.item(i);
                    if (!entry.getKey().equals(filterNode.getTextContent()) || !filterNode.getParentNode().getNodeName().equals("filter")) continue;
                    children = filterNode.getParentNode().getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node filterClass = children.item(j);
                        if (!filterClass.getNodeName().equals("filter-class")) continue;
                        filterClass.setTextContent(entry.getValue().toString());
                        entryFound = true;
                        continue block1;
                    }
                }
                if (entryFound) continue;
                Element filter = doc.createElement("filter");
                Element filterName = doc.createElement("filter-name");
                filterName.setTextContent(entry.getKey().toString());
                filter.appendChild(filterName);
                Element filterClass = doc.createElement("filter-class");
                filterClass.setTextContent(entry.getValue().toString());
                filter.appendChild(filterClass);
                Map initParams = facade.getFilterRegistration(entry.getKey().toString()).getInitParameters();
                if (initParams != null && !initParams.isEmpty()) {
                    initParam = doc.createElement("init-param");
                    for (Map.Entry param : initParams.entrySet()) {
                        paramName = doc.createElement("param-name");
                        paramName.setTextContent(param.getKey().toString());
                        initParam.appendChild(paramName);
                        paramValue = doc.createElement("param-value");
                        paramValue.setTextContent(param.getValue().toString());
                        initParam.appendChild(paramValue);
                    }
                    filter.appendChild(initParam);
                }
                webapp.appendChild(filter);
            }
            for (Map.Entry<String, String> entry : servletNameFilterMappings.entrySet()) {
                filterMapping = doc.createElement("filter-mapping");
                Element filterName = doc.createElement("filter-name");
                filterName.setTextContent(entry.getKey().toString());
                filterMapping.appendChild(filterName);
                servletName = doc.createElement("servlet-name");
                servletName.setTextContent(entry.getValue().toString());
                filterMapping.appendChild(servletName);
                webapp.appendChild(filterMapping);
            }
            for (Map.Entry<String, String> entry : urlPatternFilterMappings.entrySet()) {
                filterMapping = doc.createElement("filter-mapping");
                Element filterName = doc.createElement("filter-name");
                filterName.setTextContent(entry.getKey().toString());
                filterMapping.appendChild(filterName);
                Element urlPattern = doc.createElement("url-pattern");
                urlPattern.setTextContent(entry.getValue().toString());
                filterMapping.appendChild(urlPattern);
                webapp.appendChild(filterMapping);
            }
            entryFound = false;
            for (Map.Entry<String, String> entry : servlets.entrySet()) {
                servletList = doc.getElementsByTagName("servlet-name");
                block7: for (int i = 0; i < servletList.getLength(); ++i) {
                    servletNode = servletList.item(i);
                    if (!entry.getKey().equals(servletNode.getTextContent()) || !servletNode.getParentNode().getNodeName().equals("servlet")) continue;
                    children = servletNode.getParentNode().getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node servletClass = children.item(j);
                        if (!servletClass.getNodeName().equals("servlet-class")) continue;
                        servletClass.setTextContent(entry.getValue().toString());
                        entryFound = true;
                        continue block7;
                    }
                }
                if (entryFound) continue;
                Element servlet = doc.createElement("servlet");
                servletName = doc.createElement("servlet-name");
                servletName.setTextContent(entry.getKey().toString());
                servlet.appendChild(servletName);
                Element servletClass = doc.createElement("servlet-class");
                servletClass.setTextContent(entry.getValue().toString());
                servlet.appendChild(servletClass);
                Map initParams = facade.getServletRegistration(entry.getKey().toString()).getInitParameters();
                if (initParams != null && !initParams.isEmpty()) {
                    initParam = doc.createElement("init-param");
                    for (Map.Entry param : initParams.entrySet()) {
                        paramName = doc.createElement("param-name");
                        paramName.setTextContent(param.getKey().toString());
                        initParam.appendChild(paramName);
                        paramValue = doc.createElement("param-value");
                        paramValue.setTextContent(param.getValue().toString());
                        initParam.appendChild(paramValue);
                    }
                    servlet.appendChild(initParam);
                }
                webapp.appendChild(servlet);
            }
            entryFound = false;
            for (Map.Entry<String, String> entry : mappings.entrySet()) {
                servletList = doc.getElementsByTagName("servlet-name");
                block11: for (int i = 0; i < servletList.getLength(); ++i) {
                    servletNode = servletList.item(i);
                    if (!entry.getKey().equals(servletNode.getTextContent()) || !servletNode.getParentNode().getNodeName().equals("servlet-mapping")) continue;
                    NodeList children2 = servletNode.getParentNode().getChildNodes();
                    for (int j = 0; j < children2.getLength(); ++j) {
                        Node urlPattern = children2.item(j);
                        if (!urlPattern.getNodeName().equals("url-pattern")) continue;
                        entryFound = true;
                        continue block11;
                    }
                }
                if (entryFound) continue;
                Element servletMapping = doc.createElement("servlet-mapping");
                for (String pattern : mappings.get(entry.getKey())) {
                    Element servletName2 = doc.createElement("servlet-name");
                    servletName2.setTextContent(entry.getKey().toString());
                    servletMapping.appendChild(servletName2);
                    Element urlPattern = doc.createElement("url-pattern");
                    urlPattern.setTextContent(pattern);
                    servletMapping.appendChild(urlPattern);
                }
                webapp.appendChild(servletMapping);
            }
            for (String string : listeners) {
                Element listener = doc.createElement("listener");
                Element listenerClass = doc.createElement("listener-class");
                listenerClass.setTextContent(string);
                listener.appendChild(listenerClass);
                webapp.appendChild(listener);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource dOMSource = new DOMSource(doc);
            StreamResult result = new StreamResult(file);
            transformer.transform(dOMSource, result);
        }
    }
}

