/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven.plugin;

import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.glassfish.maven.plugin.Auth;
import org.glassfish.maven.plugin.ConnectionFactory;
import org.glassfish.maven.plugin.Domain;
import org.glassfish.maven.plugin.GlassfishMojo;
import org.glassfish.maven.plugin.JdbcDataSource;
import org.glassfish.maven.plugin.JmsDestination;
import org.glassfish.maven.plugin.MessageSecurityProvider;
import org.glassfish.maven.plugin.Property;
import org.glassfish.maven.plugin.Realm;
import org.glassfish.maven.plugin.Resource;
import org.glassfish.maven.plugin.command.AddResourcesCommand;
import org.glassfish.maven.plugin.command.CreateAuthRealmCommand;
import org.glassfish.maven.plugin.command.CreateDomainCommand;
import org.glassfish.maven.plugin.command.CreateJDBCConnectionPoolCommand;
import org.glassfish.maven.plugin.command.CreateJDBCResourceCommand;
import org.glassfish.maven.plugin.command.CreateJMSDestinationCommand;
import org.glassfish.maven.plugin.command.CreateJMSResourceCommand;
import org.glassfish.maven.plugin.command.CreateJVMOptionsCommand;
import org.glassfish.maven.plugin.command.CreateMessageSecurityProviderCommand;
import org.glassfish.maven.plugin.command.SetCommand;
import org.glassfish.maven.plugin.command.StartDomainCommand;
import org.glassfish.maven.plugin.command.StopDomainCommand;

public class CreateDomainMacro {
    private GlassfishMojo sharedContext;
    private Domain domain;

    public CreateDomainMacro(GlassfishMojo sharedContext, Domain domain) {
        this.sharedContext = sharedContext;
        this.domain = domain;
    }

    public void execute(ProcessBuilder processBuilder) throws MojoExecutionException, MojoFailureException {
        new CreateDomainCommand(this.sharedContext, this.domain).execute(processBuilder);
        new StartDomainCommand(this.sharedContext, this.domain).execute(processBuilder);
        this.createJVMOptions(processBuilder);
        this.addResources(processBuilder);
        this.setProperties(processBuilder);
        this.createAuth(processBuilder);
        new StopDomainCommand(this.sharedContext, this.domain).execute(processBuilder);
    }

    private void createJVMOptions(ProcessBuilder processBuilder) throws MojoExecutionException, MojoFailureException {
        if (this.domain.getJVMOptions() != null) {
            new CreateJVMOptionsCommand(this.sharedContext, this.domain).execute(processBuilder);
        }
    }

    private void setProperties(ProcessBuilder processBuilder) throws MojoExecutionException, MojoFailureException {
        if (this.domain.getProperties() != null) {
            for (Property property : this.domain.getProperties()) {
                new SetCommand(this.sharedContext, this.domain, property).execute(processBuilder);
            }
        }
    }

    private void addResources(ProcessBuilder processBuilder) throws MojoExecutionException, MojoFailureException {
        Set<Resource> resources;
        if (this.domain.getResourceDescriptor() != null) {
            new AddResourcesCommand(this.sharedContext, this.domain).execute(processBuilder);
        }
        if ((resources = this.domain.getResources()) != null) {
            for (Resource resource : resources) {
                if (resource instanceof JmsDestination) {
                    this.createJMSDestination(processBuilder, (JmsDestination)resource);
                    continue;
                }
                if (resource instanceof ConnectionFactory) {
                    new CreateJMSResourceCommand(this.sharedContext, this.domain, (ConnectionFactory)resource).execute(processBuilder);
                    continue;
                }
                if (!(resource instanceof JdbcDataSource)) continue;
                this.createDataSource(processBuilder, (JdbcDataSource)resource);
            }
        }
    }

    private void createDataSource(ProcessBuilder processBuilder, JdbcDataSource jdbcDataSource) throws MojoExecutionException, MojoFailureException {
        new CreateJDBCConnectionPoolCommand(this.sharedContext, this.domain, jdbcDataSource).execute(processBuilder);
        new CreateJDBCResourceCommand(this.sharedContext, this.domain, jdbcDataSource).execute(processBuilder);
    }

    private void createJMSDestination(ProcessBuilder processBuilder, JmsDestination jmsDestination) throws MojoExecutionException, MojoFailureException {
        new CreateJMSResourceCommand(this.sharedContext, this.domain, jmsDestination.getConnectionFactory()).execute(processBuilder);
        new CreateJMSDestinationCommand(this.sharedContext, this.domain, jmsDestination.getDestination()).execute(processBuilder);
        new CreateJMSResourceCommand(this.sharedContext, this.domain, jmsDestination).execute(processBuilder);
    }

    private void createAuth(ProcessBuilder processBuilder) throws MojoExecutionException, MojoFailureException {
        Auth auth = this.domain.getAuth();
        if (auth != null) {
            this.createAuthRealm(processBuilder, auth);
            this.setMessageSecurityProvider(processBuilder, auth);
        }
    }

    private void createAuthRealm(ProcessBuilder processBuilder, Auth auth) throws MojoExecutionException, MojoFailureException {
        Realm realm = auth.getRealm();
        if (realm != null) {
            new CreateAuthRealmCommand(this.sharedContext, this.domain, realm).execute(processBuilder);
            Property property = new Property("server.security-service.default-realm", realm.getName());
            new SetCommand(this.sharedContext, this.domain, property).execute(processBuilder);
        }
    }

    private void setMessageSecurityProvider(ProcessBuilder processBuilder, Auth auth) throws MojoExecutionException, MojoFailureException {
        MessageSecurityProvider securityProvider = auth.getMessageSecurityProvider();
        if (securityProvider != null) {
            new CreateMessageSecurityProviderCommand(this.sharedContext, this.domain, securityProvider).execute(processBuilder);
        }
    }
}

