/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven.plugin;

import au.net.ocean.maven.plugin.annotation.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.glassfish.maven.plugin.CreateDomainMacro;
import org.glassfish.maven.plugin.GlassfishMojo;
import org.glassfish.maven.plugin.command.DeleteDomainCommand;
import org.glassfish.maven.plugin.command.StopDomainCommand;

@Mojo(goal="create-virtual-server", description="Create a new virtual server in a local or remote Glassfish instance", requiresProject=true)
public class CreateVirtualServerMojo
extends GlassfishMojo {
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        Log log = this.getLog();
        if (this.domain.exists()) {
            log.info((CharSequence)("Domain " + this.domain.getName() + " exists."));
            if (this.domain.isReuse()) {
                log.info((CharSequence)"Reusing it.");
                return;
            }
            log.info((CharSequence)"Deleting it.");
            if (this.domain.isStarted()) {
                new StopDomainCommand(this, this.domain).execute(processBuilder);
            }
            new DeleteDomainCommand(this, this.domain).execute(processBuilder);
        }
        new CreateDomainMacro(this, this.domain).execute(processBuilder);
    }
}

