/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven.plugin;

import au.net.ocean.maven.plugin.annotation.Parameter;
import au.net.ocean.maven.plugin.annotation.Required;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.Set;
import org.glassfish.maven.plugin.Auth;
import org.glassfish.maven.plugin.Property;
import org.glassfish.maven.plugin.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain {
    @Parameter(defaultValue="localhost", description="The target host")
    private String host = "localhost";
    @Parameter(expression="${domainDirectory}", description="The directory in which this domain should be created (if other than the Glassfish default).\nOverrides the value of domainDirectory in global configuration.\nThis value is ignored if the host is other than localhost.")
    private File directory;
    @Parameter(expression="${project.artifactId}")
    private String name;
    @Parameter(expression="${domainDirectory}/${name}/log")
    private File logDirectory;
    @Required
    @Parameter
    private int adminPort;
    @Parameter
    private int httpPort;
    @Parameter
    private int httpsPort;
    @Parameter
    private int iiopPort;
    @Parameter
    private int iiopsPort;
    @Parameter
    private int iiopsmPort;
    @Parameter
    private int jmsPort;
    @Parameter(defaultValue="false")
    private boolean reuse;
    @Parameter
    private Set<String> jvmOptions;
    @Parameter
    private Set<Property> properties;
    private Auth auth;
    @Parameter(defaultValue="developer")
    private String profile = "developer";
    @Parameter
    private String resourceDescriptor;
    @Parameter
    private Set<Resource> resources;
    @Parameter(description="The admin password to use for this domain.")
    private String adminPassword;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public void setLogDirectory(File logDirectory) {
        this.logDirectory = logDirectory;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public void setAdminPort(int adminPort) {
        this.adminPort = adminPort;
    }

    public int getHTTPPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getHTTPSPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public int getIIOPPort() {
        return this.iiopPort;
    }

    public void setIiopPort(int iiopPort) {
        this.iiopPort = iiopPort;
    }

    public int getIiopsPort() {
        return this.iiopsPort;
    }

    public void setIiopsPort(int iiopsPort) {
        this.iiopsPort = iiopsPort;
    }

    public int getIiopsmPort() {
        return this.iiopsmPort;
    }

    public void setIiopsmPort(int iiopsmPort) {
        this.iiopsmPort = iiopsmPort;
    }

    public int getJMSPort() {
        return this.jmsPort;
    }

    public void setJmsPort(int jmsPort) {
        this.jmsPort = jmsPort;
    }

    public boolean isReuse() {
        return this.reuse;
    }

    public void setReuse(boolean reuse) {
        this.reuse = reuse;
    }

    public Set<String> getJVMOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(Set<String> jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(Set<Property> properties) {
        this.properties = properties;
    }

    public Auth getAuth() {
        return this.auth;
    }

    public void setAuth(Auth auth) {
        this.auth = auth;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getResourceDescriptor() {
        return this.resourceDescriptor;
    }

    public void setResourceDescriptor(String resourceDescriptor) {
        this.resourceDescriptor = resourceDescriptor;
    }

    public Set<Resource> getResources() {
        return this.resources;
    }

    public void setResources(Set<Resource> resources) {
        this.resources = resources;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public boolean exists() {
        return "localhost".equals(this.host) ? this.directory.exists() && Arrays.asList(this.directory.list()).contains(this.name) : false;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean isStarted() {
        try {
            Socket socket = new Socket(this.host, this.adminPort);
            socket.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }
}

