/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven.plugin;

import au.net.ocean.maven.plugin.MojoConfigurationException;
import au.net.ocean.maven.plugin.OceanMojo;
import au.net.ocean.maven.plugin.annotation.Parameter;
import au.net.ocean.maven.plugin.annotation.Required;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.glassfish.maven.plugin.Domain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GlassfishMojo
extends OceanMojo {
    @Parameter(description="The directory into which domains are deployed. Default value is ${glassfishDirectory}/domains.")
    protected File domainDirectory;
    @Required
    @Parameter(description="Container for domain configuration parameters.")
    protected Domain domain;
    @Required
    @Parameter(description="The root directory of the Glassfish installation to be used", expression="${glassfish.home}")
    private File glassfishDirectory;
    @Parameter(description="Debug Glassfish output", defaultValue="false")
    private boolean debug;
    @Parameter(description="Echo Glassfish asadmin commands", defaultValue="false")
    private boolean echo;
    @Parameter(description="Terse Glassfish output", defaultValue="true")
    private boolean terse = true;
    @Parameter(description="Skip execution", defaultValue="false")
    private boolean skip;
    @Parameter(description="Automatically create the domain if it does not already exist", defaultValue="true")
    private boolean autoCreate;
    @Parameter(description="The asadmin user to create for domain administration.", expression="${glassfish.adminUser}", defaultValue="${user.name}")
    private String user;
    @Parameter(description="Location of the asadmin style password file (if you do not want to provide the password in your POM)")
    private String passwordFile;
    @Parameter(description="The admin password to use for this domain (if you would rather not use an asadmin style password file)", expression="${glassfish.adminPassword}")
    private String adminPassword;

    protected String getPrefix() {
        return "glassfish";
    }

    public File getGlassfishDirectory() {
        return this.glassfishDirectory;
    }

    public void setGlassfishDirectory(File glassfishDirectory) {
        this.glassfishDirectory = glassfishDirectory;
    }

    public File getDomainDirectory() {
        return this.domainDirectory;
    }

    public void setDomainDirectory(File domainDirectory) {
        this.domainDirectory = domainDirectory;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isEcho() {
        return this.echo;
    }

    public void setEcho(boolean echo) {
        this.echo = echo;
    }

    public boolean isTerse() {
        return this.terse;
    }

    public void setTerse(boolean terse) {
        this.terse = terse;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }

    protected void postConfig() throws MojoConfigurationException {
        List<String> configErrors = this.getConfigErrors();
        if (!configErrors.isEmpty()) {
            throw new MojoConfigurationException((OceanMojo)this, configErrors);
        }
        if (this.adminPassword != null && this.adminPassword.length() > 0) {
            try {
                File tmpPassFile = File.createTempFile("mgfp", null);
                tmpPassFile.deleteOnExit();
                this.passwordFile = tmpPassFile.getAbsolutePath();
                PrintWriter fileWriter = new PrintWriter(new FileWriter(tmpPassFile));
                fileWriter.println("AS_ADMIN_PASSWORD=" + this.adminPassword);
                fileWriter.println("AS_ADMIN_USERPASSWORD=" + this.adminPassword);
                fileWriter.println("AS_ADMIN_ADMINPASSWORD=" + this.adminPassword);
                fileWriter.println("AS_ADMIN_MASTERPASSWORD=" + this.adminPassword);
                fileWriter.close();
            }
            catch (IOException e) {
                throw new MojoConfigurationException((OceanMojo)this, Arrays.asList("Unable to create temporary asadmin password file in " + System.getProperty("java.io.tmpdir")));
            }
        }
        if (this.domainDirectory == null) {
            this.domainDirectory = new File(this.glassfishDirectory, "domains");
        }
        if (this.domain.getDirectory() == null) {
            this.domain.setDirectory(this.domainDirectory);
        }
    }

    protected List<String> getConfigErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.adminPassword == null && this.passwordFile == null) {
            StringBuilder error = new StringBuilder().append("inside the definition for plugin: 'maven-glassfish-plugin' specify the following:\n\n").append("<configuration>\n").append("  ...\n").append("  <passwordFile>VALUE</passwordFile>\n").append("  ...\n").append("   OR\n").append("  ...\n").append("  <adminPassword>VALUE</adminPassword>\n").append("  ...\n").append("</configuration>\n");
            errors.add(error.toString());
        }
        return errors;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }
}

