/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven.plugin;

import au.net.ocean.maven.plugin.annotation.Parameter;
import au.net.ocean.maven.plugin.annotation.Required;
import java.util.Set;
import org.glassfish.maven.plugin.Property;
import org.glassfish.maven.plugin.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDataSource
implements Resource {
    private static final int DEFAULT_MAX_POOL_SIZE = 50;
    private static final int DEFAULT_STEADY_POOL_SIZE = 5;
    private static final int DEFAULT_IDLE_TIMEOUT = 300;
    private static final int DEFAULT_MAX_WAIT = 60000;
    private static final int DEFAULT_POOL_RESIZE = 2;
    @Required
    @Parameter
    private String poolName;
    @Required
    @Parameter
    private String className;
    @Required
    @Parameter
    private String name;
    @Required
    @Parameter
    private String description;
    @Required
    @Parameter(property="type")
    private Resource.Type _type;
    @Parameter(defaultValue="true")
    private boolean allowNonComponentCallers = true;
    @Parameter(defaultValue="false")
    private boolean failConnection;
    @Parameter(defaultValue="false")
    private boolean validateConnections;
    @Parameter(defaultValue="false")
    private boolean isolationGuaranteed;
    @Parameter(defaultValue="false")
    private boolean nonTransactionalConnections;
    @Parameter(property="validationMethod", defaultValue="auto-commit")
    private ValidationMethod validationMethod = ValidationMethod.autoCommit;
    @Parameter(defaultValue="2")
    private int poolResize = 2;
    @Parameter(defaultValue="50")
    private int maxPoolSize = 50;
    @Parameter(defaultValue="5")
    private int steadyPoolSize = 5;
    @Parameter(defaultValue="300")
    private int idleTimeout = 300;
    @Parameter(defaultValue="60000")
    private int maxWait = 60000;
    @Parameter
    private Set<Property> properties;

    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isAllowNonComponentCallers() {
        return this.allowNonComponentCallers;
    }

    public void setAllowNonComponentCallers(boolean allowNonComponentCallers) {
        this.allowNonComponentCallers = allowNonComponentCallers;
    }

    public boolean isFailConnection() {
        return this.failConnection;
    }

    public void setFailConnection(boolean failConnection) {
        this.failConnection = failConnection;
    }

    public boolean isValidateConnections() {
        return this.validateConnections;
    }

    public void setValidateConnections(boolean validateConnections) {
        this.validateConnections = validateConnections;
    }

    public boolean isIsolationGuaranteed() {
        return this.isolationGuaranteed;
    }

    public void setIsolationGuaranteed(boolean isolationGuaranteed) {
        this.isolationGuaranteed = isolationGuaranteed;
    }

    public boolean isNonTransactionalConnections() {
        return this.nonTransactionalConnections;
    }

    public void setNonTransactionalConnections(boolean nonTransactionalConnections) {
        this.nonTransactionalConnections = nonTransactionalConnections;
    }

    public String getValidationMethod() {
        return this.validationMethod.toString();
    }

    public void setValidationMethod(String validationMethod) {
        this.validationMethod = ValidationMethod.valueOf(validationMethod);
    }

    public int getPoolResize() {
        return this.poolResize;
    }

    public void setPoolResize(int poolResize) {
        this.poolResize = poolResize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getSteadyPoolSize() {
        return this.steadyPoolSize;
    }

    public void setSteadyPoolSize(int steadyPoolSize) {
        this.steadyPoolSize = steadyPoolSize;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }

    @Override
    public Set<Property> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Set<Property> properties) {
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Resource.Type getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = Resource.Type.valueOf(type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValidationMethod {
        autoCommit("auto-commit"),
        metaData("meta-data"),
        table("table");

        private String realName;

        private ValidationMethod(String realName) {
            this.realName = realName;
        }

        public String toString() {
            return this.realName;
        }

        public static ValidationMethod forName(String realName) {
            for (ValidationMethod method : ValidationMethod.values()) {
                if (!method.realName.equalsIgnoreCase(realName)) continue;
                return method;
            }
            throw new IllegalArgumentException("No ValidationMethod exists with name \"" + realName + "\"");
        }
    }
}

