/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.glassfish.maven.plugin.CreateDomainMacro;
import org.glassfish.maven.plugin.Domain;
import org.glassfish.maven.plugin.GlassfishMojo;
import org.glassfish.maven.plugin.command.StartDomainCommand;

public class StartDomainMacro {
    private GlassfishMojo sharedContext;
    private Domain domain;

    public StartDomainMacro(GlassfishMojo sharedContext, Domain domain) {
        this.sharedContext = sharedContext;
        this.domain = domain;
    }

    public void execute(ProcessBuilder processBuilder) throws MojoFailureException, MojoExecutionException {
        if (!this.domain.exists()) {
            Log log = this.sharedContext.getLog();
            if (this.sharedContext.isAutoCreate()) {
                log.info((CharSequence)("Domain " + this.domain.getName() + " does not exist. Creating it for you."));
                new CreateDomainMacro(this.sharedContext, this.domain).execute(processBuilder);
            } else {
                throw new MojoFailureException("Domain " + this.domain.getName() + " does not exist and \"autoCreate\" is \"false\". Try 'mvn glassfish:createDomain' first.");
            }
        }
        new StartDomainCommand(this.sharedContext, this.domain).execute(processBuilder);
    }
}

