/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven.plugin;

import au.net.ocean.maven.plugin.annotation.Mojo;
import au.net.ocean.maven.plugin.annotation.Phase;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.glassfish.maven.plugin.Component;
import org.glassfish.maven.plugin.DeploymentGlassfishMojo;
import org.glassfish.maven.plugin.command.StartDomainCommand;
import org.glassfish.maven.plugin.command.StopDomainCommand;
import org.glassfish.maven.plugin.command.UndeployCommand;

@Mojo(goal="undeploy", description="Undeploy JavaEE components which are currently deployed to a domain in a local or remote Glassfish instance", phase=Phase.PostIntegrationTest, requiresProject=true)
public class UndeployGlassfishMojo
extends DeploymentGlassfishMojo {
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (this.domain.exists()) {
            boolean started = this.domain.isStarted();
            if (!started) {
                this.getLog().info((CharSequence)("Domain " + this.domain.getName() + " isn't started. Starting it for you."));
                new StartDomainCommand(this, this.domain).execute(processBuilder);
            }
            for (Component component : this.getComponents()) {
                new UndeployCommand(this, this.domain, component).execute(processBuilder);
            }
            if (!started) {
                new StopDomainCommand(this, this.domain).execute(processBuilder);
            }
        } else {
            throw new MojoFailureException("Domain " + this.domain.getName() + " does not exist.");
        }
    }
}

