/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven.plugin.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.glassfish.maven.plugin.GlassfishMojo;
import org.glassfish.maven.plugin.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsadminCommand {
    private static final int PROCESS_LOOP_SLEEP_MILLIS = 100;
    private static final int EXIT_SUCCESS = 0;
    protected GlassfishMojo sharedContext;
    private InputStream processOut;
    private InputStream processErr;

    protected AsadminCommand(GlassfishMojo sharedContext) {
        this.sharedContext = sharedContext;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.execute(new ProcessBuilder(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ProcessBuilder processBuilder) throws MojoExecutionException, MojoFailureException {
        ArrayList<String> commandLine = new ArrayList<String>(this.getParameters());
        File binDir = new File(this.sharedContext.getGlassfishDirectory(), "bin");
        File asadmin = new File(binDir, "asadmin");
        if (!asadmin.exists() && System.getProperty("os.name").contains("indows")) {
            asadmin = new File(binDir, "asadmin.bat");
        }
        commandLine.addAll(0, Arrays.asList(asadmin.getAbsolutePath(), this.getName(), "--echo=" + this.sharedContext.isEcho(), "--terse=" + this.sharedContext.isTerse()));
        Log log = this.sharedContext.getLog();
        log.debug((CharSequence)((Object)commandLine).toString());
        processBuilder.command(commandLine);
        try {
            int exitValue;
            Process process = processBuilder.start();
            this.processOut = process.getInputStream();
            this.processErr = process.getErrorStream();
            BufferedReader outReader = new BufferedReader(new InputStreamReader(this.processOut));
            block8: while (true) {
                try {
                    exitValue = process.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    Thread.sleep(100L);
                }
                finally {
                    while (true) {
                        if (!outReader.ready()) continue block8;
                        log.info((CharSequence)outReader.readLine());
                    }
                }
                break;
            }
            if (exitValue != 0) {
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(this.processErr));
                while (errorReader.ready()) {
                    log.error((CharSequence)errorReader.readLine());
                }
                String errorMessage = this.getErrorMessage();
                log.error((CharSequence)errorMessage);
                log.error((CharSequence)"For more detail on what might be causing the problem try running maven with the --debug option ");
                log.error((CharSequence)"or setting the maven-glassfish-plugin \"echo\" property to \"true\".");
                throw new MojoFailureException(errorMessage);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(this.getErrorMessage() + " IOException: " + e.getMessage());
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException(this.getErrorMessage() + " Process was interrupted: " + e.getMessage());
        }
    }

    protected String escape(String value, String chars) {
        return this.escape(value, chars, "\\\\");
    }

    protected String escape(String value, String chars, String escapeSequence) {
        String escaped = value;
        if (escaped == null) {
            return "";
        }
        for (char ch : chars.toCharArray()) {
            escaped = escaped.replaceAll(String.valueOf(ch), escapeSequence + ch);
        }
        return escaped;
    }

    protected abstract String getName();

    protected abstract List<String> getParameters();

    protected abstract String getErrorMessage();

    public InputStream getOut() {
        return this.processOut;
    }

    public InputStream getErr() {
        return this.processErr;
    }

    protected void addProperties(List<String> commandLine, Set<Property> objectProperties) {
        if (objectProperties != null && !objectProperties.isEmpty()) {
            StringBuilder properties = new StringBuilder();
            for (Property property : objectProperties) {
                if (properties.length() > 0) {
                    properties.append(':');
                }
                String name = this.escape(property.getName(), "=;:");
                String value = this.escape(property.getValue(), "=;:");
                properties.append(name).append('=').append(value);
            }
            commandLine.add("--property");
            commandLine.add(properties.toString());
        }
    }

    protected void addOptionalParameter(List<String> commandLine, String parameterName, String parameterValue) {
        if (parameterValue != null && parameterValue.trim().length() > 0) {
            commandLine.add(parameterName);
            commandLine.add(parameterValue);
        }
    }

    protected void addOptionalParameter(List<String> commandLine, String parameterName, int parameterValue) {
        if (parameterValue > 0) {
            commandLine.add(parameterName);
            commandLine.add(String.valueOf(parameterValue));
        }
    }

    protected void addOptionalParameter(List<String> commandLine, String parameterName, File parameterValue) {
        if (parameterValue != null) {
            commandLine.add(parameterName);
            commandLine.add(parameterValue.getAbsolutePath());
        }
    }

    protected void addSwitch(List<String> commandLine, String name, boolean value) {
        if (value) {
            commandLine.add(name);
        }
    }
}

