/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven.plugin.command;

import java.util.List;
import org.glassfish.maven.plugin.Domain;
import org.glassfish.maven.plugin.GlassfishMojo;
import org.glassfish.maven.plugin.command.InteractiveAsadminCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDomainCommand
extends InteractiveAsadminCommand {
    private Domain domain;

    public CreateDomainCommand(GlassfishMojo sharedContext, Domain domain) {
        super(sharedContext);
        this.domain = domain;
    }

    @Override
    protected String getName() {
        return "create-domain";
    }

    @Override
    protected List<String> getParameters() {
        StringBuilder domainProperties = new StringBuilder();
        if (this.domain.getHTTPSPort() > 0) {
            domainProperties.append("http.ssl.port=").append(this.domain.getHTTPSPort());
        }
        if (this.domain.getIIOPPort() > 0) {
            if (domainProperties.length() > 0) {
                domainProperties.append(":");
            }
            domainProperties.append("orb.listener.port=").append(this.domain.getIIOPPort());
        }
        if (this.domain.getJMSPort() > 0) {
            if (domainProperties.length() > 0) {
                domainProperties.append(":");
            }
            domainProperties.append("jms.port=").append(this.domain.getJMSPort());
        }
        List<String> parameters = super.getParameters();
        this.addOptionalParameter(parameters, "--domaindir", this.domain.getDirectory());
        this.addOptionalParameter(parameters, "--profile", this.domain.getProfile());
        this.addOptionalParameter(parameters, "--adminport", this.domain.getAdminPort());
        this.addOptionalParameter(parameters, "--instanceport", this.domain.getHTTPPort());
        this.addOptionalParameter(parameters, "--domainproperties", domainProperties.toString());
        parameters.add(this.domain.getName());
        return parameters;
    }

    @Override
    protected String getErrorMessage() {
        return "Unable to create domain \"" + this.domain.getName() + "\".";
    }
}

