/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven.plugin.command;

import java.util.Arrays;
import java.util.List;
import org.glassfish.maven.plugin.Domain;
import org.glassfish.maven.plugin.GlassfishMojo;
import org.glassfish.maven.plugin.JdbcDataSource;
import org.glassfish.maven.plugin.command.InteractiveAsadminCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateJDBCConnectionPoolCommand
extends InteractiveAsadminCommand {
    private Domain domain;
    private JdbcDataSource jdbcDataSource;

    public CreateJDBCConnectionPoolCommand(GlassfishMojo sharedContext, Domain domain, JdbcDataSource jdbcDataSource) {
        super(sharedContext);
        this.domain = domain;
        this.jdbcDataSource = jdbcDataSource;
    }

    @Override
    protected String getName() {
        return "create-jdbc-connection-pool";
    }

    @Override
    protected List<String> getParameters() {
        List<String> parameters = super.getParameters();
        parameters.addAll(Arrays.asList("--port", String.valueOf(this.domain.getAdminPort()), "--restype", this.jdbcDataSource.getType().toString(), "--validationmethod", this.jdbcDataSource.getValidationMethod(), "--allownoncomponentcallers=" + this.jdbcDataSource.isAllowNonComponentCallers(), "--isconnectvalidatereq=" + this.jdbcDataSource.isValidateConnections(), "--failconnection=" + this.jdbcDataSource.isFailConnection(), "--nontransactionalconnections=" + this.jdbcDataSource.isNonTransactionalConnections(), "--idletimeout", String.valueOf(this.jdbcDataSource.getIdleTimeout()), "--steadypoolsize", String.valueOf(this.jdbcDataSource.getSteadyPoolSize()), "--poolresize", String.valueOf(this.jdbcDataSource.getPoolResize()), "--maxpoolsize", String.valueOf(this.jdbcDataSource.getMaxPoolSize()), "--maxwait", String.valueOf(this.jdbcDataSource.getMaxWait()), "--datasourceclassname", this.jdbcDataSource.getClassName(), "--description", this.jdbcDataSource.getDescription()));
        this.addProperties(parameters, this.jdbcDataSource.getProperties());
        parameters.add(this.jdbcDataSource.getPoolName());
        return parameters;
    }

    @Override
    protected String getErrorMessage() {
        return "Unable to create JDBC connection pool " + this.jdbcDataSource.getPoolName() + ".";
    }
}

