/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven.plugin.command;

import java.util.Arrays;
import java.util.List;
import org.glassfish.maven.plugin.Domain;
import org.glassfish.maven.plugin.GlassfishMojo;
import org.glassfish.maven.plugin.JmsResource;
import org.glassfish.maven.plugin.command.InteractiveAsadminCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateJMSResourceCommand
extends InteractiveAsadminCommand {
    private Domain domain;
    private JmsResource resource;

    public CreateJMSResourceCommand(GlassfishMojo sharedContext, Domain domain, JmsResource resource) {
        super(sharedContext);
        this.domain = domain;
        this.resource = resource;
    }

    @Override
    protected String getName() {
        return "create-jms-resource";
    }

    @Override
    protected List<String> getParameters() {
        List<String> parameters = super.getParameters();
        parameters.addAll(Arrays.asList("--port", String.valueOf(this.domain.getAdminPort()), "--restype", this.resource.getType().toString()));
        this.addProperties(parameters, this.resource.getProperties());
        parameters.add(this.resource.getJndiName());
        return parameters;
    }

    @Override
    protected String getErrorMessage() {
        return "Unable to create JMS resource " + this.resource.getJndiName() + ".";
    }
}

