/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven.plugin.command;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.glassfish.maven.plugin.Domain;
import org.glassfish.maven.plugin.GlassfishMojo;
import org.glassfish.maven.plugin.command.InteractiveAsadminCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateJVMOptionsCommand
extends InteractiveAsadminCommand {
    private Domain domain;

    public CreateJVMOptionsCommand(GlassfishMojo sharedContext, Domain domain) {
        super(sharedContext);
        this.domain = domain;
    }

    @Override
    protected String getName() {
        return "create-jvm-options";
    }

    @Override
    protected List<String> getParameters() {
        Set<String> jvmOptions = this.domain.getJVMOptions();
        if (jvmOptions == null || jvmOptions.isEmpty()) {
            return null;
        }
        StringBuilder options = new StringBuilder();
        for (String option : jvmOptions) {
            if (options.length() > 0) {
                options.append(':');
            }
            options.append(this.escape(option, ";:", "\\\\"));
        }
        List<String> parameters = super.getParameters();
        parameters.addAll(Arrays.asList("--port", String.valueOf(this.domain.getAdminPort()), options.insert(0, "\\").toString()));
        return parameters;
    }

    @Override
    protected String getErrorMessage() {
        return "Unable to set JVM options for domain \"" + this.domain.getName() + "\".";
    }
}

