/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven.plugin.command;

import java.util.Arrays;
import java.util.List;
import org.glassfish.maven.plugin.Domain;
import org.glassfish.maven.plugin.GlassfishMojo;
import org.glassfish.maven.plugin.MessageSecurityProvider;
import org.glassfish.maven.plugin.command.InteractiveAsadminCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateMessageSecurityProviderCommand
extends InteractiveAsadminCommand {
    private Domain domain;
    private MessageSecurityProvider provider;

    public CreateMessageSecurityProviderCommand(GlassfishMojo sharedContext, Domain domain, MessageSecurityProvider provider) {
        super(sharedContext);
        this.domain = domain;
        this.provider = provider;
    }

    @Override
    protected String getName() {
        return "create-message-security-provider";
    }

    @Override
    protected List<String> getParameters() {
        List<String> parameters = super.getParameters();
        parameters.addAll(Arrays.asList("--host", this.domain.getHost(), "--target", "server", "--port", String.valueOf(this.domain.getAdminPort()), "--classname", this.provider.getClassName(), "--providertype", this.provider.getType(), "--layer", this.provider.getLayer()));
        this.addOptionalParameter(parameters, "--requestauthsource", this.provider.getRequestAuthSource());
        this.addOptionalParameter(parameters, "--requestauthrecipient", this.provider.getRequestAuthRecipient());
        this.addOptionalParameter(parameters, "--responseauthsource", this.provider.getResponseAuthSource());
        this.addOptionalParameter(parameters, "--responseauthrecipient", this.provider.getResponseAuthRecipient());
        this.addSwitch(parameters, "--isdefaultprovider", this.provider.isDefault());
        this.addProperties(parameters, this.provider.getProperties());
        parameters.add(this.provider.getName());
        return parameters;
    }

    @Override
    protected String getErrorMessage() {
        return "Unable to set message security provider " + this.provider.getName();
    }
}

