/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven.plugin.command;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.glassfish.maven.plugin.Component;
import org.glassfish.maven.plugin.DeploymentGlassfishMojo;
import org.glassfish.maven.plugin.Domain;
import org.glassfish.maven.plugin.command.InteractiveAsadminCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployCommand
extends InteractiveAsadminCommand {
    private Domain domain;
    private Component component;

    public DeployCommand(DeploymentGlassfishMojo sharedContext, Domain domain, Component component) {
        super(sharedContext);
        this.domain = domain;
        this.component = component;
    }

    @Override
    protected String getName() {
        return "deploy";
    }

    @Override
    protected List<String> getParameters() {
        boolean upload = true;
        try {
            upload = !InetAddress.getByName(this.domain.getHost()).isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        List<String> parameters = super.getParameters();
        parameters.addAll(Arrays.asList("--host", this.domain.getHost(), "--port", String.valueOf(this.domain.getAdminPort()), "--upload=" + upload, "--name", this.component.getName(), this.component.getArtifact().getAbsolutePath()));
        return parameters;
    }

    @Override
    protected String getErrorMessage() {
        return "Deployment of " + this.component.getArtifact().getAbsolutePath() + " failed.";
    }
}

