//Copyright Sun Microsystems Inc. 2004 - 2005.

package javax.annotation.security;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;

/**
 * Defines the identity of the application during execution in a J2EE 
 * container. This allows developers to execute under a particular role. 
 * The role must map to the user / group information in the containers 
 * security realm. It's value is the name of a security role.
 *
 * @since Common Annotations 1.0
 */
@Documented
@Retention (RUNTIME)
@Target(TYPE)
public @interface RunAs {
    String value();
}
