/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.saml.assertion.saml20.jaxb20;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.core.reference.X509SubjectKeyIdentifier;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.dsig.WSSPolicyConsumerImpl;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.saml.SAMLException;
import com.sun.xml.wss.saml.assertion.saml20.jaxb20.Advice;
import com.sun.xml.wss.saml.assertion.saml20.jaxb20.AttributeStatement;
import com.sun.xml.wss.saml.assertion.saml20.jaxb20.AuthnStatement;
import com.sun.xml.wss.saml.assertion.saml20.jaxb20.AuthzDecisionStatement;
import com.sun.xml.wss.saml.assertion.saml20.jaxb20.Conditions;
import com.sun.xml.wss.saml.assertion.saml20.jaxb20.NameID;
import com.sun.xml.wss.saml.assertion.saml20.jaxb20.Subject;
import com.sun.xml.wss.saml.internal.saml20.jaxb20.AssertionType;
import com.sun.xml.wss.saml.internal.saml20.jaxb20.AttributeStatementType;
import com.sun.xml.wss.saml.internal.saml20.jaxb20.AuthnStatementType;
import com.sun.xml.wss.saml.internal.saml20.jaxb20.AuthzDecisionStatementType;
import com.sun.xml.wss.saml.internal.saml20.jaxb20.NameIDType;
import com.sun.xml.wss.saml.internal.saml20.jaxb20.StatementAbstractType;
import com.sun.xml.wss.saml.util.SAML20JAXBUtil;
import com.sun.xml.wss.saml.util.SAMLUtil;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.crypto.Data;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assertion
extends AssertionType
implements com.sun.xml.wss.saml.Assertion {
    private Element signedAssertion = null;
    private NameIDType issuerValue = null;
    private BigInteger majorValue = null;
    private BigInteger minorValue = null;
    private List<Object> statementList = null;
    private String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private JAXBContext jc;
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/".intern();
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public Assertion(AssertionType assertion) {
        this.setID(assertion.getID());
        this.setIssueInstant(assertion.getIssueInstant());
        this.setIssuer(assertion.getIssuer());
        this.setAdvice(assertion.getAdvice());
        this.setConditions(assertion.getConditions());
        this.setSubject(assertion.getSubject());
        this.setVersion(assertion.getVersion());
        this.setSignature(assertion.getSignature());
        this.setStatement(assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement());
    }

    @Override
    public BigInteger getMajorVersion() {
        return this.majorValue;
    }

    @Override
    public BigInteger getMinorVersion() {
        return this.minorValue;
    }

    @Override
    public void setMajorVersion(BigInteger majorValue) {
        this.majorValue = majorValue;
    }

    @Override
    public void setMinorVersion(BigInteger minorValue) {
        this.minorValue = minorValue;
    }

    @Override
    public String getAssertionID() {
        return this.getID();
    }

    @Override
    public String getSamlIssuer() {
        this.issuerValue = this.getIssuer();
        return this.issuerValue.getValue();
    }

    @Override
    public String getIssueInstance() {
        if (this.issueInstant != null) {
            return this.issueInstant.toString();
        }
        return null;
    }

    @Override
    public Conditions getConditions() {
        Conditions cond = new Conditions(super.getConditions());
        return cond;
    }

    @Override
    public Advice getAdvice() {
        Advice adv = new Advice(super.getAdvice());
        return adv;
    }

    @Override
    public Subject getSubject() {
        Subject subj = new Subject(super.getSubject());
        return subj;
    }

    @Override
    public Element sign(PublicKey pubKey, PrivateKey privKey) throws SAMLException {
        if (this.signedAssertion != null) {
            return this.signedAssertion;
        }
        try {
            XMLSignatureFactory fac = WSSPolicyConsumerImpl.getInstance().getSignatureFactory();
            return this.sign(fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), "http://www.w3.org/2000/09/xmldsig#rsa-sha1", pubKey, privKey);
        }
        catch (Exception ex) {
            throw new SAMLException(ex);
        }
    }

    @Override
    public Element sign(X509Certificate cert, PrivateKey privKey, boolean alwaysIncludeCert) throws SAMLException {
        if (this.signedAssertion != null) {
            return this.signedAssertion;
        }
        try {
            XMLSignatureFactory fac = WSSPolicyConsumerImpl.getInstance().getSignatureFactory();
            return this.sign(fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), "http://www.w3.org/2000/09/xmldsig#rsa-sha1", cert, privKey, alwaysIncludeCert);
        }
        catch (Exception ex) {
            throw new SAMLException(ex);
        }
    }

    @Override
    public Element sign(X509Certificate cert, PrivateKey privKey, boolean alwaysIncludeCert, String sigAlgorithm, String canonicalizationAlgorithm) throws SAMLException {
        if (this.signedAssertion != null) {
            return this.signedAssertion;
        }
        if (sigAlgorithm == null) {
            sigAlgorithm = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        }
        if (canonicalizationAlgorithm != null) {
            this.canonicalizationMethod = canonicalizationAlgorithm;
        }
        try {
            XMLSignatureFactory fac = WSSPolicyConsumerImpl.getInstance().getSignatureFactory();
            return this.sign(fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), sigAlgorithm, cert, privKey, alwaysIncludeCert);
        }
        catch (Exception ex) {
            throw new SAMLException(ex);
        }
    }

    @Override
    public Element sign(X509Certificate cert, PrivateKey privKey) throws SAMLException {
        if (this.signedAssertion != null) {
            return this.signedAssertion;
        }
        try {
            XMLSignatureFactory fac = WSSPolicyConsumerImpl.getInstance().getSignatureFactory();
            return this.sign(fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), "http://www.w3.org/2000/09/xmldsig#rsa-sha1", cert, privKey);
        }
        catch (Exception ex) {
            throw new SAMLException(ex);
        }
    }

    @Override
    public Element sign(DigestMethod digestMethod, String signatureMethod, PublicKey pubKey, PrivateKey privKey) throws SAMLException {
        if (this.signedAssertion != null) {
            return this.signedAssertion;
        }
        try {
            XMLSignatureFactory fac = WSSPolicyConsumerImpl.getInstance().getSignatureFactory();
            ArrayList<Transform> transformList = new ArrayList<Transform>();
            Transform tr1 = fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
            Transform tr2 = fac.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null);
            transformList.add(tr1);
            transformList.add(tr2);
            String uri = "#" + this.getID();
            Reference ref = fac.newReference(uri, digestMethod, transformList, null, null);
            SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null), fac.newSignatureMethod(signatureMethod, null), Collections.singletonList(ref));
            KeyInfoFactory kif = fac.getKeyInfoFactory();
            KeyValue kv = kif.newKeyValue(pubKey);
            KeyInfo ki = kif.newKeyInfo(Collections.singletonList(kv));
            Document doc = XMLUtil.newDocument();
            Element assertionElement = this.toElement(doc);
            DOMSignContext dsc = null;
            KeySelector ks = KeySelector.singletonKeySelector(privKey);
            NodeList nl = assertionElement.getElementsByTagNameNS(assertionElement.getNamespaceURI(), "Issuer");
            Node issuer = null;
            if (nl != null && nl.getLength() > 0) {
                issuer = nl.item(0);
            }
            Node nextSibling = issuer != null ? issuer.getNextSibling() : null;
            dsc = nextSibling != null ? new DOMSignContext(ks, (Node)assertionElement, nextSibling) : new DOMSignContext(privKey, (Node)assertionElement);
            HashMap<String, Element> map = new HashMap<String, Element>();
            map.put(this.getID(), assertionElement);
            dsc.setURIDereferencer(new DSigResolver(map, assertionElement));
            XMLSignature signature = fac.newXMLSignature(si, ki);
            dsc.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
            signature.sign(dsc);
            this.signedAssertion = assertionElement;
            return assertionElement;
        }
        catch (Exception ex) {
            throw new SAMLException(ex);
        }
    }

    @Override
    public Element sign(DigestMethod digestMethod, String signatureMethod, X509Certificate cert, PrivateKey privKey, boolean includeCert) throws SAMLException {
        if (this.signedAssertion != null) {
            return this.signedAssertion;
        }
        try {
            byte[] skid;
            XMLSignatureFactory fac = WSSPolicyConsumerImpl.getInstance().getSignatureFactory();
            ArrayList<Transform> transformList = new ArrayList<Transform>();
            Transform tr1 = fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
            Transform tr2 = fac.newTransform(this.canonicalizationMethod, (TransformParameterSpec)null);
            transformList.add(tr1);
            transformList.add(tr2);
            String uri = "#" + this.getID();
            Reference ref = fac.newReference(uri, digestMethod, transformList, null, null);
            SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod(this.canonicalizationMethod, (C14NMethodParameterSpec)null), fac.newSignatureMethod(signatureMethod, null), Collections.singletonList(ref));
            SOAPPart doc = MessageFactory.newInstance().createMessage().getSOAPPart();
            KeyInfoFactory kif = fac.getKeyInfoFactory();
            KeyInfo ki = null;
            if (!includeCert && (skid = X509SubjectKeyIdentifier.getSubjectKeyIdentifier(cert)) != null) {
                X509SubjectKeyIdentifier keyIdentifier = new X509SubjectKeyIdentifier((Document)doc);
                keyIdentifier.setCertificate(cert);
                keyIdentifier.setReferenceValue(Base64.encode(skid));
                SecurityTokenReference str = new SecurityTokenReference();
                str.setReference(keyIdentifier);
                DOMStructure domKeyInfo = new DOMStructure((Node)str.getAsSoapElement());
                ki = kif.newKeyInfo(Collections.singletonList(domKeyInfo));
            }
            if (ki == null) {
                X509Data x509Data = kif.newX509Data(Collections.singletonList(cert));
                ki = kif.newKeyInfo(Collections.singletonList(x509Data));
            }
            Element assertionElement = this.toElement((Node)doc);
            DOMSignContext dsc = null;
            KeySelector ks = KeySelector.singletonKeySelector(privKey);
            NodeList nl = assertionElement.getElementsByTagNameNS(assertionElement.getNamespaceURI(), "Issuer");
            Node issuer = null;
            if (nl != null && nl.getLength() > 0) {
                issuer = nl.item(0);
            }
            Node nextSibling = issuer != null ? issuer.getNextSibling() : null;
            dsc = nextSibling != null ? new DOMSignContext(ks, (Node)assertionElement, nextSibling) : new DOMSignContext(privKey, (Node)assertionElement);
            HashMap<String, Element> map = new HashMap<String, Element>();
            map.put(this.getID(), assertionElement);
            dsc.setURIDereferencer(new DSigResolver(map, assertionElement));
            XMLSignature signature = fac.newXMLSignature(si, ki);
            dsc.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
            signature.sign(dsc);
            this.signedAssertion = assertionElement;
            return assertionElement;
        }
        catch (XWSSecurityException ex) {
            throw new SAMLException(ex);
        }
        catch (MarshalException ex) {
            throw new SAMLException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SAMLException(ex);
        }
        catch (SOAPException ex) {
            throw new SAMLException(ex);
        }
        catch (XMLSignatureException ex) {
            throw new SAMLException(ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new SAMLException(ex);
        }
    }

    @Override
    public Element sign(DigestMethod digestMethod, String signatureMethod, X509Certificate cert, PrivateKey privKey) throws SAMLException {
        return this.sign(digestMethod, signatureMethod, cert, privKey, false);
    }

    @Override
    public Element toElement(Node doc) throws XWSSecurityException {
        if (this.signedAssertion == null) {
            this.signedAssertion = SAMLUtil.toElement(doc, this, this.jc);
            if (this.signedAssertion == null) {
                return this.signedAssertion;
            }
            if (System.getProperty("com.sun.xml.wss.saml.binding.jaxb") == null) {
                this.signedAssertion.setAttributeNS(XMLNS_URI, "xmlns:xs", "http://www.w3.org/2001/XMLSchema");
            }
        }
        return this.signedAssertion;
    }

    public boolean isSigned() {
        return this.signature != null;
    }

    public static Assertion fromElement(Element element) throws SAMLException {
        try {
            JAXBContext jc = SAML20JAXBUtil.getJAXBContext();
            Unmarshaller u = jc.createUnmarshaller();
            Object el = u.unmarshal((Node)element);
            return new Assertion((AssertionType)((JAXBElement)el).getValue());
        }
        catch (Exception ex) {
            throw new SAMLException(ex);
        }
    }

    private void setStatement(List statement) {
        this.statementOrAuthnStatementOrAuthzDecisionStatement = statement;
    }

    @Override
    public String getType() {
        return "urn:oasis:names:tc:SAML:2.0:assertion";
    }

    @Override
    public Object getTokenValue() {
        try {
            Document doc = XMLUtil.newDocument();
            return this.toElement(doc);
        }
        catch (ParserConfigurationException ex) {
        }
        catch (XWSSecurityException xWSSecurityException) {
            // empty catch block
        }
        return null;
    }

    public Assertion(String assertionID, NameID issuer, GregorianCalendar issueInstant, Conditions conditions, Advice advice, Subject subject, List statements) throws SAMLException {
        if (assertionID != null) {
            this.setID(assertionID);
        }
        if (issuer != null) {
            this.setIssuer(issuer);
        }
        if (issueInstant != null) {
            try {
                DatatypeFactory factory = DatatypeFactory.newInstance();
                this.setIssueInstant(factory.newXMLGregorianCalendar(issueInstant));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (conditions != null) {
            this.setConditions(conditions);
        }
        if (advice != null) {
            this.setAdvice(advice);
        }
        if (statements != null) {
            this.setStatement(statements);
        }
        if (subject != null) {
            this.setSubject(subject);
        }
        this.setVersion("2.0");
    }

    public Assertion(String assertionID, NameID issuer, GregorianCalendar issueInstant, Conditions conditions, Advice advice, Subject subject, List statements, JAXBContext jcc) throws SAMLException {
        this(assertionID, issuer, issueInstant, conditions, advice, subject, statements);
        this.jc = jcc;
    }

    @Override
    public List<Object> getStatements() {
        if (this.statementList != null) {
            return this.statementList;
        }
        this.statementList = new ArrayList<Object>();
        List<StatementAbstractType> list = super.getStatementOrAuthnStatementOrAuthzDecisionStatement();
        for (StatementAbstractType object : list) {
            if (object instanceof AttributeStatementType) {
                AttributeStatement attStmt = new AttributeStatement((AttributeStatementType)object);
                this.statementList.add(attStmt);
                continue;
            }
            if (object instanceof AuthnStatementType) {
                AuthnStatement authStmt = new AuthnStatement((AuthnStatementType)object);
                this.statementList.add(authStmt);
                continue;
            }
            if (object instanceof AuthzDecisionStatementType) {
                AuthzDecisionStatement authDesStmt = new AuthzDecisionStatement((AuthzDecisionStatementType)object);
                this.statementList.add(authDesStmt);
                continue;
            }
            if (!(object instanceof AttributeStatement) && !(object instanceof AuthnStatement) && !(object instanceof AuthzDecisionStatement)) continue;
            this.statementList = list;
            return this.statementList;
        }
        return this.statementList;
    }

    @Override
    public boolean verifySignature(PublicKey pubKey) throws SAMLException {
        try {
            Document doc = XMLUtil.newDocument();
            Element samlAssertion = this.toElement(doc);
            HashMap<String, Element> map = new HashMap<String, Element>();
            map.put(this.getID(), samlAssertion);
            NodeList nl = samlAssertion.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nl.getLength() == 0) {
                throw new SAMLException("Unsigned SAML Assertion encountered while verifying the SAML signature");
            }
            Element signElement = (Element)nl.item(0);
            DOMValidateContext validationContext = new DOMValidateContext(pubKey, (Node)signElement);
            XMLSignatureFactory signatureFactory = WSSPolicyConsumerImpl.getInstance().getSignatureFactory();
            XMLSignature xmlSignature = signatureFactory.unmarshalXMLSignature(validationContext);
            validationContext.setURIDereferencer(new DSigResolver(map, samlAssertion));
            boolean coreValidity = xmlSignature.validate(validationContext);
            return coreValidity;
        }
        catch (Exception ex) {
            throw new SAMLException(ex);
        }
    }

    private static class DSigResolver
    implements URIDereferencer {
        Element elem = null;
        Map map = null;
        Class _nodeSetClass = null;
        String optNSClassName = "org.jcp.xml.dsig.internal.dom.DOMSubTreeData";
        Constructor _constructor = null;
        Boolean _false = false;

        DSigResolver(Map map, Element elem) {
            this.elem = elem;
            this.map = map;
            this.init();
        }

        void init() {
            try {
                this._nodeSetClass = Class.forName(this.optNSClassName);
                this._constructor = this._nodeSetClass.getConstructor(Node.class, Boolean.TYPE);
            }
            catch (LinkageError le) {
            }
            catch (ClassNotFoundException cne) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        public Data dereference(URIReference uriRef, XMLCryptoContext context) throws URIReferenceException {
            try {
                String uri = null;
                uri = uriRef.getURI();
                return this.dereferenceURI(uri, context);
            }
            catch (Exception ex) {
                throw new URIReferenceException(ex);
            }
        }

        Data dereferenceURI(String uri, XMLCryptoContext context) throws URIReferenceException {
            if (uri.charAt(0) == '#') {
                uri = uri.substring(1, uri.length());
                Element el = this.elem.getOwnerDocument().getElementById(uri);
                if (el == null) {
                    el = (Element)this.map.get(uri);
                }
                if (this._constructor != null) {
                    try {
                        return (Data)this._constructor.newInstance(el, this._false);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    final HashSet nodeSet = new HashSet();
                    this.toNodeSet(el, nodeSet);
                    return new NodeSetData(){

                        public Iterator iterator() {
                            return nodeSet.iterator();
                        }
                    };
                }
            }
            return null;
        }

        void toNodeSet(Node rootNode, Set result) {
            switch (rootNode.getNodeType()) {
                case 1: {
                    result.add(rootNode);
                    Element el = (Element)rootNode;
                    if (el.hasAttributes()) {
                        NamedNodeMap nl = ((Element)rootNode).getAttributes();
                        for (int i = 0; i < nl.getLength(); ++i) {
                            result.add(nl.item(i));
                        }
                    }
                }
                case 9: {
                    for (Node r = rootNode.getFirstChild(); r != null; r = r.getNextSibling()) {
                        if (r.getNodeType() == 3) {
                            result.add(r);
                            while (r != null && r.getNodeType() == 3) {
                                r = r.getNextSibling();
                            }
                            if (r == null) {
                                return;
                            }
                        }
                        this.toNodeSet(r, result);
                    }
                    return;
                }
                case 8: {
                    return;
                }
                case 10: {
                    return;
                }
            }
            result.add(rootNode);
        }
    }
}

