/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.EncodingException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.ObjectSerializerBase;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.processor.modeler.rmi.SOAPSimpleTypeCreatorBase;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPEncodingConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.util.JAXRPCClassFactory;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class GenericObjectSerializer
extends ObjectSerializerBase
implements Initializable {
    protected Class targetClass = null;
    protected List members = new ArrayList();
    protected Map xmlToJavaType = new HashMap();
    protected Map javaToXmlType = new HashMap();
    protected InternalTypeMappingRegistry registry;
    private SOAPEncodingConstants soapEncodingConstants = null;

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
    }

    public GenericObjectSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle) {
        this(type, encodeType, isNullable, encodingStyle, SOAPVersion.SOAP_11);
    }

    public GenericObjectSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, SOAPVersion ver) {
        super(type, encodeType, isNullable, encodingStyle);
        this.init(ver);
        SOAPSimpleTypeCreatorBase typeCreator = JAXRPCClassFactory.newInstance().createSOAPSimpleTypeCreator(false, ver);
        typeCreator.initializeJavaToXmlTypeMap(this.javaToXmlType);
    }

    public void addTypeRelation(Class javaType, QName xmlType) {
        if (javaType == null || xmlType == null) {
            throw new IllegalArgumentException("Neither javaType nor xmlType may be null");
        }
        this.javaToXmlType.put(javaType, xmlType);
        this.xmlToJavaType.put(xmlType, javaType);
    }

    public void setTargetClass(Class targetClass) {
        this.clearMembers();
        this.doSetTargetClass(targetClass);
        this.targetClass = targetClass;
    }

    protected void doSetTargetClass(Class targetClass) {
    }

    @Override
    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        this.registry = registry;
        for (MemberInfo currentMember : this.members) {
            currentMember.serializer = (JAXRPCSerializer)registry.getSerializer(this.encodingStyle, currentMember.javaType, currentMember.xmlType);
            currentMember.deserializer = (JAXRPCDeserializer)registry.getDeserializer(this.encodingStyle, currentMember.javaType, currentMember.xmlType);
        }
    }

    public void clearMembers() {
        this.members.clear();
    }

    public void addMember(MemberInfo member) throws Exception {
        for (MemberInfo existingMember : this.members) {
            if (!existingMember.name.equals(member.name)) continue;
            throw new EncodingException("soap.duplicate.data.member", new Object[]{member.name});
        }
        if (member.xmlType == null) {
            member.xmlType = (QName)this.javaToXmlType.get(member.javaType);
        }
        if (member.javaType == null) {
            member.javaType = (Class)this.xmlToJavaType.get(member.xmlType);
        }
        this.members.add(member);
    }

    @Override
    protected void doSerializeInstance(Object instance, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        this.members = this.getMemberOrder(instance, this.members);
        for (int i = 0; i < this.members.size(); ++i) {
            MemberInfo currentMember = (MemberInfo)this.members.get(i);
            if (currentMember.serializer == null) {
                Class<?> javaType = instance.getClass();
                currentMember.serializer = (JAXRPCSerializer)this.registry.getSerializer(this.soapEncodingConstants.getSOAPEncodingNamespace(), javaType, currentMember.xmlType);
            }
            currentMember.serializer.serialize(currentMember.getter.get(instance), currentMember.name, null, writer, context);
        }
    }

    @Override
    protected Object doDeserialize(SOAPDeserializationState state, XMLReader reader, SOAPDeserializationContext context) throws Exception {
        Object instance = this.targetClass.newInstance();
        SOAPGenericObjectInstanceBuilder builder = null;
        boolean isComplete = true;
        this.members = this.getMemberOrder(instance, this.members);
        int lastMemberIndex = this.members.size() - 1;
        block0: for (int memberCount = 0; memberCount <= lastMemberIndex; ++memberCount) {
            reader.nextElementContent();
            int memberIndex = memberCount;
            do {
                MemberInfo currentMember = (MemberInfo)this.members.get(memberIndex);
                if (reader.getName().equals(currentMember.name)) {
                    Object member;
                    if (currentMember.deserializer == null) {
                        QName xmlType = currentMember.xmlType != null ? currentMember.xmlType : SerializerBase.getType(reader);
                        currentMember.deserializer = (JAXRPCDeserializer)this.registry.getDeserializer(this.soapEncodingConstants.getSOAPEncodingNamespace(), currentMember.javaType, xmlType);
                    }
                    if ((member = currentMember.deserializer.deserialize(currentMember.name, reader, context)) instanceof SOAPDeserializationState) {
                        if (builder == null) {
                            builder = new SOAPGenericObjectInstanceBuilder(instance);
                        }
                        state = GenericObjectSerializer.registerWithMemberState(instance, state, member, memberIndex, builder);
                        isComplete = false;
                        continue block0;
                    }
                    currentMember.setter.set(instance, member);
                    continue block0;
                }
                if (memberIndex == lastMemberIndex) {
                    memberIndex = 0;
                    continue;
                }
                ++memberIndex;
            } while (memberIndex != memberCount);
        }
        return isComplete ? instance : state;
    }

    protected List getMemberOrder(Object instance, List membersAlphabetically) {
        if (membersAlphabetically == null) {
            return null;
        }
        ArrayList<String> members = new ArrayList<String>();
        Class<?> targetClass = instance.getClass();
        int introspectedSize = membersAlphabetically.size();
        Field[] fields = targetClass.getDeclaredFields();
        int flen = fields != null ? fields.length : 0;
        ArrayList<Field> fieldList = new ArrayList<Field>(Arrays.asList(fields));
        if (flen < introspectedSize) {
            for (Class<?> superClass = targetClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
                ArrayList<Field> superList = null;
                Field[] superFields = superClass.getDeclaredFields();
                if (superFields == null) continue;
                superList = new ArrayList<Field>(Arrays.asList(superFields));
                for (int i = 0; i < superList.size(); ++i) {
                    Field obj = superList.get(i);
                    fieldList.add(i, obj);
                }
            }
        }
        fields = null;
        fields = fieldList.toArray(new Field[fieldList.size()]);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int fieldModifiers = field.getModifiers();
            if (Modifier.isTransient(fieldModifiers) || Modifier.isFinal(fieldModifiers)) continue;
            String name = field.getName();
            members.add(name);
        }
        if (members.size() == 0) {
            return membersAlphabetically;
        }
        ArrayList<MemberInfo> orderedMembers = new ArrayList<MemberInfo>();
        for (int i = 0; i < members.size(); ++i) {
            String name = (String)members.get(i);
            for (int j = 0; j < membersAlphabetically.size(); ++j) {
                MemberInfo info = (MemberInfo)membersAlphabetically.get(j);
                if (!name.equalsIgnoreCase(info.name.getLocalPart())) continue;
                if (!name.equals(info.name.getLocalPart())) {
                    String ns = info.name.getNamespaceURI();
                    info.name = new QName(ns, name);
                    info.xmlType = new QName(ns, name);
                }
                orderedMembers.add(info);
            }
        }
        if (orderedMembers.size() == 0) {
            return membersAlphabetically;
        }
        return orderedMembers;
    }

    public static class MemberInfo {
        QName name = null;
        QName xmlType = null;
        Class javaType = null;
        JAXRPCSerializer serializer = null;
        JAXRPCDeserializer deserializer = null;
        GetterMethod getter = null;
        SetterMethod setter = null;
    }

    public static interface GetterMethod {
        public Object get(Object var1) throws Exception;
    }

    protected class SOAPGenericObjectInstanceBuilder
    implements SOAPInstanceBuilder {
        Object instance;

        SOAPGenericObjectInstanceBuilder(Object instance) {
            this.instance = instance;
        }

        @Override
        public int memberGateType(int memberIndex) {
            return 6;
        }

        @Override
        public void construct() {
        }

        @Override
        public void setMember(int index, Object memberValue) {
            try {
                ((MemberInfo)GenericObjectSerializer.this.members.get((int)index)).setter.set(this.instance, memberValue);
            }
            catch (Exception e) {
                throw new DeserializationException("nestedSerializationError", new LocalizableExceptionAdapter(e));
            }
        }

        @Override
        public void initialize() {
        }

        @Override
        public void setInstance(Object instance) {
        }

        @Override
        public Object getInstance() {
            return this.instance;
        }
    }

    public static interface SetterMethod {
        public void set(Object var1, Object var2) throws Exception;
    }
}

