/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.istack.NotNull;
import com.sun.xml.security.core.ai.IdentityType;
import com.sun.xml.security.core.ai.ObjectFactory;
import com.sun.xml.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.server.EndpointReferenceExtensionContributor;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.opt.impl.util.CertificateRetriever;
import com.sun.xml.ws.security.opt.impl.util.JAXBUtil;
import com.sun.xml.ws.security.secext10.BinarySecurityTokenType;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;

public class IdentityEPRExtnContributor
extends EndpointReferenceExtensionContributor {
    private Certificate cs = null;
    QName ID_QNAME = null;
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public <T> T getSPI(@NotNull Class<T> spiType) {
        if (spiType.isAssignableFrom(EndpointReferenceExtensionContributor.class)) {
            return (T)new IdentityEPRExtnContributor();
        }
        return null;
    }

    @Override
    public WSEndpointReference.EPRExtension getEPRExtension(WSEndpoint wse, WSEndpointReference.EPRExtension extension) {
        if (extension != null) {
            return extension;
        }
        CertificateRetriever cr = new CertificateRetriever();
        QName eprQName = new QName("http://schemas.sun.com/2006/03/wss/server", "EnableEPRIdentity");
        boolean found = cr.checkforEPRIdentity(wse, eprQName);
        if (!found) {
            return null;
        }
        try {
            URL url = SecurityUtil.loadFromClasspath("META-INF/ServerCertificate.cert");
            if (url != null) {
                CertificateFactory certFact = CertificateFactory.getInstance("X.509");
                InputStream is = url.openStream();
                this.cs = certFact.generateCertificate(is);
                is.close();
            } else {
                this.cs = cr.getServerKeyStore(wse);
                if (this.cs == null) {
                    return null;
                }
            }
        }
        catch (CertificateException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0818_ERROR_PUTTING_CERTIFICATE_EPRIDENTITY(), ex);
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0818_ERROR_PUTTING_CERTIFICATE_EPRIDENTITY(), ex);
            throw new RuntimeException(ex);
        }
        catch (XWSSecurityException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0818_ERROR_PUTTING_CERTIFICATE_EPRIDENTITY(), ex);
            throw new RuntimeException(ex);
        }
        return new WSEndpointReference.EPRExtension(){

            @Override
            public XMLStreamReader readAsXMLStreamReader() throws XMLStreamException {
                XMLStreamReader reader = null;
                try {
                    String id = PolicyUtil.randomUUID();
                    BinarySecurityTokenType bst = new BinarySecurityTokenType();
                    bst.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
                    bst.setId(id);
                    bst.setEncodingType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
                    if (IdentityEPRExtnContributor.this.cs != null) {
                        bst.setValue(IdentityEPRExtnContributor.this.cs.getEncoded());
                    }
                    JAXBElement<BinarySecurityTokenType> bstElem = new com.sun.xml.ws.security.secext10.ObjectFactory().createBinarySecurityToken(bst);
                    IdentityType identityElement = new IdentityType();
                    identityElement.getDnsOrSpnOrUpn().add(bstElem);
                    reader = IdentityEPRExtnContributor.this.readHeader(identityElement);
                }
                catch (CertificateEncodingException ex) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_0818_ERROR_PUTTING_CERTIFICATE_EPRIDENTITY(), ex);
                    throw new RuntimeException(ex);
                }
                return reader;
            }

            @Override
            public QName getQName() {
                return new QName("http://schemas.xmlsoap.org/ws/2006/02/addressingidentity", "Identity");
            }
        };
    }

    @Override
    public QName getQName() {
        return this.ID_QNAME;
    }

    public XMLStreamReader readHeader(IdentityType identityElem) throws XMLStreamException {
        XMLStreamBufferResult xbr = new XMLStreamBufferResult();
        JAXBElement<IdentityType> idElem = new ObjectFactory().createIdentity(identityElem);
        try {
            JAXBContext context = JAXBUtil.getCustomIdentityJAXBContext();
            Marshaller m = context.createMarshaller();
            m.setProperty("com.sun.xml.bind.xmlDeclaration", (Object)false);
            m.marshal(idElem, (Result)xbr);
        }
        catch (JAXBException je) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0818_ERROR_PUTTING_CERTIFICATE_EPRIDENTITY(), je);
            throw new XMLStreamException(je);
        }
        return xbr.getXMLStreamBuffer().readAsXMLStreamReader();
    }
}

