/*
 * Copyright (c) 1997, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package internal.com.sun.istack;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.Location;

/**
 * {@link XMLStreamException} that properly handles exception chaining.
 *
 * @author Kohsuke Kawaguchi
 */
public class XMLStreamException2 extends XMLStreamException {
    public XMLStreamException2(String msg) {
        super(msg);
    }

    public XMLStreamException2(Throwable th) {
        super(th);
    }

    public XMLStreamException2(String msg, Throwable th) {
        super(msg, th);
    }

    public XMLStreamException2(String msg, Location location) {
        super(msg, location);
    }

    public XMLStreamException2(String msg, Location location, Throwable th) {
        super(msg, location, th);
    }

    /**
     * {@link XMLStreamException} doesn't return the correct cause.
     */
    public Throwable getCause() {
        return getNestedException();
    }
}
