/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.policy.verifier;

import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.PolicyViolationException;
import com.sun.xml.wss.impl.WSSAssertion;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.KeyBindingBase;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.spi.PolicyVerifier;

public class SignaturePolicyVerifier
implements PolicyVerifier {
    FilterProcessingContext context;

    public SignaturePolicyVerifier(FilterProcessingContext context) {
        this.context = context;
    }

    @Override
    public void verifyPolicy(SecurityPolicy configPolicy, SecurityPolicy recvdPolicy) throws PolicyViolationException {
        if (PolicyTypeUtil.signaturePolicy(configPolicy) && PolicyTypeUtil.signaturePolicy(recvdPolicy)) {
            SignaturePolicy rsignPolicy = (SignaturePolicy)recvdPolicy;
            SignaturePolicy csignPolicy = (SignaturePolicy)configPolicy;
            SignaturePolicy.FeatureBinding rfBinding = (SignaturePolicy.FeatureBinding)rsignPolicy.getFeatureBinding();
            SignaturePolicy.FeatureBinding cfBinding = (SignaturePolicy.FeatureBinding)csignPolicy.getFeatureBinding();
            String cCanonAlgo = cfBinding.getCanonicalizationAlgorithm();
            String rCanonAlgo = rfBinding.getCanonicalizationAlgorithm();
            if (cCanonAlgo == null || rCanonAlgo == null) {
                throw new PolicyViolationException("Either Policy configured or Policy inferred is null while verifying inferredPolicy with configuredPolicy");
            }
            if (cCanonAlgo.length() > 0 && rCanonAlgo.length() > 0 && !rCanonAlgo.equals(cCanonAlgo)) {
                throw new PolicyViolationException("Receiver side requirement verification failed, canonicalization algorithm received in the message is " + rfBinding.getCanonicalizationAlgorithm() + " policy requires " + cfBinding.getCanonicalizationAlgorithm());
            }
        }
    }

    private void checkSAMLAssertionBinding(AuthenticationTokenPolicy.SAMLAssertionBinding configPolicy, AuthenticationTokenPolicy.SAMLAssertionBinding recvdPolicy) throws PolicyViolationException {
        boolean matched = true;
        String _cAI = configPolicy.getAuthorityIdentifier();
        String _rAI = recvdPolicy.getAuthorityIdentifier();
        if (_cAI != null && _cAI.length() > 0 && _rAI != null) {
            matched = _cAI.equals(_rAI);
            this._throwError(configPolicy, recvdPolicy, matched);
        }
    }

    private void checkX509CertificateBinding(AuthenticationTokenPolicy.X509CertificateBinding configPolicy, AuthenticationTokenPolicy.X509CertificateBinding recvdPolicy) throws PolicyViolationException {
        boolean matched = true;
        configPolicy = this.setReferenceType(configPolicy);
        String ckeyAlg = configPolicy.getKeyAlgorithm();
        String rkeyAlg = recvdPolicy.getKeyAlgorithm();
        if (ckeyAlg != null && ckeyAlg.length() > 0 && rkeyAlg.length() > 0) {
            matched = ckeyAlg.equals(rkeyAlg);
        }
        this._throwError(configPolicy, recvdPolicy, matched);
        String cVT = configPolicy.getValueType();
        String rVT = recvdPolicy.getValueType();
        if (cVT != null && cVT.length() > 0 && rVT.length() > 0) {
            matched = cVT.equals(rVT);
        }
        this._throwError(configPolicy, recvdPolicy, matched);
    }

    private void _throwError(SecurityPolicy configPolicy, SecurityPolicy recvdPolicy, boolean matched) throws PolicyViolationException {
        if (!matched) {
            throw new PolicyViolationException("KeyType used to sign the message doesnot match with  the receiver side requirements. Configured KeyType is " + configPolicy + " KeyType inferred from the message is  " + recvdPolicy);
        }
    }

    private AuthenticationTokenPolicy.X509CertificateBinding setReferenceType(AuthenticationTokenPolicy.X509CertificateBinding configPolicy) {
        if (configPolicy.policyTokenWasSet() && (KeyBindingBase.INCLUDE_NEVER.equals(configPolicy.getIncludeToken()) || KeyBindingBase.INCLUDE_NEVER_VER2.equals(configPolicy.getIncludeToken()))) {
            WSSAssertion wssAssertion = this.context.getWSSAssertion();
            if ("Direct".equals(configPolicy.getReferenceType())) {
                if (wssAssertion != null) {
                    if (wssAssertion.getRequiredProperties().contains("MustSupportRefKeyIdentifier")) {
                        configPolicy.setReferenceType("Identifier");
                    } else if (wssAssertion.getRequiredProperties().contains("MustSupportRefThumbprint")) {
                        configPolicy.setReferenceType("Thumbprint");
                    }
                } else {
                    configPolicy.setReferenceType("Identifier");
                }
            }
        }
        return configPolicy;
    }
}

