
package com.sun.xml.ws.rx.localization;

import java.util.Locale;
import java.util.ResourceBundle;
import com.sun.istack.localization.Localizable;
import com.sun.istack.localization.LocalizableMessageFactory;
import com.sun.istack.localization.LocalizableMessageFactory.ResourceBundleSupplier;
import com.sun.istack.localization.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static String BUNDLE_NAME = "com.sun.xml.ws.rx.localization.Localization";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    private LocalizationMessages() {
    }

    public static Localizable localizableWSRX_1001_UNABLE_TO_SERIALIZE_MSG_TO_XML_STREAM() {
        return MESSAGE_FACTORY.getMessage("WSRX1001_UNABLE_TO_SERIALIZE_MSG_TO_XML_STREAM");
    }

    /**
     * WSRX1001: Unable to serialize message to XML stream
     * 
     */
    public static String WSRX_1001_UNABLE_TO_SERIALIZE_MSG_TO_XML_STREAM() {
        return LOCALIZER.localize(localizableWSRX_1001_UNABLE_TO_SERIALIZE_MSG_TO_XML_STREAM());
    }

    public static Localizable localizableWSRX_1002_UNABLE_TO_DESERIALIZE_MSG_FROM_XML_STREAM() {
        return MESSAGE_FACTORY.getMessage("WSRX1002_UNABLE_TO_DESERIALIZE_MSG_FROM_XML_STREAM");
    }

    /**
     * WSRX1002: Unable to deserialize message from XML stream
     * 
     */
    public static String WSRX_1002_UNABLE_TO_DESERIALIZE_MSG_FROM_XML_STREAM() {
        return LOCALIZER.localize(localizableWSRX_1002_UNABLE_TO_DESERIALIZE_MSG_FROM_XML_STREAM());
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
