
package com.sun.xml.ws.security.message.stream;

import java.util.Locale;
import java.util.ResourceBundle;
import com.sun.istack.localization.Localizable;
import com.sun.istack.localization.LocalizableMessageFactory;
import com.sun.istack.localization.LocalizableMessageFactory.ResourceBundleSupplier;
import com.sun.istack.localization.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LogStringsMessages {

    private final static String BUNDLE_NAME = "com.sun.xml.ws.security.message.stream.LogStrings";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LogStringsMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    private LogStringsMessages() {
    }

    public static Localizable localizableWSSMSG_0002_ERROR_READING_BUFFER() {
        return MESSAGE_FACTORY.getMessage("WSSMSG0002.error.reading.buffer");
    }

    /**
     * WSSMSG0002: Error occurred while reading incoming SOAP message from the buffer, debug is enabled.
     * 
     */
    public static String WSSMSG_0002_ERROR_READING_BUFFER() {
        return LOCALIZER.localize(localizableWSSMSG_0002_ERROR_READING_BUFFER());
    }

    public static Localizable localizableWSSMSG_0003_ERROR_PRINT() {
        return MESSAGE_FACTORY.getMessage("WSSMSG0003.error.print");
    }

    /**
     * WSSMSG004: Error occurred while printing the incoming SOAP message.
     * 
     */
    public static String WSSMSG_0003_ERROR_PRINT() {
        return LOCALIZER.localize(localizableWSSMSG_0003_ERROR_PRINT());
    }

    public static Localizable localizableWSSMSG_0001_PROBLEM_CACHING() {
        return MESSAGE_FACTORY.getMessage("WSSMSG0001.problem.caching");
    }

    /**
     * WSSMSG0001: Error occurred while buffering incoming SOAP message.
     * 
     */
    public static String WSSMSG_0001_PROBLEM_CACHING() {
        return LOCALIZER.localize(localizableWSSMSG_0001_PROBLEM_CACHING());
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
