/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wscompile;

import com.sun.codemodel.JCodeModel;
import com.sun.tools.ws.processor.generator.GeneratorExtension;
import com.sun.tools.ws.resources.ConfigurationMessages;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.util.ForkEntityResolver;
import com.sun.tools.ws.wscompile.BadCommandLineException;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.Options;
import com.sun.tools.ws.wscompile.Plugin;
import com.sun.tools.ws.wsdl.document.jaxws.JAXWSBindingsConstants;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.SpecVersion;
import com.sun.tools.xjc.api.XJC;
import com.sun.tools.xjc.reader.Util;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.ws.util.JAXWSUtils;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.LocatorImpl;

public class WsimportOptions
extends Options {
    public String wsdlLocation;
    public EntityResolver entityResolver = null;
    public String defaultPackage = null;
    public String clientjar = null;
    public boolean additionalHeaders;
    public File implDestDir = null;
    public String implServiceName = null;
    public String implPortName = null;
    public boolean isGenerateJWS = false;
    public boolean disableSSLHostnameVerification;
    public boolean useBaseResourceAndURLToLoadWSDL = false;
    private String javaModule = null;
    private SchemaCompiler schemaCompiler = XJC.createSchemaCompiler();
    public File authFile = null;
    public static final String defaultAuthfile = System.getProperty("user.home") + System.getProperty("file.separator") + ".metro" + System.getProperty("file.separator") + "auth";
    public boolean disableAuthenticator;
    public String proxyAuth = null;
    private String proxyHost = null;
    private String proxyPort = null;
    public HashMap<String, String> extensionOptions = new HashMap();
    private List<Plugin> allPlugins;
    public final List<Plugin> activePlugins = new ArrayList<Plugin>();
    private JCodeModel codeModel;
    public List<String> cmdlineJars = new ArrayList<String>();
    public boolean noAddressingBbinding;
    private final List<InputSource> wsdls = new ArrayList<InputSource>();
    private final List<InputSource> schemas = new ArrayList<InputSource>();
    private final List<InputSource> bindingFiles = new ArrayList<InputSource>();
    private final List<InputSource> jaxwsCustomBindings = new ArrayList<InputSource>();
    private final List<InputSource> jaxbCustomBindings = new ArrayList<InputSource>();
    private final List<Element> handlerConfigs = new ArrayList<Element>();

    public JCodeModel getCodeModel() {
        if (this.codeModel == null) {
            this.codeModel = new JCodeModel();
        }
        return this.codeModel;
    }

    public SchemaCompiler getSchemaCompiler() {
        this.schemaCompiler.setTargetVersion(SpecVersion.parse((String)this.target.getVersion()));
        if (this.entityResolver != null) {
            this.schemaCompiler.setEntityResolver(this.entityResolver);
        }
        return this.schemaCompiler;
    }

    public void setCodeModel(JCodeModel codeModel) {
        this.codeModel = codeModel;
        this.addClassReplacersInCodeModel();
    }

    public List<Plugin> getAllPlugins() {
        if (this.allPlugins == null) {
            this.allPlugins = new ArrayList<Plugin>();
            this.allPlugins.addAll(Arrays.asList(WsimportOptions.findServices(Plugin.class, this.getClassLoader())));
        }
        return this.allPlugins;
    }

    public String getModuleName() {
        return this.javaModule;
    }

    @Override
    public final void parseArguments(String[] args) throws BadCommandLineException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].length() == 0) {
                throw new BadCommandLineException();
            }
            if (args[i].charAt(0) == '-') {
                int j = this.parseArguments(args, i);
                if (j == 0) {
                    throw new BadCommandLineException(WscompileMessages.WSCOMPILE_INVALID_OPTION(args[i]));
                }
                i += j - 1;
                continue;
            }
            if (args[i].endsWith(".jar")) {
                try {
                    this.cmdlineJars.add(args[i]);
                    com.sun.tools.xjc.Options jaxbOptions = this.schemaCompiler.getOptions();
                    jaxbOptions.scanEpisodeFile(new File(args[i]));
                    continue;
                }
                catch (com.sun.tools.xjc.BadCommandLineException e) {
                    throw new BadCommandLineException(e.getMessage(), e);
                }
            }
            this.addFile(args[i]);
        }
        if (this.encoding != null) {
            com.sun.tools.xjc.Options jaxbOptions = this.schemaCompiler.getOptions();
            if (jaxbOptions.encoding == null) {
                try {
                    jaxbOptions.parseArgument(new String[]{"-encoding", this.encoding}, 0);
                }
                catch (com.sun.tools.xjc.BadCommandLineException ex) {
                    Logger.getLogger(WsimportOptions.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (this.destDir == null) {
            this.destDir = new File(".");
        }
        if (this.sourceDir == null) {
            this.sourceDir = this.destDir;
        }
        this.addClassReplacersInCodeModel();
    }

    private void addClassReplacersInCodeModel() {
        JCodeModel codeModel = this.getCodeModel();
        for (Map.Entry pair : this.classNameReplacer.entrySet()) {
            codeModel.addClassNameReplacer((String)pair.getKey(), (String)pair.getValue());
        }
    }

    @Override
    public int parseArguments(String[] args, int i) throws BadCommandLineException {
        int j = super.parseArguments(args, i);
        if (j > 0) {
            return j;
        }
        if (args[i].equals("-b")) {
            this.addBindings(this.requireArgument("-b", args, ++i));
            return 2;
        }
        if (args[i].equals("-wsdllocation")) {
            this.wsdlLocation = this.requireArgument("-wsdllocation", args, ++i);
            return 2;
        }
        if (args[i].equals("-XadditionalHeaders")) {
            this.additionalHeaders = true;
            return 1;
        }
        if (args[i].equals("-XdisableSSLHostnameVerification")) {
            this.disableSSLHostnameVerification = true;
            return 1;
        }
        if (args[i].equals("-p")) {
            this.defaultPackage = this.requireArgument("-p", args, ++i);
            return 2;
        }
        if (args[i].equals("-m")) {
            this.javaModule = this.requireArgument("-m", args, ++i);
            return 2;
        }
        if (args[i].equals("-catalog")) {
            String catalog = this.requireArgument("-catalog", args, ++i);
            try {
                if (this.entityResolver == null) {
                    if (catalog != null && catalog.length() > 0) {
                        this.entityResolver = XmlUtil.createEntityResolver(JAXWSUtils.getFileOrURL(JAXWSUtils.absolutize(Util.escapeSpace((String)catalog))));
                    }
                } else if (catalog != null && catalog.length() > 0) {
                    EntityResolver er = XmlUtil.createEntityResolver(JAXWSUtils.getFileOrURL(JAXWSUtils.absolutize(Util.escapeSpace((String)catalog))));
                    this.entityResolver = new ForkEntityResolver(er, this.entityResolver);
                }
            }
            catch (IOException e) {
                throw new BadCommandLineException(WscompileMessages.WSIMPORT_FAILED_TO_PARSE(catalog, e.getMessage()));
            }
            return 2;
        }
        if (args[i].startsWith("-httpproxy:")) {
            String value = args[i].substring(11);
            if (value.length() == 0) {
                throw new BadCommandLineException(WscompileMessages.WSCOMPILE_INVALID_OPTION(args[i]));
            }
            this.parseProxy(value);
            if (this.proxyHost != null || this.proxyPort != null) {
                System.setProperty("proxySet", "true");
            }
            if (this.proxyHost != null) {
                System.setProperty("proxyHost", this.proxyHost);
            }
            if (this.proxyPort != null) {
                System.setProperty("proxyPort", this.proxyPort);
            }
            return 1;
        }
        if (args[i].equals("-Xno-addressing-databinding")) {
            this.noAddressingBbinding = true;
            return 1;
        }
        if (args[i].startsWith("-B")) {
            String[] subCmd = new String[args.length - i];
            System.arraycopy(args, i, subCmd, 0, subCmd.length);
            subCmd[0] = subCmd[0].substring(2);
            com.sun.tools.xjc.Options jaxbOptions = this.schemaCompiler.getOptions();
            try {
                int r = jaxbOptions.parseArgument(subCmd, 0);
                if (r == 0) {
                    throw new BadCommandLineException(WscompileMessages.WSIMPORT_NO_SUCH_JAXB_OPTION(subCmd[0]));
                }
                return r;
            }
            catch (com.sun.tools.xjc.BadCommandLineException e) {
                throw new BadCommandLineException(e.getMessage(), e);
            }
        }
        if (args[i].equals("-Xauthfile")) {
            String authfile = this.requireArgument("-Xauthfile", args, ++i);
            this.authFile = new File(authfile);
            return 2;
        }
        if (args[i].equals("-clientjar")) {
            this.clientjar = this.requireArgument("-clientjar", args, ++i);
            return 2;
        }
        if (args[i].equals("-implDestDir")) {
            this.implDestDir = new File(this.requireArgument("-implDestDir", args, ++i));
            if (!this.implDestDir.exists()) {
                throw new BadCommandLineException(WscompileMessages.WSCOMPILE_NO_SUCH_DIRECTORY(this.implDestDir.getPath()));
            }
            return 2;
        }
        if (args[i].equals("-implServiceName")) {
            this.implServiceName = this.requireArgument("-implServiceName", args, ++i);
            return 2;
        }
        if (args[i].equals("-implPortName")) {
            this.implPortName = this.requireArgument("-implPortName", args, ++i);
            return 2;
        }
        if (args[i].equals("-generateJWS")) {
            this.isGenerateJWS = true;
            return 1;
        }
        if (args[i].equals("-XuseBaseResourceAndURLToLoadWSDL")) {
            this.useBaseResourceAndURLToLoadWSDL = true;
            return 1;
        }
        if (args[i].equals("-XdisableAuthenticator")) {
            this.disableAuthenticator = true;
            return 1;
        }
        for (GeneratorExtension f : ServiceFinder.find(GeneratorExtension.class, ServiceLoader.load(GeneratorExtension.class))) {
            if (!f.validateOption(args[i])) continue;
            this.extensionOptions.put(args[i], this.requireArgument(args[i], args, ++i));
            return 2;
        }
        for (Plugin plugin : this.getAllPlugins()) {
            try {
                if (("-" + plugin.getOptionName()).equals(args[i])) {
                    this.activePlugins.add(plugin);
                    plugin.onActivated(this);
                    return 1;
                }
                int r = plugin.parseArgument(this, args, i);
                if (r == 0) continue;
                return r;
            }
            catch (IOException e) {
                throw new BadCommandLineException(e.getMessage(), e);
            }
        }
        return 0;
    }

    public void validate() throws BadCommandLineException {
        if (this.wsdls.isEmpty()) {
            throw new BadCommandLineException(WscompileMessages.WSIMPORT_MISSING_FILE());
        }
        if (this.wsdlLocation != null && this.clientjar != null) {
            throw new BadCommandLineException(WscompileMessages.WSIMPORT_WSDLLOCATION_CLIENTJAR());
        }
        if (this.wsdlLocation == null) {
            this.wsdlLocation = this.wsdls.get(0).getSystemId();
        }
    }

    @Override
    protected void addFile(String arg) throws BadCommandLineException {
        this.addFile(arg, this.wsdls, ".wsdl");
    }

    public Element getHandlerChainConfiguration() {
        if (this.handlerConfigs.size() > 0) {
            return this.handlerConfigs.get(0);
        }
        return null;
    }

    public void addHandlerChainConfiguration(Element config) {
        this.handlerConfigs.add(config);
    }

    public InputSource[] getWSDLs() {
        return this.wsdls.toArray(new InputSource[0]);
    }

    public InputSource[] getSchemas() {
        return this.schemas.toArray(new InputSource[0]);
    }

    public InputSource[] getWSDLBindings() {
        return this.jaxwsCustomBindings.toArray(new InputSource[0]);
    }

    public InputSource[] getSchemaBindings() {
        return this.jaxbCustomBindings.toArray(new InputSource[0]);
    }

    public void addWSDL(File source) {
        this.addWSDL(this.fileToInputSource(source));
    }

    public void addWSDL(InputSource is) {
        this.wsdls.add(this.absolutize(is));
    }

    public void addSchema(File source) {
        this.addSchema(this.fileToInputSource(source));
    }

    public void addSchema(InputSource is) {
        this.schemas.add(is);
    }

    private InputSource fileToInputSource(File source) {
        try {
            String url = source.toURI().toURL().toExternalForm();
            return new InputSource(Util.escapeSpace((String)url));
        }
        catch (MalformedURLException e) {
            return new InputSource(source.getPath());
        }
    }

    public void addGrammarRecursive(File dir) {
        this.addRecursive(dir, ".wsdl", this.wsdls);
        this.addRecursive(dir, ".xsd", this.schemas);
    }

    public void addWSDLBindFile(InputSource is) {
        this.jaxwsCustomBindings.add(new RereadInputSource(this.absolutize(is)));
    }

    public void addSchemmaBindFile(InputSource is) {
        this.jaxbCustomBindings.add(new RereadInputSource(this.absolutize(is)));
    }

    private void addRecursive(File dir, String suffix, List<InputSource> result) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                this.addRecursive(f, suffix, result);
                continue;
            }
            if (!f.getPath().endsWith(suffix)) continue;
            result.add(this.absolutize(this.fileToInputSource(f)));
        }
    }

    private InputSource absolutize(InputSource is) {
        try {
            URL baseURL = new File(".").getCanonicalFile().toURI().toURL();
            is.setSystemId(new URL(baseURL, is.getSystemId()).toExternalForm());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return is;
    }

    public void addBindings(String name) throws BadCommandLineException {
        this.addFile(name, this.bindingFiles, null);
    }

    private void addFile(String name, List<InputSource> target, String suffix) throws BadCommandLineException {
        Object src;
        try {
            src = Util.getFileOrURL((String)name);
        }
        catch (IOException e) {
            throw new BadCommandLineException(WscompileMessages.WSIMPORT_NOT_A_FILE_NOR_URL(name));
        }
        if (src instanceof URL) {
            target.add(this.absolutize(new InputSource(Util.escapeSpace((String)((URL)src).toExternalForm()))));
        } else {
            File fsrc = (File)src;
            if (fsrc.isDirectory()) {
                this.addRecursive(fsrc, suffix, target);
            } else {
                target.add(this.absolutize(this.fileToInputSource(fsrc)));
            }
        }
    }

    public final void parseBindings(ErrorReceiver receiver) {
        for (InputSource is : this.bindingFiles) {
            LocatorImpl locator;
            XMLStreamReader reader = XMLStreamReaderFactory.create(is, true);
            XMLStreamReaderUtil.nextElementContent(reader);
            if (reader.getName().equals(JAXWSBindingsConstants.JAXWS_BINDINGS)) {
                this.jaxwsCustomBindings.add(new RereadInputSource(is));
            } else if (reader.getName().equals(JAXWSBindingsConstants.JAXB_BINDINGS) || reader.getName().equals(new QName("http://www.w3.org/2001/XMLSchema", "schema"))) {
                this.jaxbCustomBindings.add(new RereadInputSource(is));
            } else if ("http://java.sun.com/xml/ns/jaxws".equals(reader.getNamespaceURI()) && "bindings".equals(reader.getLocalName())) {
                locator = new LocatorImpl();
                locator.setSystemId(reader.getLocation().getSystemId());
                locator.setPublicId(reader.getLocation().getPublicId());
                locator.setLineNumber(reader.getLocation().getLineNumber());
                locator.setColumnNumber(reader.getLocation().getColumnNumber());
                receiver.warning(locator, ConfigurationMessages.CONFIGURATION_OLD_BINDING_FILE(is.getSystemId()));
                this.jaxwsCustomBindings.add(new RereadInputSource(is));
            } else {
                locator = new LocatorImpl();
                locator.setSystemId(reader.getLocation().getSystemId());
                locator.setPublicId(reader.getLocation().getPublicId());
                locator.setLineNumber(reader.getLocation().getLineNumber());
                locator.setColumnNumber(reader.getLocation().getColumnNumber());
                receiver.warning(locator, ConfigurationMessages.CONFIGURATION_NOT_BINDING_FILE(is.getSystemId()));
            }
            if (is.getByteStream() == null) continue;
            try {
                is.getByteStream().close();
                is.setByteStream(null);
            }
            catch (IOException ex) {
                Logger.getLogger(WsimportOptions.class.getName()).log(Level.FINEST, null, ex);
            }
        }
    }

    public String getExtensionOption(String argument) {
        return this.extensionOptions.get(argument);
    }

    private void parseProxy(String text) throws BadCommandLineException {
        int i = text.lastIndexOf(64);
        int j = text.lastIndexOf(58);
        if (i > 0) {
            this.proxyAuth = text.substring(0, i);
            if (j > i) {
                this.proxyHost = text.substring(i + 1, j);
                this.proxyPort = text.substring(j + 1);
            } else {
                this.proxyHost = text.substring(i + 1);
                this.proxyPort = "8080";
            }
        } else if (j < 0) {
            this.proxyHost = text;
            this.proxyPort = "8080";
        } else {
            this.proxyHost = text.substring(0, j);
            this.proxyPort = text.substring(j + 1);
        }
        try {
            Integer.valueOf(this.proxyPort);
        }
        catch (NumberFormatException e) {
            throw new BadCommandLineException(WscompileMessages.WSIMPORT_ILLEGAL_PROXY(text));
        }
    }

    private static <T> T[] findServices(Class<T> clazz, ClassLoader classLoader) {
        ServiceFinder<T> serviceFinder = ServiceFinder.find(clazz, ServiceLoader.load(clazz, classLoader));
        ArrayList<T> r = new ArrayList<T>();
        for (T t : serviceFinder) {
            r.add(t);
        }
        return r.toArray((Object[])Array.newInstance(clazz, r.size()));
    }

    @Override
    protected void disableXmlSecurity() {
        super.disableXmlSecurity();
        this.schemaCompiler.getOptions().disableXmlSecurity = true;
    }

    private static final class RereadInputSource
    extends InputSource {
        private InputSource is;

        RereadInputSource(InputSource is) {
            this.is = is;
        }

        @Override
        public InputStream getByteStream() {
            InputStream i = this.is.getByteStream();
            if (i != null && !(i instanceof RereadInputStream)) {
                i = new RereadInputStream(i);
                this.is.setByteStream(i);
            }
            return i;
        }

        @Override
        public Reader getCharacterStream() {
            return this.is.getCharacterStream();
        }

        @Override
        public String getEncoding() {
            return this.is.getEncoding();
        }

        @Override
        public String getPublicId() {
            return this.is.getPublicId();
        }

        @Override
        public String getSystemId() {
            return this.is.getSystemId();
        }

        @Override
        public void setByteStream(InputStream byteStream) {
            this.is.setByteStream(byteStream);
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
            this.is.setCharacterStream(characterStream);
        }

        @Override
        public void setEncoding(String encoding) {
            this.is.setEncoding(encoding);
        }

        @Override
        public void setPublicId(String publicId) {
            this.is.setPublicId(publicId);
        }

        @Override
        public void setSystemId(String systemId) {
            this.is.setSystemId(systemId);
        }
    }

    private static final class RereadInputStream
    extends InputStream {
        private InputStream is;
        private ByteStream bs;

        RereadInputStream(InputStream is) {
            this.is = is;
            this.bs = new ByteStream();
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }

        @Override
        public void close() throws IOException {
            if (this.bs != null) {
                ByteArrayInputStream i = new ByteArrayInputStream(this.bs.getBuffer());
                this.bs = null;
                this.is.close();
                this.is = i;
            }
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.is.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this.is.markSupported();
        }

        @Override
        public int read() throws IOException {
            int r = this.is.read();
            if (this.bs != null) {
                this.bs.write(r);
            }
            return r;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int r = this.is.read(b, off, len);
            if (r > 0 && this.bs != null) {
                this.bs.write(b, off, r);
            }
            return r;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int r = this.is.read(b);
            if (r > 0 && this.bs != null) {
                this.bs.write(b, 0, r);
            }
            return r;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.is.reset();
        }
    }

    private static final class ByteStream
    extends ByteArrayOutputStream {
        private ByteStream() {
        }

        byte[] getBuffer() {
            return this.buf;
        }
    }
}

