
package com.sun.xml.wss.logging.saml;

import java.util.Locale;
import java.util.ResourceBundle;
import com.sun.istack.localization.Localizable;
import com.sun.istack.localization.LocalizableMessageFactory;
import com.sun.istack.localization.LocalizableMessageFactory.ResourceBundleSupplier;
import com.sun.istack.localization.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LogStringsMessages {

    private static final String BUNDLE_NAME = "com.sun.xml.wss.logging.saml.LogStrings";
    private static final LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LogStringsMessages.BundleSupplier());
    private static final Localizer LOCALIZER = new Localizer();

    private LogStringsMessages() {
    }

    public static Localizable localizableWSS_004_SAML_VERSION_NOT_SET() {
        return MESSAGE_FACTORY.getMessage("WSS004.SAML_VERSION_NOT_SET");
    }

    /**
     * WSS003: SAML Version is not set in the saml callback
     * 
     */
    public static String WSS_004_SAML_VERSION_NOT_SET() {
        return LOCALIZER.localize(localizableWSS_004_SAML_VERSION_NOT_SET());
    }

    public static Localizable localizableWSS_002_FAILED_CREATE_DOCUMENT() {
        return MESSAGE_FACTORY.getMessage("WSS002.failed.create.document");
    }

    /**
     * WSS002: Unable to create Document
     * 
     */
    public static String WSS_002_FAILED_CREATE_DOCUMENT() {
        return LOCALIZER.localize(localizableWSS_002_FAILED_CREATE_DOCUMENT());
    }

    public static Localizable localizableWSS_003_FAILEDTO_MARSHAL() {
        return MESSAGE_FACTORY.getMessage("WSS003.failedto.marshal");
    }

    /**
     * WSS003: Exception occured while trying to Marshal
     * 
     */
    public static String WSS_003_FAILEDTO_MARSHAL() {
        return LOCALIZER.localize(localizableWSS_003_FAILEDTO_MARSHAL());
    }

    public static Localizable localizableWSS_001_SAML_ASSERTION_NOT_FOUND(Object arg0) {
        return MESSAGE_FACTORY.getMessage("WSS001.SAML_ASSERTION_NOT_FOUND", arg0);
    }

    /**
     * WSS_SAML001: No SAML Assertion found with AssertionID: {0}
     * 
     */
    public static String WSS_001_SAML_ASSERTION_NOT_FOUND(Object arg0) {
        return LOCALIZER.localize(localizableWSS_001_SAML_ASSERTION_NOT_FOUND(arg0));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
