/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.common.endpoint;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.AddressingUtils;
import com.sun.xml.ws.api.message.MessageHeaders;
import com.sun.xml.ws.tx.at.WSATException;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.WSATXAResource;
import com.sun.xml.ws.tx.at.common.CoordinatorIF;
import com.sun.xml.ws.tx.at.common.WSATVersion;
import com.sun.xml.ws.tx.at.internal.XidImpl;
import com.sun.xml.ws.tx.at.localization.LocalizationMessages;
import com.sun.xml.ws.tx.at.runtime.TransactionServices;
import javax.transaction.xa.Xid;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;

public class Coordinator<T>
implements CoordinatorIF<T> {
    private static final Logger LOGGER = Logger.getLogger(Coordinator.class);
    private WebServiceContext context;
    private WSATVersion<T> version;

    public Coordinator(WebServiceContext m_context, WSATVersion<T> m_version) {
        this.context = m_context;
        this.version = m_version;
    }

    @Override
    public void preparedOperation(T parameters) {
        if (this.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4509_PREPARED_OPERATION_ENTERED(parameters));
        }
        Xid xidFromWebServiceContextHeaderList = this.getXid();
        if (this.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4510_PREPARED_OPERATION(xidFromWebServiceContextHeaderList));
        }
        if (!this.getWSATHelper().setDurableParticipantStatus(xidFromWebServiceContextHeaderList, "Prepared")) {
            this.replayOperation(parameters);
        }
        if (this.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4511_PREPARED_OPERATION_EXITED(parameters));
        }
    }

    @Override
    public void abortedOperation(T parameters) {
        if (this.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4512_ABORTED_OPERATION_ENTERED(parameters));
        }
        Xid xidFromWebServiceContextHeaderList = this.getXid();
        if (this.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4513_ABORTED_OPERATION(xidFromWebServiceContextHeaderList));
        }
        this.getWSATHelper().setDurableParticipantStatus(xidFromWebServiceContextHeaderList, "Aborted");
        if (this.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4514_ABORTED_OPERATION_EXITED(parameters));
        }
    }

    @Override
    public void readOnlyOperation(T parameters) {
        if (this.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4515_READ_ONLY_OPERATION_ENTERED(parameters));
        }
        Xid xidFromWebServiceContextHeaderList = this.getXid();
        if (this.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4516_READ_ONLY_OPERATION(xidFromWebServiceContextHeaderList));
        }
        this.getWSATHelper().setDurableParticipantStatus(xidFromWebServiceContextHeaderList, "ReadOnly");
        if (this.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4517_READ_ONLY_OPERATION_EXITED(parameters));
        }
    }

    @Override
    public void committedOperation(T parameters) {
        if (this.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4518_COMMITTED_OPERATION_ENTERED(parameters));
        }
        Xid xidFromWebServiceContextHeaderList = this.getXid();
        if (this.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4519_COMMITTED_OPERATION(xidFromWebServiceContextHeaderList));
        }
        this.getWSATHelper().setDurableParticipantStatus(xidFromWebServiceContextHeaderList, "Committed");
        if (this.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4520_COMMITTED_OPERATION_EXITED(parameters));
        }
    }

    @Override
    public void replayOperation(T parameters) {
        block5: {
            if (this.isDebugEnabled()) {
                LOGGER.info(LocalizationMessages.WSAT_4521_REPLAY_OPERATION_ENTERED(parameters));
            }
            Xid xidFromWebServiceContextHeaderList = this.getXid();
            String wsatTid = this.getWSATHelper().getWSATTidFromWebServiceContextHeaderList(this.context);
            if (this.isDebugEnabled()) {
                LOGGER.info(LocalizationMessages.WSAT_4522_REPLAY_OPERATION(xidFromWebServiceContextHeaderList));
            }
            try {
                this.getTransactionServices().replayCompletion(wsatTid, this.createWSATXAResourceForXidFromReplyTo(xidFromWebServiceContextHeaderList));
            }
            catch (WSATException e) {
                if (!this.isDebugEnabled()) break block5;
                LOGGER.severe(LocalizationMessages.WSAT_4523_REPLAY_OPERATION_SOAPEXCEPTION(xidFromWebServiceContextHeaderList), e);
            }
        }
        if (this.isDebugEnabled()) {
            LOGGER.info(LocalizationMessages.WSAT_4514_ABORTED_OPERATION_EXITED(parameters));
        }
    }

    protected TransactionServices getTransactionServices() {
        return WSATHelper.getTransactionServices();
    }

    WSATXAResource createWSATXAResourceForXidFromReplyTo(Xid xid) {
        MessageHeaders headerList = (MessageHeaders)this.context.getMessageContext().get((Object)"com.sun.xml.ws.api.message.HeaderList");
        WSEndpointReference wsReplyTo = AddressingUtils.getReplyTo(headerList, AddressingVersion.W3C, SOAPVersion.SOAP_12);
        EndpointReference replyTo = wsReplyTo.toSpec();
        return new WSATXAResource(this.version.getVersion(), replyTo, xid, true);
    }

    Xid getXid() {
        Xid xid = this.getWSATHelper().getXidFromWebServiceContextHeaderList(this.context);
        String bqual = this.getWSATHelper().getBQualFromWebServiceContextHeaderList(this.context);
        return new XidImpl(xid.getFormatId(), xid.getGlobalTransactionId(), bqual.getBytes());
    }

    boolean isDebugEnabled() {
        return WSATHelper.isDebugEnabled();
    }

    protected WSATHelper getWSATHelper() {
        return this.version.getWSATHelper();
    }
}

