/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.tools.file;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.pfl.basic.tools.file.FileWrapper;
import org.glassfish.pfl.basic.tools.file.Scanner;

public class Recognizer
implements Scanner.Action {
    private final int verbose;
    private final boolean dryRun;
    private final Map<String, Scanner.Action> nameActions;
    private final Map<String, Scanner.Action> suffixActions;
    private Scanner.Action shellScriptAction;
    private Scanner.Action defaultAction;

    Recognizer(int verbose, boolean dryRun) {
        this.verbose = verbose;
        this.dryRun = dryRun;
        this.nameActions = new HashMap<String, Scanner.Action>();
        this.suffixActions = new HashMap<String, Scanner.Action>();
        this.shellScriptAction = null;
        this.defaultAction = new Scanner.Action(){

            public String toString() {
                return "Built-in Default Action";
            }

            @Override
            public boolean evaluate(FileWrapper fw) {
                System.out.println("No action defined for " + fw);
                return false;
            }
        };
    }

    public void dump() {
        System.out.println("Contents of Recognizer:");
        System.out.println("verbose = " + this.verbose);
        System.out.println("dryRun = " + this.dryRun);
        System.out.println("Name actions:");
        for (Map.Entry<String, Scanner.Action> entry : this.nameActions.entrySet()) {
            System.out.println("\tName = " + entry.getKey() + ", Action = " + entry.getValue());
        }
        System.out.println("Suffix actions:");
        for (Map.Entry<String, Scanner.Action> entry : this.suffixActions.entrySet()) {
            System.out.println("\tSuffix = " + entry.getKey() + ", Action = " + entry.getValue());
        }
        System.out.println("Shell action:" + this.shellScriptAction);
        System.out.println("Default action:" + this.defaultAction);
    }

    public String toString() {
        return "Recognizer()";
    }

    public void addKnownName(String name, Scanner.Action action) {
        this.nameActions.put(name, action);
    }

    public void addKnownSuffix(String suffix, Scanner.Action action) {
        this.suffixActions.put(suffix, action);
    }

    public void setShellScriptAction(Scanner.Action action) {
        this.shellScriptAction = action;
    }

    public void setDefaultAction(Scanner.Action action) {
        if (action != null) {
            this.defaultAction = action;
        }
    }

    @Override
    public boolean evaluate(FileWrapper file) {
        int dotIndex;
        String name = file.getName();
        Scanner.Action action = this.nameActions.get(name);
        if (action == null && (dotIndex = name.lastIndexOf(46)) >= 0) {
            String suffix = name.substring(dotIndex + 1);
            action = this.suffixActions.get(suffix);
        }
        if (action == null) {
            try {
                file.open(FileWrapper.OpenMode.READ);
                String str = file.readLine();
                if (str != null && str.startsWith("#!")) {
                    action = this.shellScriptAction;
                }
                file.close();
            }
            catch (IOException exc) {
                System.out.println("Could not read file " + file + " to check for shell script");
            }
        }
        if (action == null) {
            action = this.defaultAction;
        }
        if (this.verbose > 1) {
            System.out.println("Recognizer: calling action " + action + " on file " + file);
        }
        if (!this.dryRun) {
            return action.evaluate(file);
        }
        return true;
    }
}

