/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.persistent;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.rm.runtime.LocalIDManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.ConnectionManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.DataSourceProvider;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.DefaultDataSourceProvider;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.PersistenceException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;

public class JDBCLocalIDManager
implements LocalIDManager {
    private static final Logger LOGGER = Logger.getLogger(JDBCLocalIDManager.class);
    private ConnectionManager cm;

    public JDBCLocalIDManager() {
        this(new DefaultDataSourceProvider());
    }

    public JDBCLocalIDManager(DataSourceProvider dataSourceProvider) {
        this.cm = ConnectionManager.getInstance(dataSourceProvider);
    }

    @Override
    public void createLocalID(String localID, String sequenceID, long messageNumber) {
        Connection con = this.cm.getConnection();
        PreparedStatement ps = null;
        try {
            ps = this.cm.prepareStatement(con, "INSERT INTO RM_LOCALIDS (LOCAL_ID, SEQ_ID, MSG_NUMBER, CREATE_TIME) VALUES (?, ?, ?, ?)");
            ps.setString(1, localID);
            ps.setString(2, sequenceID);
            ps.setLong(3, messageNumber);
            ps.setLong(4, System.currentTimeMillis());
            int rowCount = ps.executeUpdate();
            if (rowCount != 1) {
                this.cm.rollback(con);
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Inserting LocalID failed."))));
            }
            this.cm.commit(con);
        }
        catch (Throwable ex) {
            try {
                this.cm.rollback(con);
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Inserting LocalID failed: An unexpected JDBC exception occured", ex))));
            }
            catch (Throwable throwable) {
                this.cm.recycle(ps);
                this.cm.recycle(con);
                throw throwable;
            }
        }
        this.cm.recycle(ps);
        this.cm.recycle(con);
    }

    @Override
    public void removeLocalIDs(Iterator<String> localIDs) {
        if (localIDs != null && localIDs.hasNext()) {
            StringBuffer ids = new StringBuffer();
            while (localIDs.hasNext()) {
                ids.append('\'');
                ids.append(localIDs.next());
                ids.append('\'');
                if (!localIDs.hasNext()) continue;
                ids.append(',');
            }
            this.doRemove(ids.toString());
        }
    }

    private void doRemove(String ids) {
        Connection con = this.cm.getConnection();
        PreparedStatement ps = null;
        try {
            ps = this.cm.prepareStatement(con, "DELETE FROM RM_LOCALIDS WHERE LOCAL_ID IN (" + ids + ")");
            ps.executeUpdate();
            this.cm.commit(con);
        }
        catch (Throwable ex) {
            try {
                this.cm.rollback(con);
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Removing LocalID failed: An unexpected JDBC exception occured", ex))));
            }
            catch (Throwable throwable) {
                this.cm.recycle(ps);
                this.cm.recycle(con);
                throw throwable;
            }
        }
        this.cm.recycle(ps);
        this.cm.recycle(con);
    }

    @Override
    public LocalIDManager.BoundMessage getBoundMessage(String localID) {
        LocalIDManager.BoundMessage result = null;
        Connection con = this.cm.getConnection();
        PreparedStatement ps = null;
        try {
            ps = this.cm.prepareStatement(con, "SELECT SEQ_ID, MSG_NUMBER, CREATE_TIME, SEQ_TERMINATE_TIME FROM RM_LOCALIDS WHERE LOCAL_ID=?");
            ps.setString(1, localID);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new LocalIDManager.BoundMessage(rs.getString("SEQ_ID"), rs.getLong("MSG_NUMBER"), rs.getLong("CREATE_TIME"), rs.getLong("SEQ_TERMINATE_TIME"));
            }
            this.cm.commit(con);
        }
        catch (SQLException ex) {
            try {
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Retrieving LocalID failed: An unexpected JDBC exception occured", ex))));
            }
            catch (Throwable throwable) {
                this.cm.recycle(ps);
                this.cm.recycle(con);
                throw throwable;
            }
        }
        this.cm.recycle(ps);
        this.cm.recycle(con);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markSequenceTermination(String sequenceID) {
        Connection con = this.cm.getConnection();
        PreparedStatement ps = null;
        try {
            ps = this.cm.prepareStatement(con, "UPDATE RM_LOCALIDS SET SEQ_TERMINATE_TIME=? WHERE SEQ_ID=?");
            ps.setLong(1, System.currentTimeMillis());
            ps.setString(2, sequenceID);
            ps.executeUpdate();
            this.cm.commit(con);
        }
        catch (Throwable ex) {
            try {
                this.cm.rollback(con);
                LOGGER.warning("Failed to mark sequence termination in RM_LOCALIDS table due to error: " + ex.getMessage());
            }
            catch (Throwable throwable) {
                this.cm.recycle(ps);
                this.cm.recycle(con);
                throw throwable;
            }
            this.cm.recycle(ps);
            this.cm.recycle(con);
        }
        this.cm.recycle(ps);
        this.cm.recycle(con);
    }
}

